/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ide.ergonomics.fod.ConfigurationPanel;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FoDLayersProvider;
import org.netbeans.spi.debugger.ui.AttachType;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.filesystems.FileObject;

public class AttachTypeProxy
extends AttachType
implements Controller,
Callable<JComponent> {
    private AttachType delegate = null;
    private boolean isVisible = true;
    private String attachTypeName;
    PropertyChangeSupport propertyChangeSupport;
    private FeatureInfo featureInfo;

    private AttachTypeProxy(String attachTypeName, FeatureInfo whichProvides) {
        this.attachTypeName = attachTypeName;
        this.featureInfo = whichProvides;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public static AttachType create(FileObject fob) {
        FeatureInfo whichProvides = FoDLayersProvider.getInstance().whichProvides(fob);
        String displayName = (String)fob.getAttribute("displayName");
        if (displayName == null) {
            throw new IllegalArgumentException("No displayName attribute: " + fob);
        }
        return new AttachTypeProxy(displayName, whichProvides);
    }

    public String getTypeDisplayName() {
        if (!this.isVisible) {
            return null;
        }
        if (this.getAttachType() != null) {
            this.isVisible = false;
            return null;
        }
        if (this.delegate != null) {
            return this.delegate.getTypeDisplayName();
        }
        return this.attachTypeName;
    }

    public JComponent getCustomizer() {
        if (this.delegate == null) {
            return new ConfigurationPanel(this.attachTypeName, this, this.featureInfo);
        }
        return this.delegate.getCustomizer();
    }

    public Controller getController() {
        if (this.delegate == null) {
            return this;
        }
        return this.getRealController();
    }

    private void invalidate() {
        this.isVisible = false;
        this.delegate = this.getAttachType();
        this.propertyChangeSupport.firePropertyChange("valid", false, true);
    }

    AttachType getAttachType() {
        for (AttachType type : DebuggerManager.getDebuggerManager().lookup(null, AttachType.class)) {
            if (type instanceof AttachTypeProxy || !type.getTypeDisplayName().equals(this.attachTypeName)) continue;
            return type;
        }
        return null;
    }

    public boolean isValid() {
        return this.delegate == null ? false : this.getRealController().isValid();
    }

    public boolean ok() {
        return this.delegate != null ? this.getRealController().ok() : false;
    }

    public boolean cancel() {
        return this.delegate == null ? true : this.getRealController().cancel();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public JComponent call() throws Exception {
        this.invalidate();
        return this.getCustomizer();
    }

    private Controller getRealController() {
        Controller controller = null;
        if (this.delegate != null) {
            JComponent c = this.delegate.getCustomizer();
            controller = this.delegate.getController();
        }
        return controller;
    }
}

