/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.ModelUtils;
import org.netbeans.modules.css.model.api.PropertyDeclaration;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.visual.Bundle;
import org.netbeans.modules.css.visual.CssCaretAwareSourceTask;
import org.netbeans.modules.css.visual.CustomToolbar;
import org.netbeans.modules.css.visual.PropertyUtils;
import org.netbeans.modules.css.visual.RuleEditorNode;
import org.netbeans.modules.css.visual.RuleEditorViews;
import org.netbeans.modules.css.visual.ViewActions;
import org.netbeans.modules.css.visual.actions.AddPropertyAction;
import org.netbeans.modules.css.visual.actions.GoToSourceAction;
import org.netbeans.modules.css.visual.actions.RemovePropertyAction;
import org.netbeans.modules.css.visual.api.DeclarationInfo;
import org.netbeans.modules.css.visual.api.EditCSSRulesAction;
import org.netbeans.modules.css.visual.api.RuleEditorController;
import org.netbeans.modules.css.visual.api.ViewMode;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class RuleEditorPanel
extends JPanel {
    static final Logger LOG = Logger.getLogger("rule.editor");
    static RequestProcessor RP = new RequestProcessor(CssCaretAwareSourceTask.class);
    private static final Icon ERROR_ICON = ImageUtilities.loadIcon((String)"org/netbeans/modules/css/visual/resources/error-glyph.gif");
    private static final Icon APPLIED_ICON = ImageUtilities.loadIcon((String)"org/netbeans/modules/css/visual/resources/database.gif");
    private final JLabel errorLabel;
    private final JLabel appliedLabel;
    private REPropertySheet sheet;
    private Model model;
    private Rule rule;
    private Action addPropertyAction;
    private Action[] actions;
    private RuleEditorViews views;
    private CustomToolbar toolbar;
    private ViewMode viewMode;
    public RuleEditorNode node;
    private final PropertyChangeSupport CHANGE_SUPPORT = new PropertyChangeSupport(this);
    private boolean addPropertyMode;
    private PropertyDeclaration createdDeclaration;
    private PropertyDeclaration editedDeclaration;
    private final List<String> createdDeclarationsIdsList = new ArrayList<String>();
    private final PropertyChangeListener MODEL_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    switch (evt.getPropertyName()) {
                        case "no.changes.to.apply": {
                            RuleEditorPanel.this.node.fireContextChanged(false);
                            break;
                        }
                        case "changes.applied": {
                            RuleEditorPanel.this.northWestPanel.add(RuleEditorPanel.this.appliedLabel);
                            RuleEditorPanel.this.northWestPanel.revalidate();
                            RuleEditorPanel.this.northWestPanel.repaint();
                            RuleEditorPanel.this.refreshModel();
                            break;
                        }
                        case "model.write.task.finished": {
                            if (RuleEditorPanel.this.createdDeclaration == null) break;
                            RuleEditorPanel.this.node.fireContextChanged(false);
                            RuleEditorPanel.this.editCreatedDeclaration();
                        }
                    }
                }
            });
        }
    };
    private JLabel cancelFilterLabel;
    private JToggleButton createPropertyToggleButton;
    private JTextField filterTextField;
    private JToggleButton filterToggleButton;
    private JLabel messageLabel;
    private JPanel northEastPanel;
    private JPanel northPanel;
    private JPanel northWestPanel;
    private JLabel titleLabel;

    public RuleEditorPanel() {
        this(false);
    }

    public RuleEditorPanel(boolean addPropertyMode) {
        this.addPropertyMode = addPropertyMode;
        this.addPropertyAction = new AddPropertyAction(this);
        this.initComponents();
        this.errorLabel = new JLabel(ERROR_ICON);
        this.errorLabel.setToolTipText(Bundle.label_rule_error_tooltip());
        this.appliedLabel = new JLabel(APPLIED_ICON);
        this.node = new RuleEditorNode(this);
        this.viewMode = addPropertyMode ? ViewMode.CATEGORIZED : ViewMode.UPDATED_ONLY;
        this.views = new RuleEditorViews(this);
        this.toolbar = new CustomToolbar();
        if (!addPropertyMode) {
            this.toolbar.addButton(this.filterToggleButton);
            this.toolbar.addLineSeparator();
            this.toolbar.addButton(this.views.getUpdatedOnlyToggleButton());
            this.toolbar.addSpaceSeparator();
        } else {
            this.toolbar.addLineSeparator();
        }
        this.toolbar.addButton(this.views.getCategorizedToggleButton());
        this.toolbar.addSpaceSeparator();
        this.toolbar.addButton(this.views.getAllToggleButton());
        this.addRuleEditorListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(RuleEditorController.PropertyNames.RULE_SET.name())) {
                    RuleEditorPanel.this.addPropertyAction.setEnabled(evt.getNewValue() != null && RuleEditorPanel.this.model.canApplyChanges());
                }
            }
        });
        Action[] viewActions = new ViewActions(this.views).getActions();
        this.actions = new Action[]{this.addPropertyAction, null, viewActions[0], viewActions[1], viewActions[2]};
        JPopupMenu pm = new JPopupMenu();
        for (Action action : this.actions) {
            if (action != null) {
                if (action instanceof Presenter.Popup) {
                    pm.add(((Presenter.Popup)action).getPopupPresenter());
                    continue;
                }
                pm.add(action);
                continue;
            }
            pm.addSeparator();
        }
        JPopupMenu buildButtonPopup = new JPopupMenu();
        if (!addPropertyMode) {
            this.setComponentPopupMenu(pm);
            buildButtonPopup.add(this.addPropertyAction);
            this.toolbar.addLineSeparator();
            this.toolbar.addButton(this.createPropertyToggleButton);
        }
        this.titleLabel.setText(null);
        this.sheet = new REPropertySheet(buildButtonPopup);
        try {
            this.sheet.setSortingMode(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.sheet.setPopupEnabled(true);
        this.sheet.setDescriptionAreaVisible(false);
        this.sheet.setNodes(new Node[]{this.node});
        this.add((Component)((Object)this.sheet), "Center");
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            private void contentChanged() {
                RuleEditorPanel.this.node.setFilterText(RuleEditorPanel.this.filterTextField.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.contentChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.contentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.setFilterVisible(addPropertyMode);
        this.northEastPanel.add((Component)this.toolbar, "West");
    }

    public void refreshModel() {
        Document doc;
        if (this.model != null && (doc = (Document)this.model.getLookup().lookup(Document.class)) != null) {
            try {
                Source source = Source.create((Document)doc);
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        if ((resultIterator = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css")) != null) {
                            CssParserResult result = (CssParserResult)resultIterator.getParserResult();
                            Model model = Model.getModel((CssParserResult)result);
                            LOG.log(Level.FINE, "Model.CHANGES_APPLIED_TO_DOCUMENT event handler - setting new model {0}", model);
                            RuleEditorPanel.this.setModel(model);
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void componentDeactivated() {
        this.createdDeclarationsIdsList.clear();
        this.createdDeclaration = null;
        this.node.fireContextChanged(true);
    }

    public FeatureDescriptor getSelected() {
        return this.sheet.getSelectedFeatureDescriptor();
    }

    void setCreatedDeclaration(Rule rule, PropertyDeclaration declaration) {
        this.createdDeclaration = declaration;
        String declarationId = PropertyUtils.getDeclarationId(rule, declaration);
        this.createdDeclarationsIdsList.add(declarationId);
    }

    public void disposeEditedDeclaration() {
        final PropertyDeclaration remove = this.editedDeclaration;
        if (remove != null) {
            this.model.runWriteTask(new Model.ModelTask(){

                public void run(StyleSheet styleSheet) {
                    Declaration declaration = (Declaration)remove.getParent();
                    Declarations declarations = (Declarations)declaration.getParent();
                    declaration.removeElement((Element)remove);
                    declarations.removeDeclaration(declaration);
                }
            });
            this.node.fireContextChanged(true);
        }
    }

    public void editingFinished() {
        this.editedDeclaration = null;
    }

    PropertyDeclaration getCreatedDeclaration() {
        return this.createdDeclaration;
    }

    List<String> getCreatedDeclarationsIdsList() {
        return this.createdDeclarationsIdsList;
    }

    private void editCreatedDeclaration() {
        RuleEditorNode.DeclarationProperty descriptor = this.node.getDeclarationProperty(this.createdDeclaration);
        if (descriptor != null) {
            this.sheet.requestFocus();
            try {
                this.call_PropertySheet_select(this.sheet, (FeatureDescriptor)((Object)descriptor), true);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.editedDeclaration = this.createdDeclaration;
            this.createdDeclaration = null;
        }
    }

    private void call_PropertySheet_select(PropertySheet sheet, FeatureDescriptor descriptor, boolean edit) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<PropertySheet> clz = PropertySheet.class;
        Method select_method = clz.getDeclaredMethod("select", FeatureDescriptor.class, Boolean.TYPE);
        select_method.setAccessible(true);
        select_method.invoke((Object)sheet, descriptor, edit);
    }

    public boolean isAddPropertyMode() {
        return this.addPropertyMode;
    }

    public ViewMode getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(ViewMode mode) {
        if (this.viewMode == mode) {
            return;
        }
        this.viewMode = mode;
        this.node.fireContextChanged(true);
    }

    public Model getModel() {
        return this.model;
    }

    public void releaseModel() {
        if (this.model == null) {
            return;
        }
        this.setNoRuleState();
        this.model.removePropertyChangeListener(this.MODEL_LISTENER);
        this.model = null;
    }

    public void setModel(final Model model) {
        assert (SwingUtilities.isEventDispatchThread());
        if (model == null) {
            throw new NullPointerException();
        }
        if (this.model != null) {
            if (model.getSerialNumber() == this.model.getSerialNumber()) {
                LOG.log(Level.FINE, "attempt to set the same model");
                return;
            }
            FileObject old = (FileObject)this.model.getLookup().lookup(FileObject.class);
            FileObject neww = (FileObject)model.getLookup().lookup(FileObject.class);
            assert (old != null);
            assert (neww != null);
            if (neww != null && neww.equals(old) && model.getSerialNumber() < this.model.getSerialNumber()) {
                LOG.log(Level.WARNING, "attempt to set the older model {0} while the current is {1}!!!", new Object[]{model, this.model});
                return;
            }
            this.model.removePropertyChangeListener(this.MODEL_LISTENER);
        }
        final Model oldModel = this.model;
        final Rule oldRule = this.rule;
        this.model = model;
        LOG.log(Level.FINE, "set new model ({0})", model);
        this.model.addPropertyChangeListener(this.MODEL_LISTENER);
        this.northWestPanel.remove(this.appliedLabel);
        this.northWestPanel.validate();
        this.northWestPanel.repaint();
        this.CHANGE_SUPPORT.firePropertyChange(RuleEditorController.PropertyNames.MODEL_SET.name(), oldModel, this.model);
        EditCSSRulesAction.getDefault().setContext((FileObject)model.getLookup().lookup(FileObject.class));
        if (this.rule != null) {
            final AtomicReference rule_ref = new AtomicReference();
            this.model.runReadTask(new Model.ModelTask(){

                public void run(StyleSheet styleSheet) {
                    ModelUtils utils = new ModelUtils(model);
                    rule_ref.set(utils.findMatchingRule(oldModel, oldRule));
                }
            });
            Rule match = (Rule)rule_ref.get();
            if (match == null) {
                this.setNoRuleState();
            } else {
                this.setRule(match);
            }
            this.CHANGE_SUPPORT.firePropertyChange(RuleEditorController.PropertyNames.RULE_SET.name(), oldRule, match);
        } else {
            LOG.log(Level.FINER, "no rule was set before");
            this.CHANGE_SUPPORT.firePropertyChange(RuleEditorController.PropertyNames.RULE_SET.name(), oldRule, this.rule);
        }
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(final Rule rule) {
        assert (SwingUtilities.isEventDispatchThread());
        if (rule == null) {
            throw new NullPointerException();
        }
        if (this.model == null) {
            throw new IllegalStateException("you must call setModel(Model model) beforehand!");
        }
        Model ruleModel = rule.getModel();
        if (ruleModel != this.model) {
            LOG.log(Level.FINE, "attempt to set rule from different model {0}, while the current is {1}!", new Object[]{ruleModel, this.model});
            return;
        }
        if (this.rule == rule) {
            LOG.log(Level.FINE, "attempt to set the same rule");
            return;
        }
        Rule old = this.rule;
        this.rule = rule;
        LOG.log(Level.FINE, "set new rule ({0})", rule);
        this.CHANGE_SUPPORT.firePropertyChange(RuleEditorController.PropertyNames.RULE_SET.name(), old, this.rule);
        this.northWestPanel.revalidate();
        this.node.fireContextChanged(old == null || !old.isValid() || !rule.isValid());
        final AtomicReference ruleNameRef = new AtomicReference();
        this.model.runReadTask(new Model.ModelTask(){

            public void run(StyleSheet stylesheet) {
                ruleNameRef.set(RuleEditorPanel.this.model.getElementSource((Element)rule.getSelectorsGroup()).toString());
            }
        });
        this.titleLabel.setText(Bundle.titleLabel_text(ruleNameRef.get()));
        this.titleLabel.setToolTipText(null);
        this.titleLabel.setEnabled(true);
        this.messageLabel.setText(null);
    }

    public void setNoRuleState() {
        LOG.log(Level.FINER, "setNoRuleState()");
        assert (SwingUtilities.isEventDispatchThread());
        Rule old = this.rule;
        this.rule = null;
        this.CHANGE_SUPPORT.firePropertyChange(RuleEditorController.PropertyNames.RULE_SET.name(), old, null);
        this.titleLabel.setText(Bundle.titleLabel_no_selected_rule());
        this.titleLabel.setToolTipText(Bundle.titleLabel_tooltip_no_selected_rule());
        this.titleLabel.setEnabled(false);
        this.messageLabel.setText(null);
        this.node.fireContextChanged(false);
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    public void setDeclarationInfo(PropertyDeclaration declaration, DeclarationInfo declarationInfo) {
        this.node.fireDeclarationInfoChanged(declaration, declarationInfo);
    }

    public final void addRuleEditorListener(PropertyChangeListener listener) {
        this.CHANGE_SUPPORT.addPropertyChangeListener(listener);
    }

    public final void removeRuleEditorListener(PropertyChangeListener listener) {
        this.CHANGE_SUPPORT.removePropertyChangeListener(listener);
    }

    public Action[] getActions() {
        return this.actions;
    }

    private void initComponents() {
        this.cancelFilterLabel = new JLabel();
        this.filterTextField = new JTextField();
        this.filterToggleButton = new JToggleButton();
        this.createPropertyToggleButton = new JToggleButton();
        this.northPanel = new JPanel();
        this.northEastPanel = new JPanel();
        this.northWestPanel = new JPanel();
        this.titleLabel = new JLabel(){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                return new Dimension(0, dim.height);
            }
        };
        this.messageLabel = new JLabel();
        this.cancelFilterLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/css/visual/resources/cancel.png")));
        this.cancelFilterLabel.setText(NbBundle.getMessage(RuleEditorPanel.class, (String)"RuleEditorPanel.cancelFilterLabel.text"));
        this.cancelFilterLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RuleEditorPanel.this.cancelFilterLabelMouseClicked(evt);
            }
        });
        this.filterTextField.setText(NbBundle.getMessage(RuleEditorPanel.class, (String)"RuleEditorPanel.filterTextField.text"));
        this.filterTextField.setToolTipText(NbBundle.getMessage(RuleEditorPanel.class, (String)"DocumentViewPanel.filterToggleButton.toolTipText"));
        this.filterTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.filterTextField.setMinimumSize(new Dimension(60, 28));
        this.filterToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/css/visual/resources/find.png")));
        this.filterToggleButton.setText(null);
        this.filterToggleButton.setToolTipText(NbBundle.getMessage(RuleEditorPanel.class, (String)"DocumentViewPanel.filterToggleButton.toolTipText"));
        this.filterToggleButton.setFocusable(false);
        this.filterToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleEditorPanel.this.filterToggleButtonActionPerformed(evt);
            }
        });
        this.createPropertyToggleButton.setAction(this.addPropertyAction);
        this.createPropertyToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/css/visual/resources/newProperty.png")));
        this.createPropertyToggleButton.setText(null);
        this.createPropertyToggleButton.setToolTipText(NbBundle.getMessage(RuleEditorPanel.class, (String)"RuleEditorPanel.createPropertyToggleButton.toolTipText"));
        this.createPropertyToggleButton.setFocusable(false);
        this.createPropertyToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleEditorPanel.this.createPropertyToggleButtonActionPerformed(evt);
            }
        });
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new BorderLayout());
        this.northPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.northPanel.setLayout(new BorderLayout());
        this.northEastPanel.setLayout(new BorderLayout());
        this.northPanel.add((Component)this.northEastPanel, "East");
        this.northWestPanel.setLayout(new BoxLayout(this.northWestPanel, 2));
        this.titleLabel.setHorizontalTextPosition(2);
        this.titleLabel.setPreferredSize(new Dimension(100, 16));
        this.northWestPanel.add(this.titleLabel);
        this.northPanel.add((Component)this.northWestPanel, "Center");
        this.messageLabel.setForeground(new Color(255, 0, 0));
        this.northPanel.add((Component)this.messageLabel, "Last");
        this.add((Component)this.northPanel, "North");
    }

    private void cancelFilterLabelMouseClicked(MouseEvent evt) {
        this.filterTextField.setText(null);
    }

    private void setFilterVisible(boolean visible) {
        this.northWestPanel.removeAll();
        if (visible) {
            this.northWestPanel.add((Component)this.filterTextField, "Center");
            this.cancelFilterLabel.setBorder(new EmptyBorder(0, 4, 0, 0));
            if (this.addPropertyMode) {
                this.northWestPanel.add((Component)this.cancelFilterLabel, "West");
            }
            this.node.setFilterText(this.filterTextField.getText());
            this.filterTextField.requestFocus();
        } else {
            this.northWestPanel.add(this.titleLabel);
            this.node.setFilterText(null);
        }
        this.northWestPanel.revalidate();
        this.northWestPanel.repaint();
    }

    private void filterToggleButtonActionPerformed(ActionEvent evt) {
        this.setFilterVisible(this.filterToggleButton.isSelected());
    }

    private void createPropertyToggleButtonActionPerformed(ActionEvent evt) {
        this.createPropertyToggleButton.setSelected(false);
    }

    private class REPropertySheet
    extends PropertySheet {
        private final JPopupMenu genericPopupMenu;

        public REPropertySheet(JPopupMenu genericPopupMenu) {
            this.genericPopupMenu = genericPopupMenu;
        }

        public FeatureDescriptor getSelectedFeatureDescriptor() {
            return super.getSelection();
        }

        protected JPopupMenu createPopupMenu() {
            FeatureDescriptor fd = this.getSelection();
            if (fd != null) {
                if (fd instanceof RuleEditorNode.DeclarationProperty) {
                    JPopupMenu pm = new JPopupMenu();
                    if (!RuleEditorPanel.this.addPropertyMode) {
                        pm.add(new GoToSourceAction(RuleEditorPanel.this, (RuleEditorNode.DeclarationProperty)((Object)fd)));
                        pm.addSeparator();
                        pm.add(new RemovePropertyAction(RuleEditorPanel.this, (RuleEditorNode.DeclarationProperty)((Object)fd)));
                    }
                    return pm;
                }
                if (fd instanceof RuleEditorNode.PropertyCategoryPropertySet) {
                    // empty if block
                }
            }
            return this.genericPopupMenu;
        }
    }
}

