/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.selenium2.webclient.api.SeleniumTestingProvider;
import org.netbeans.modules.selenium2.webclient.api.SeleniumTestingProviders;
import org.netbeans.modules.selenium2.webclient.ui.customizer.SeleniumTestingProviderAccessor;
import org.netbeans.modules.selenium2.webclient.ui.customizer.SeleniumTestingProviderRenderer;
import org.netbeans.modules.web.clientproject.spi.CustomizerPanelImplementation;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CustomizerSeleniumTesting
extends JPanel
implements ChangeListener {
    private final ProjectCustomizer.Category category;
    private final Project project;
    private final SeleniumTestingProvider originalProvider;
    private final Map<SeleniumTestingProvider, CustomizerPanelImplementation> providerPanels;
    volatile SeleniumTestingProvider selectedProvider;
    volatile CustomizerPanelImplementation selectedPanel;
    private JComboBox providerComboBox;
    private JLabel providerLabel;
    private JPanel providerPanel;
    private JSeparator separator;

    public CustomizerSeleniumTesting(ProjectCustomizer.Category category, Project project) {
        assert (EventQueue.isDispatchThread());
        assert (category != null);
        assert (project != null);
        this.category = category;
        this.project = project;
        this.originalProvider = SeleniumTestingProviders.getDefault().getSeleniumTestingProvider(project, false);
        this.providerPanels = this.createProviderPanels();
        this.selectedProvider = this.originalProvider;
        this.selectedPanel = this.getSelectedPanel();
        this.initComponents();
        this.init();
    }

    private Map<SeleniumTestingProvider, CustomizerPanelImplementation> createProviderPanels() {
        HashMap<SeleniumTestingProvider, CustomizerPanelImplementation> panels = new HashMap<SeleniumTestingProvider, CustomizerPanelImplementation>();
        for (SeleniumTestingProvider provider : SeleniumTestingProviders.getDefault().getSeleniumTestingProviders()) {
            panels.put(provider, SeleniumTestingProviderAccessor.getDefault().createCustomizerPanel(provider, this.project));
        }
        return panels;
    }

    private void init() {
        this.providerComboBox.addItem(null);
        for (SeleniumTestingProvider provider : SeleniumTestingProviders.getDefault().getSeleniumTestingProviders()) {
            this.providerComboBox.addItem(provider);
        }
        this.providerComboBox.setSelectedItem(this.originalProvider);
        this.providerComboBox.setRenderer(new SeleniumTestingProviderRenderer());
        this.providerComboBox.addActionListener(new ProviderActionListener());
        this.category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizerSeleniumTesting.this.storeData();
            }
        });
        this.category.setCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizerSeleniumTesting.this.cleanup();
            }
        });
        this.providerChanged();
    }

    void providerChanged() {
        assert (EventQueue.isDispatchThread());
        if (this.selectedPanel != null) {
            this.selectedPanel.removeChangeListener((ChangeListener)this);
        }
        this.providerPanel.removeAll();
        this.selectedProvider = (SeleniumTestingProvider)this.providerComboBox.getSelectedItem();
        this.selectedPanel = this.getSelectedPanel();
        if (this.selectedPanel != null) {
            this.selectedPanel.addChangeListener((ChangeListener)this);
            this.providerPanel.add((Component)this.selectedPanel.getComponent(), "Center");
        }
        this.providerPanel.revalidate();
        this.providerPanel.repaint();
        this.validateData();
    }

    void validateData() {
        assert (EventQueue.isDispatchThread());
        if (this.selectedProvider == null) {
            this.category.setErrorMessage(null);
            this.category.setValid(true);
            return;
        }
        if (this.selectedPanel == null) {
            this.category.setErrorMessage(null);
            this.category.setValid(true);
            return;
        }
        if (this.selectedPanel.isValid()) {
            this.category.setErrorMessage(this.selectedPanel.getWarningMessage());
            this.category.setValid(true);
            return;
        }
        assert (this.selectedPanel.getErrorMessage() != null) : "Error must be return for invalid panel of " + this.selectedProvider;
        this.category.setErrorMessage(this.selectedPanel.getErrorMessage());
        this.category.setValid(false);
    }

    void storeData() {
        assert (!EventQueue.isDispatchThread());
        if (this.selectedPanel != null) {
            this.selectedPanel.save();
        }
        if (Objects.equals(this.originalProvider, this.selectedProvider)) {
            return;
        }
        if (this.originalProvider != null) {
            SeleniumTestingProviderAccessor.getDefault().notifyEnabled(this.originalProvider, this.project, false);
        }
        if (this.selectedProvider != null) {
            SeleniumTestingProviderAccessor.getDefault().notifyEnabled(this.selectedProvider, this.project, true);
        }
    }

    void cleanup() {
        if (this.selectedPanel != null) {
            this.selectedPanel.removeChangeListener((ChangeListener)this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.validateData();
    }

    @CheckForNull
    private CustomizerPanelImplementation getSelectedPanel() {
        assert (EventQueue.isDispatchThread());
        assert (this.providerPanels != null);
        return this.providerPanels.get(this.selectedProvider);
    }

    private void initComponents() {
        this.providerLabel = new JLabel();
        this.providerComboBox = new JComboBox();
        this.separator = new JSeparator();
        this.providerPanel = new JPanel();
        this.providerLabel.setLabelFor(this.providerComboBox);
        Mnemonics.setLocalizedText((JLabel)this.providerLabel, (String)NbBundle.getMessage(CustomizerSeleniumTesting.class, (String)"CustomizerSeleniumTesting.providerLabel.text"));
        this.providerPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.providerPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.providerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.providerComboBox, -2, -1, -2)).addComponent(this.separator)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.providerLabel).addComponent(this.providerComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.providerPanel, -1, -1, Short.MAX_VALUE)));
    }

    private final class ProviderActionListener
    implements ActionListener {
        private ProviderActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomizerSeleniumTesting.this.providerChanged();
        }
    }
}

