/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders.multiview.common;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.PortComponentRef;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.sun.ddloaders.Utils;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.common.CommonBeanReader;
import org.openide.ErrorManager;

public class PortComponentRefMetadataReader
extends CommonBeanReader {
    private String serviceRefName;
    private String ejbName;

    public PortComponentRefMetadataReader(String serviceRefName, String ejbName) {
        super("PortComponentRef");
        this.serviceRefName = serviceRefName;
        this.ejbName = ejbName;
    }

    @Override
    protected CommonDDBean normalizeParent(CommonDDBean parent) {
        if (this.ejbName != null && parent instanceof EjbJar) {
            parent = this.findEjbByName((EjbJar)parent, this.ejbName);
        }
        if (this.serviceRefName != null && parent != null) {
            parent = this.findServiceRefByName(parent, this.serviceRefName);
        }
        return parent;
    }

    protected CommonDDBean findServiceRefByName(CommonDDBean parent, String serviceRefName) {
        CommonDDBean match = null;
        try {
            ServiceRef[] serviceRefs = null;
            if (parent instanceof WebApp) {
                serviceRefs = ((WebApp)parent).getServiceRef();
            } else if (parent instanceof Ejb) {
                serviceRefs = ((Ejb)parent).getServiceRef();
            } else if (parent instanceof AppClient) {
                serviceRefs = ((AppClient)parent).getServiceRef();
            } else {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unsupported parent for service-ref field in standard descriptor: " + parent));
            }
            match = this.findServiceRefByName(serviceRefs, serviceRefName);
        }
        catch (VersionNotSupportedException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return match;
    }

    protected CommonDDBean findServiceRefByName(ServiceRef[] serviceRefs, String serviceRefName) {
        ServiceRef match = null;
        if (serviceRefs != null) {
            for (ServiceRef serviceRef : serviceRefs) {
                if (!serviceRefName.equals(serviceRef.getServiceRefName())) continue;
                match = serviceRef;
                break;
            }
        }
        return match;
    }

    @Override
    public Map<String, Object> genProperties(CommonDDBean[] beans) {
        HashMap<String, HashMap<String, Object>> result = null;
        if (beans instanceof PortComponentRef[]) {
            PortComponentRef[] portComponentRefs;
            for (PortComponentRef portComponentRef : portComponentRefs = (PortComponentRef[])beans) {
                String sei = portComponentRef.getServiceEndpointInterface();
                if (!Utils.notEmpty(sei)) continue;
                if (result == null) {
                    result = new HashMap<String, HashMap<String, Object>>();
                }
                HashMap<String, Object> portComponentRefMap = new HashMap<String, Object>();
                result.put(sei, portComponentRefMap);
                portComponentRefMap.put("EndpointInterface", sei);
                portComponentRefMap.put("Name", sei);
                this.addMapString(portComponentRefMap, "PortComponentLink", portComponentRef.getPortComponentLink());
            }
        }
        return result;
    }
}

