/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.spi.SaasViewProvider;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SaasExplorerPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private DialogDescriptor descriptor;
    private final ExplorerManager manager = new ExplorerManager();
    private BeanTreeView treeView;
    private Node selectedResourceNode = null;
    private JLabel jLblTreeView;

    public SaasExplorerPanel() {
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jLblTreeView = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLblTreeView, (String)NbBundle.getMessage(SaasExplorerPanel.class, (String)"LBL_SelectRESTResource"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLblTreeView, gridBagConstraints);
    }

    private void initUserComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setPopupAllowed(false);
        this.treeView.setBorder((Border)new EtchedBorder());
        this.treeView.setDefaultActionAllowed(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treeView, gridBagConstraints);
        this.jLblTreeView.setLabelFor(this.treeView.getViewport().getView());
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SaasExplorerPanel.class, (String)"ACSD_RESTResourcesTreeView"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SaasExplorerPanel.class, (String)"ACSD_RESTResourcesTreeView"));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        SaasViewProvider saasView = (SaasViewProvider)Lookup.getDefault().lookup(SaasViewProvider.class);
        if (saasView != null) {
            Node saasRootNode = saasView.getSaasView();
            this.manager.setRootContext(saasRootNode);
        }
        this.descriptor.setValid(false);
        this.treeView.requestFocusInWindow();
    }

    @Override
    public void removeNotify() {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public void setDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Node getSelectedService() {
        return this.selectedResourceNode;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Node[] nodes;
        if (evt.getSource() == this.manager && "selectedNodes".equals(evt.getPropertyName()) && (nodes = this.manager.getSelectedNodes()) != null && nodes.length > 0) {
            Node node = nodes[0];
            WadlSaasResource saasResource = (WadlSaasResource)node.getLookup().lookup(WadlSaasResource.class);
            if (saasResource != null) {
                if (saasResource.getMethods().size() > 0) {
                    this.selectedResourceNode = node;
                    this.descriptor.setValid(true);
                } else {
                    this.selectedResourceNode = null;
                    this.descriptor.setValid(false);
                }
            } else {
                this.selectedResourceNode = null;
                this.descriptor.setValid(false);
            }
        }
    }
}

