/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.debug.Context;
import org.netbeans.modules.web.debug.JspBreakpointAnnotationListener;
import org.netbeans.modules.web.debug.breakpoints.JspLineBreakpoint;
import org.netbeans.modules.web.debug.util.Utils;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JspToggleBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private JPDADebugger debugger;
    private JspBreakpointAnnotationListener jspBreakpointAnnotationListener;

    public JspToggleBreakpointActionProvider() {
        Context.addPropertyChangeListener(this);
    }

    public JspToggleBreakpointActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        Context.addPropertyChangeListener(this);
    }

    private void destroy() {
        if (this.debugger != null) {
            this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        }
        Context.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        FileObject fo = Context.getCurrentFile();
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, this.isJSP(fo));
        if (this.debugger != null) {
            if (this.debugger.getState() == 4) {
                this.destroy();
            }
        }
    }

    private boolean isJSP(FileObject fo) {
        WebModule owner = null;
        if (fo != null) {
            owner = WebModule.getWebModule((FileObject)fo);
        }
        boolean isJsp = Utils.isJsp(fo) || Utils.isTag(fo);
        String webRoot = null;
        if (owner != null && owner.getDocumentBase() != null) {
            webRoot = FileUtil.getRelativePath((FileObject)owner.getDocumentBase(), (FileObject)fo);
        }
        return owner != null && webRoot != null && isJsp;
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void doAction(Object action) {
        DebuggerManager d = DebuggerManager.getDebuggerManager();
        int ln = Context.getCurrentLineNumber();
        FileObject fo = Context.getCurrentFile();
        if (!this.isJSP(fo)) {
            return;
        }
        String url = fo.toURL().toString();
        JspLineBreakpoint lb = this.getJspBreakpointAnnotationListener().findBreakpoint(url, ln);
        if (lb != null) {
            d.removeBreakpoint((Breakpoint)lb);
            return;
        }
        lb = JspLineBreakpoint.create(url, ln);
        d.addBreakpoint((Breakpoint)lb);
    }

    private JspBreakpointAnnotationListener getJspBreakpointAnnotationListener() {
        if (this.jspBreakpointAnnotationListener == null) {
            this.jspBreakpointAnnotationListener = (JspBreakpointAnnotationListener)((Object)DebuggerManager.getDebuggerManager().lookupFirst(null, JspBreakpointAnnotationListener.class));
        }
        return this.jspBreakpointAnnotationListener;
    }
}

