/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards.targetpanel.providers;

import java.io.File;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.target.iterator.spi.TargetPanelProvider;
import org.netbeans.modules.target.iterator.spi.TargetPanelUIManager;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.targetpanel.providers.DefaultTargetPanelUIManager;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

abstract class WebTargetPanelProvider<T>
implements TargetPanelProvider<T> {
    private static final String NEW_FILE_PREFIX = NbBundle.getMessage(WebTargetPanelProvider.class, (String)"LBL_TargetChooserPanelGUI_NewFilePrefix");
    private DefaultTargetPanelUIManager<T> myUiManager;

    WebTargetPanelProvider() {
    }

    WebTargetPanelProvider(String titleA11Desc, String labelName) {
        this.myUiManager = new DefaultTargetPanelUIManager(titleA11Desc, labelName);
    }

    public String getRelativeSourcesFolder(TargetChooserPanel<T> panel, FileObject sourceBase) {
        String sourceDir = "";
        WebModule wm = this.getWebModule();
        if (wm != null) {
            FileObject docBase = wm.getDocumentBase();
            if (docBase != null) {
                sourceDir = FileUtil.getRelativePath((FileObject)docBase, (FileObject)sourceBase);
            }
            if (sourceDir == null) {
                sourceDir = "";
            }
        }
        return sourceDir;
    }

    public File getTargetFile(TargetChooserPanel<T> panel, FileObject locationRoot, String relativeTargetFolder) {
        WebModule wm = this.getWebModule();
        FileObject docBase = null;
        if (wm != null) {
            docBase = wm.getDocumentBase();
        }
        if (relativeTargetFolder.length() == 0) {
            if (wm == null || docBase == null) {
                return FileUtil.toFile((FileObject)locationRoot);
            }
            return FileUtil.toFile((FileObject)docBase);
        }
        if (wm == null || docBase == null) {
            return new File(FileUtil.toFile((FileObject)locationRoot), relativeTargetFolder);
        }
        return new File(FileUtil.toFile((FileObject)docBase), relativeTargetFolder);
    }

    public String getNewFileName() {
        return NEW_FILE_PREFIX;
    }

    public void storeSettings(TargetChooserPanel<T> panel) {
    }

    public void readSettings(TargetChooserPanel<T> panel) {
    }

    public boolean isValid(TargetChooserPanel<T> panel) {
        return panel.checkValid();
    }

    public String getExpectedExtension(TargetChooserPanel<T> panel) {
        return Templates.getTemplate((WizardDescriptor)panel.getTemplateWizard()).getExt();
    }

    public String getResultExtension(TargetChooserPanel<T> panel) {
        return Templates.getTemplate((WizardDescriptor)panel.getTemplateWizard()).getExt();
    }

    public void init(TargetChooserPanel<T> panel) {
    }

    public TargetPanelUIManager<T> getUIManager() {
        return this.myUiManager;
    }

    protected WebModule getWebModule() {
        return this.myUiManager.getWebModule();
    }
}

