/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.netbeans.modules.web.wizards.FilterMappingData;
import org.netbeans.modules.web.wizards.TableRowDialog;
import org.netbeans.modules.web.wizards.ToolTipCombo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MappingEditor
extends JPanel
implements ActionListener {
    private JRadioButton urlRadio;
    private JRadioButton servletRadio;
    private JTextField mappingField;
    private ToolTipCombo<String> servletCombo;
    private JCheckBox[] cb;
    private Dialog dialog;
    private DialogDescriptor editDialog;
    private static final String URL = "URL";
    private static final String SERVLET = "SERVLET";
    private static final String SELECT_SERVLET = "SELECT";
    private FilterMappingData fmd;
    private boolean haveNames = true;
    private boolean OK = false;
    private static final long serialVersionUID = 4947167720581796971L;

    public MappingEditor(FilterMappingData fmd, String[] servletNames) {
        this.fmd = fmd;
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_filter_mappings_edit"));
        this.initComponents(servletNames);
    }

    boolean isOK() {
        return this.OK;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.web.wizards.MappingEditor");
    }

    private void initComponents(String[] names) {
        Insets insets = new Insets(4, 20, 4, 0);
        Insets endInsets = new Insets(4, 20, 4, 60);
        GridBagConstraints fullRowC = new GridBagConstraints();
        fullRowC.gridx = 0;
        fullRowC.gridy = -1;
        fullRowC.gridwidth = 0;
        fullRowC.anchor = 17;
        fullRowC.fill = 2;
        fullRowC.insets = endInsets;
        GridBagConstraints firstC = new GridBagConstraints();
        firstC.gridx = 0;
        firstC.gridy = -1;
        firstC.anchor = 17;
        firstC.insets = insets;
        GridBagConstraints tflC = new GridBagConstraints();
        tflC.gridx = -1;
        tflC.weightx = 0.8;
        tflC.gridwidth = 0;
        tflC.fill = 2;
        tflC.insets = endInsets;
        this.setLayout(new GridBagLayout());
        JLabel jLname = new JLabel();
        jLname.setText(NbBundle.getMessage(MappingEditor.class, (String)"LBL_name_filter"));
        JTextField jTFname = new JTextField(25);
        jTFname.setText(this.fmd.getName());
        jTFname.setEnabled(false);
        jTFname.setBackground(this.getBackground());
        jTFname.setDisabledTextColor(Color.black);
        jLname.setLabelFor(jTFname);
        jLname.setDisplayedMnemonic(NbBundle.getMessage(MappingEditor.class, (String)"LBL_name_filter_mnem").charAt(0));
        jTFname.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_name_filter"));
        this.add((Component)jLname, firstC);
        this.add((Component)jTFname, tflC);
        this.urlRadio = new JRadioButton(NbBundle.getMessage(MappingEditor.class, (String)"LBL_url"));
        this.urlRadio.setMnemonic(NbBundle.getMessage(MappingEditor.class, (String)"LBL_url_mnemonic").charAt(0));
        this.urlRadio.addActionListener(this);
        this.urlRadio.setActionCommand(URL);
        this.urlRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_pattern_mapping"));
        this.servletRadio = new JRadioButton(NbBundle.getMessage(MappingEditor.class, (String)"LBL_servlet"));
        this.servletRadio.setMnemonic(NbBundle.getMessage(MappingEditor.class, (String)"LBL_servlet_mnemonic").charAt(0));
        this.servletRadio.addActionListener(this);
        this.servletRadio.setActionCommand(SERVLET);
        this.servletRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_servlet_mapping"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.urlRadio);
        group.add(this.servletRadio);
        this.add((Component)this.urlRadio, firstC);
        this.mappingField = new JTextField();
        this.mappingField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MappingEditor.class, (String)"LBL_url"));
        this.mappingField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_pattern_mapping_desc"));
        this.add((Component)this.mappingField, tflC);
        this.add((Component)this.servletRadio, firstC);
        if (names == null || names.length == 0) {
            names = new String[]{NbBundle.getMessage(MappingEditor.class, (String)"LBL_no_servlets")};
            this.haveNames = false;
        }
        this.servletCombo = new ToolTipCombo<String>((T[])names);
        this.servletCombo.setBackground(this.getBackground());
        this.servletCombo.setActionCommand(SELECT_SERVLET);
        this.servletCombo.addActionListener(this);
        this.servletCombo.setEnabled(this.haveNames);
        this.servletCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_select_servlet"));
        this.servletCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingEditor.class, (String)"ACSD_select_servlet_desc"));
        this.servletRadio.setEnabled(this.haveNames);
        this.add(this.servletCombo, tflC);
        if (this.fmd.getType() == FilterMappingData.Type.URL) {
            this.urlRadio.setSelected(true);
            this.mappingField.setText(this.fmd.getPattern());
        } else {
            this.servletRadio.setSelected(true);
            int size = this.servletCombo.getModel().getSize();
            for (int i = 0; i < size; ++i) {
                if (!((String)this.servletCombo.getModel().getElementAt(i)).toString().equals(this.fmd.getPattern())) continue;
                this.servletCombo.setSelectedIndex(i);
                break;
            }
        }
        JLabel conditions = new JLabel();
        conditions.setText(NbBundle.getMessage(MappingEditor.class, (String)"LBL_conditions"));
        conditions.setDisplayedMnemonic(NbBundle.getMessage(MappingEditor.class, (String)"LBL_conditions_mnemonic").charAt(0));
        this.add((Component)conditions, fullRowC);
        JPanel p0 = new JPanel();
        p0.setLayout(new FlowLayout(0));
        this.cb = new JCheckBox[4];
        for (int i = 0; i < FilterMappingData.Dispatcher.getAll().length; ++i) {
            String dispatcher = FilterMappingData.Dispatcher.getAll()[i].toString();
            this.cb[i] = new JCheckBox(dispatcher);
            this.cb[i].setMnemonic(dispatcher.charAt(0));
            this.cb[i].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MappingEditor.class, (String)("ACSD_dispatcher_" + dispatcher)));
            p0.add(this.cb[i]);
        }
        FilterMappingData.Dispatcher[] config = this.fmd.getDispatcher();
        for (int i = 0; i < config.length; ++i) {
            if (config[i] == FilterMappingData.Dispatcher.REQUEST) {
                this.cb[0].setSelected(true);
                continue;
            }
            if (config[i] == FilterMappingData.Dispatcher.FORWARD) {
                this.cb[1].setSelected(true);
                continue;
            }
            if (config[i] == FilterMappingData.Dispatcher.INCLUDE) {
                this.cb[2].setSelected(true);
                continue;
            }
            if (config[i] != FilterMappingData.Dispatcher.ERROR) continue;
            this.cb[3].setSelected(true);
        }
        this.add((Component)p0, fullRowC);
        JPanel p1 = new JPanel();
        GridBagConstraints filler = new GridBagConstraints();
        filler.gridx = 0;
        filler.gridy = -1;
        filler.fill = 2;
        filler.weighty = 1.0;
        this.add((Component)p1, filler);
    }

    public void showEditor() {
        String title = NbBundle.getMessage(MappingEditor.class, (String)"TITLE_filter_mapping");
        this.editDialog = new DialogDescriptor((Object)this, title, true, 2, DialogDescriptor.CANCEL_OPTION, 0, null, (ActionListener)this);
        this.dialog = DialogDisplayer.getDefault().createDialog(this.editDialog);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand() == URL) {
            this.fmd.setType(FilterMappingData.Type.URL);
            this.fmd.setPattern(this.mappingField.getText().trim());
            this.mappingField.requestFocus();
            return;
        }
        if (evt.getActionCommand() == SERVLET) {
            if (!this.haveNames) {
                return;
            }
            this.fmd.setType(FilterMappingData.Type.SERVLET);
            this.fmd.setPattern(this.servletCombo.getSelectedItem().toString());
            this.servletCombo.requestFocus();
            return;
        }
        if (evt.getActionCommand() == SELECT_SERVLET) {
            if (!this.haveNames) {
                return;
            }
            this.fmd.setType(FilterMappingData.Type.SERVLET);
            this.servletRadio.setSelected(true);
            this.fmd.setPattern(this.servletCombo.getSelectedItem().toString());
            return;
        }
        Object retValue = this.editDialog.getValue();
        if (DialogDescriptor.CANCEL_OPTION.equals(retValue) || DialogDescriptor.CLOSED_OPTION.equals(retValue)) {
            this.OK = false;
            this.dialog.dispose();
            return;
        }
        if (this.fmd.getType() == FilterMappingData.Type.URL) {
            this.fmd.setPattern(this.mappingField.getText().trim());
            if (this.fmd.getPattern().length() == 0) {
                this.notifyBadInput(NbBundle.getMessage(TableRowDialog.class, (String)"MSG_no_pattern"));
                return;
            }
        }
        int num = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.cb[i].isSelected()) continue;
            ++num;
        }
        FilterMappingData.Dispatcher[] d = new FilterMappingData.Dispatcher[num];
        num = 0;
        if (this.cb[0].isSelected()) {
            d[num] = FilterMappingData.Dispatcher.REQUEST;
            ++num;
        }
        if (this.cb[1].isSelected()) {
            d[num] = FilterMappingData.Dispatcher.FORWARD;
            ++num;
        }
        if (this.cb[2].isSelected()) {
            d[num] = FilterMappingData.Dispatcher.INCLUDE;
            ++num;
        }
        if (this.cb[3].isSelected()) {
            d[num] = FilterMappingData.Dispatcher.ERROR;
        }
        this.fmd.setDispatcher(d);
        this.OK = true;
        this.dialog.dispose();
    }

    private void notifyBadInput(String msg) {
        Object[] options = new Object[]{NotifyDescriptor.OK_OPTION};
        NotifyDescriptor badInputDialog = new NotifyDescriptor((Object)msg, NbBundle.getMessage(TableRowDialog.class, (String)"MSG_invalid_input"), -1, 0, options, options[0]);
        DialogDisplayer.getDefault().notify(badInputDialog);
    }
}

