/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class KubernetesVersionsFilters
extends ExplicitlySetBmcModel {
    @JsonProperty(value="minimalVersion")
    private final String minimalVersion;
    @JsonProperty(value="maximumVersion")
    private final String maximumVersion;
    @JsonProperty(value="exactKubernetesVersions")
    private final List<String> exactKubernetesVersions;

    @Deprecated
    @ConstructorProperties(value={"minimalVersion", "maximumVersion", "exactKubernetesVersions"})
    public KubernetesVersionsFilters(String minimalVersion, String maximumVersion, List<String> exactKubernetesVersions) {
        this.minimalVersion = minimalVersion;
        this.maximumVersion = maximumVersion;
        this.exactKubernetesVersions = exactKubernetesVersions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getMinimalVersion() {
        return this.minimalVersion;
    }

    public String getMaximumVersion() {
        return this.maximumVersion;
    }

    public List<String> getExactKubernetesVersions() {
        return this.exactKubernetesVersions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("KubernetesVersionsFilters(");
        sb.append("super=").append(super.toString());
        sb.append("minimalVersion=").append(String.valueOf(this.minimalVersion));
        sb.append(", maximumVersion=").append(String.valueOf(this.maximumVersion));
        sb.append(", exactKubernetesVersions=").append(String.valueOf(this.exactKubernetesVersions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KubernetesVersionsFilters)) {
            return false;
        }
        KubernetesVersionsFilters other = (KubernetesVersionsFilters)((Object)o);
        return Objects.equals(this.minimalVersion, other.minimalVersion) && Objects.equals(this.maximumVersion, other.maximumVersion) && Objects.equals(this.exactKubernetesVersions, other.exactKubernetesVersions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.minimalVersion == null ? 43 : this.minimalVersion.hashCode());
        result = result * 59 + (this.maximumVersion == null ? 43 : this.maximumVersion.hashCode());
        result = result * 59 + (this.exactKubernetesVersions == null ? 43 : this.exactKubernetesVersions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="minimalVersion")
        private String minimalVersion;
        @JsonProperty(value="maximumVersion")
        private String maximumVersion;
        @JsonProperty(value="exactKubernetesVersions")
        private List<String> exactKubernetesVersions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder minimalVersion(String minimalVersion) {
            this.minimalVersion = minimalVersion;
            this.__explicitlySet__.add("minimalVersion");
            return this;
        }

        public Builder maximumVersion(String maximumVersion) {
            this.maximumVersion = maximumVersion;
            this.__explicitlySet__.add("maximumVersion");
            return this;
        }

        public Builder exactKubernetesVersions(List<String> exactKubernetesVersions) {
            this.exactKubernetesVersions = exactKubernetesVersions;
            this.__explicitlySet__.add("exactKubernetesVersions");
            return this;
        }

        public KubernetesVersionsFilters build() {
            KubernetesVersionsFilters model = new KubernetesVersionsFilters(this.minimalVersion, this.maximumVersion, this.exactKubernetesVersions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(KubernetesVersionsFilters model) {
            if (model.wasPropertyExplicitlySet("minimalVersion")) {
                this.minimalVersion(model.getMinimalVersion());
            }
            if (model.wasPropertyExplicitlySet("maximumVersion")) {
                this.maximumVersion(model.getMaximumVersion());
            }
            if (model.wasPropertyExplicitlySet("exactKubernetesVersions")) {
                this.exactKubernetesVersions(model.getExactKubernetesVersions());
            }
            return this;
        }
    }
}

