/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.List;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HCLTemplate
extends HCLExpression {
    public List<? extends Part> parts();

    public record StringTemplate(List<Part> parts) implements HCLTemplate
    {
        public StringTemplate {
            parts = List.copyOf(parts);
        }

        @Override
        public String asString() {
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            for (Part part : this.parts) {
                sb.append(part);
            }
            sb.append('\"');
            return sb.toString();
        }
    }

    public record HereDoc(String marker, int indent, List<Part> parts) implements HCLTemplate
    {
        public HereDoc {
            parts = List.copyOf(parts);
        }

        public boolean isIndented() {
            return this.indent != -1;
        }

        @Override
        public String asString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.indent > -1 ? "<<-" : "<<").append(this.marker).append('\n');
            for (Part part : this.parts) {
                sb.append(part);
            }
            sb.append(this.marker);
            return sb.toString();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Part {
        public static final StringPart NL = new StringPart("\n");

        public String value();

        default public String asString() {
            if (this instanceof StringPart) {
                return this.value();
            }
            if (this instanceof InterpolationPart) {
                return "${" + this.value() + "}";
            }
            if (this instanceof TemplatePart) {
                return "%{" + this.value() + "}";
            }
            return null;
        }

        public record StringPart(String value) implements Part
        {
        }

        public record InterpolationPart(String value) implements Part
        {
        }

        public record TemplatePart(String value) implements Part
        {
        }
    }
}

