/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public final class IndexingBridge {
    private static final Logger LOG = Logger.getLogger(IndexingBridge.class.getName());
    private static IndexingBridge instance = null;
    private int delayBeforeRefresh = -1;
    private static final int DEFAULT_DELAY = 100;

    public static synchronized IndexingBridge getInstance() {
        if (instance == null) {
            instance = new IndexingBridge();
        }
        return instance;
    }

    public <T> T runWithoutIndexing(Callable<T> operation, File ... files) throws Exception {
        return this.runWithoutIndexing(operation, true, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWithoutIndexing(Callable<T> operation, boolean refreshFS, File ... files) throws Exception {
        HashSet<File> parents;
        T t;
        IndexingBridgeProvider ibp = (IndexingBridgeProvider)Lookup.getDefault().lookup(IndexingBridgeProvider.class);
        if (ibp != null) {
            if (LOG.isLoggable(Level.FINE)) {
                StringBuffer sb = new StringBuffer();
                if (files != null) {
                    for (File file : files) {
                        sb.append("\n");
                        sb.append(file.getAbsolutePath());
                    }
                }
                LOG.fine("running vcs operaton without scheduling for files:" + sb.toString());
            }
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    files[i] = FileUtil.normalizeFile((File)files[i]);
                }
            }
            return ibp.runWithoutIndexing(operation, files);
        }
        try {
            t = operation.call();
            parents = new HashSet<File>();
        }
        catch (Throwable throwable) {
            HashSet<File> parents2 = new HashSet<File>();
            for (File f : files) {
                File parent = f.getParentFile();
                if (parent == null) continue;
                parents2.add(parent);
                LOG.fine("scheduling for fs refresh: [" + parent + "]");
            }
            if (refreshFS && parents2.size() > 0) {
                Utils.postParallel(new Runnable(){
                    final /* synthetic */ Set val$parents;
                    {
                        this.val$parents = set;
                    }

                    @Override
                    public void run() {
                        long t = System.currentTimeMillis();
                        try {
                            FileUtil.refreshFor((File[])this.val$parents.toArray(new File[0]));
                        }
                        finally {
                            LOG.fine(" refreshing " + this.val$parents.size() + " parents took " + (System.currentTimeMillis() - t) + " millis.");
                        }
                    }
                }, this.getDelay());
            }
            throw throwable;
        }
        for (File f : files) {
            File parent = f.getParentFile();
            if (parent == null) continue;
            parents.add(parent);
            LOG.fine("scheduling for fs refresh: [" + parent + "]");
        }
        if (refreshFS && parents.size() > 0) {
            Utils.postParallel(new /* invalid duplicate definition of identical inner class */, this.getDelay());
        }
        return t;
    }

    public boolean isIndexingInProgress() {
        IndexingBridgeProvider ibp = (IndexingBridgeProvider)Lookup.getDefault().lookup(IndexingBridgeProvider.class);
        if (ibp != null) {
            return ibp.isIndexingInProgress();
        }
        return false;
    }

    private IndexingBridge() {
    }

    private int getDelay() {
        if (this.delayBeforeRefresh == -1) {
            String delayProp = System.getProperty("vcs.fsrefresh.delay", Integer.toString(100));
            int delay = 100;
            try {
                delay = Integer.parseInt(delayProp);
            }
            catch (NumberFormatException e) {
                LOG.log(Level.FINE, null, e);
            }
            this.delayBeforeRefresh = delay;
        }
        return this.delayBeforeRefresh;
    }

    public static interface IndexingBridgeProvider {
        public <T> T runWithoutIndexing(Callable<T> var1, File ... var2) throws Exception;

        public boolean isIndexingInProgress();
    }
}

