/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class UsageLogger {
    private final Logger logger;
    private final Class<?> srcClass;
    private final String message;
    @NullAllowed
    private final AtomicBoolean firstMessageOnly;

    private UsageLogger(Builder builder) {
        assert (builder != null);
        assert (builder.loggerName != null);
        this.logger = Logger.getLogger(builder.loggerName);
        this.srcClass = builder.srcClass;
        this.message = builder.message;
        this.firstMessageOnly = builder.firstMessageOnly ? new AtomicBoolean(false) : null;
    }

    public boolean isLoggingEnabled() {
        if (this.firstMessageOnly == null) {
            return true;
        }
        return !this.firstMessageOnly.get();
    }

    public void reset() {
        if (this.firstMessageOnly != null) {
            this.firstMessageOnly.set(false);
        }
    }

    public void log(Class<?> srcClass, String message, Object ... params) {
        Parameters.notNull((CharSequence)"srcClass", srcClass);
        Parameters.notNull((CharSequence)"message", (Object)message);
        this.logInternal(srcClass, message, params);
    }

    public void log(Object ... params) {
        if (this.srcClass == null) {
            throw new IllegalStateException("No srcClass set");
        }
        if (this.message == null) {
            throw new IllegalStateException("No message set");
        }
        this.logInternal(this.srcClass, this.message, params);
    }

    private void logInternal(Class<?> srcClass, String message, Object ... params) {
        assert (srcClass != null);
        assert (message != null);
        if (!this.isLoggingEnabled()) {
            return;
        }
        if (this.firstMessageOnly != null && !this.firstMessageOnly.compareAndSet(false, true)) {
            return;
        }
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(this.logger.getName());
        logRecord.setResourceBundle(NbBundle.getBundle(srcClass));
        logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        logRecord.setParameters(params);
        this.logger.log(logRecord);
    }

    public static UsageLogger projectBrowserUsageLogger(String loggerName) {
        return new Builder(loggerName).message(UsageLogger.class, "USG_PROJECT_BROWSER").create();
    }

    public static UsageLogger jsTestRunUsageLogger(String loggerName) {
        return new Builder(loggerName).message(UsageLogger.class, "USG_TEST_RUN_JS").create();
    }

    public static final class Builder {
        final String loggerName;
        Class<?> srcClass;
        String message;
        boolean firstMessageOnly = true;

        public Builder(String loggerName) {
            Parameters.notNull((CharSequence)"loggerName", (Object)loggerName);
            this.loggerName = loggerName;
        }

        public Builder firstMessageOnly(boolean firstMessageOnly) {
            this.firstMessageOnly = firstMessageOnly;
            return this;
        }

        public Builder message(Class<?> srcClass, String message) {
            Parameters.notNull((CharSequence)"srcClass", srcClass);
            Parameters.notNull((CharSequence)"message", (Object)message);
            this.srcClass = srcClass;
            this.message = message;
            return this;
        }

        public UsageLogger create() {
            return new UsageLogger(this);
        }
    }
}

