/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.bridge.exportdiff;

import java.io.File;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.bridge.exportdiff.AttachPanel;
import org.netbeans.modules.versioning.util.ExportDiffSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ExportDiffProviderImpl
extends ExportDiffSupport.ExportDiffProvider
implements DocumentListener,
ChangeListener {
    private AttachPanel panel;
    private FileObject[] files;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.exportdiff.AttachIssue");

    protected void setContext(File[] files) {
        LinkedList<FileObject> fs = new LinkedList<FileObject>();
        for (File file : files) {
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null) continue;
            fs.add(fo);
        }
        this.files = fs.toArray(new FileObject[0]);
    }

    public void handleDiffFile(File file) {
        LOG.log(Level.FINE, "handeDiff start for {0}", file);
        Issue issue = this.panel.getIssue();
        if (issue == null) {
            LOG.log(Level.FINE, " no issue set");
            return;
        }
        issue.attachFile(file, this.panel.descriptionTextField.getText(), true);
        issue.open();
        LOG.log(Level.FINE, "handeDiff end for {0}", file);
    }

    public JComponent createComponent() {
        assert (this.files != null);
        this.panel = new AttachPanel(this, this.files.length > 0 ? this.files[0] : null);
        this.panel.descriptionTextField.getDocument().addDocumentListener(this);
        return this.panel;
    }

    public boolean isValid() {
        return !this.panel.descriptionTextField.getText().trim().equals("") && this.panel.getIssue() != null;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireDataChanged();
    }
}

