/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.client;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitBlameResult;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitCherryPickResult;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitClientCallback;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitMergeResult;
import org.netbeans.libs.git.GitPullResult;
import org.netbeans.libs.git.GitPushResult;
import org.netbeans.libs.git.GitRebaseResult;
import org.netbeans.libs.git.GitRefUpdateResult;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRepository;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitRevertResult;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.GitSubmoduleStatus;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.GitUser;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitCanceledException;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NetworkSettings;
import org.openide.util.RequestProcessor;

public final class GitClient {
    private final org.netbeans.libs.git.GitClient delegate;
    private final GitProgressSupport progressSupport;
    private final boolean handleAuthenticationIssues;
    private static final int CLEANUP_TIME = 15000;
    private static final List<org.netbeans.libs.git.GitClient> unusedClients = new LinkedList<org.netbeans.libs.git.GitClient>();
    private static final RequestProcessor.Task cleanTask = Git.getInstance().getRequestProcessor().create((Runnable)new CleanTask());
    private static final HashSet<String> PARALLELIZABLE_COMMANDS = new HashSet<String>(Arrays.asList("addNotificationListener", "blame", "catFile", "catIndexEntry", "exportCommit", "exportDiff", "getBranches", "getCommonAncestor", "getConflicts", "getPreviousRevision", "getStatus", "getTags", "getRemote", "getRemotes", "getRepositoryState", "getSubmoduleStatus", "getUser", "listModifiedIndexEntries", "listRemoteBranches", "listRemoteTags", "log", "removeNotificationListener", "removeRemote", "setCallback", "setRemote", "stashList"));
    private static final HashSet<String> WORKING_TREE_READ_ONLY_COMMANDS = new HashSet<String>(Arrays.asList("addNotificationListener", "blame", "catFile", "catIndexEntry", "createBranch", "createTag", "deleteBranch", "deleteTag", "fetch", "exportCommit", "exportDiff", "getBranches", "getCommonAncestor", "getConflicts", "getPreviousRevision", "getStatus", "getRemote", "getRemotes", "getRepositoryState", "getSubmoduleStatus", "getTags", "getUser", "ignore", "listModifiedIndexEntries", "listRemoteBranches", "listRemoteTags", "log", "unignore", "updateReference", "push", "removeNotificationListener", "removeRemote", "setCallback", "setRemote", "stashDrop", "stashDropAll", "stashList"));
    private static final HashSet<String> NEED_REPOSITORY_REFRESH_COMMANDS = new HashSet<String>(Arrays.asList("add", "checkout", "checkoutRevision", "cherryPick", "commit", "createBranch", "createTag", "deleteBranch", "deleteTag", "fetch", "merge", "pull", "push", "rebase", "remove", "renameBranch", "reset", "removeRemote", "revert", "setRemote", "setUpstreamBranch", "updateReference", "updateSubmodules"));
    private static final HashSet<String> NETWORK_COMMANDS = new HashSet<String>(Arrays.asList("fetch", "listRemoteBranches", "listRemoteTags", "pull", "push", "updateSubmodules"));
    private static final Logger LOG = Logger.getLogger(GitClient.class.getName());
    private final File repositoryRoot;
    private boolean released;

    public GitClient(File repository, GitProgressSupport progressSupport, boolean handleAuthenticationIssues) throws GitException {
        this.repositoryRoot = repository;
        this.delegate = GitRepository.getInstance((File)repository).createClient();
        this.progressSupport = progressSupport;
        this.handleAuthenticationIssues = handleAuthenticationIssues;
    }

    public void add(final File[] roots, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.add(roots, monitor);
                return null;
            }
        }, "add", roots);
    }

    public void addNotificationListener(NotificationListener listener) {
        this.delegate.addNotificationListener(listener);
    }

    public GitBlameResult blame(final File file, final String revision, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        return new CommandInvoker().runMethod(new Callable<GitBlameResult>(){

            @Override
            public GitBlameResult call() throws Exception {
                return GitClient.this.delegate.blame(file, revision, monitor);
            }
        }, "blame");
    }

    public boolean catFile(final File file, final String revision, final OutputStream out, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        return new CommandInvoker().runMethod(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return GitClient.this.delegate.catFile(file, revision, out, monitor);
            }
        }, "catFile");
    }

    public boolean catIndexEntry(final File file, final int stage, final OutputStream out, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return GitClient.this.delegate.catIndexEntry(file, stage, out, monitor);
            }
        }, "catIndexEntry");
    }

    public void checkout(final File[] roots, final String revision, final boolean recursively, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.checkout(roots, revision, recursively, monitor);
                return null;
            }
        }, "checkout", roots);
    }

    public void checkoutRevision(final String revision, final boolean failOnConflict, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.checkoutRevision(revision, failOnConflict, monitor);
                return null;
            }
        }, "checkoutRevision", new File[]{this.repositoryRoot});
    }

    public GitCherryPickResult cherryPick(final GitClient.CherryPickOperation op, final String[] revisions, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        return new CommandInvoker().runMethod(new Callable<GitCherryPickResult>(){

            @Override
            public GitCherryPickResult call() throws Exception {
                return GitClient.this.delegate.cherryPick(op, revisions, monitor);
            }
        }, "cherryPick", new File[]{this.repositoryRoot});
    }

    public void clean(final File[] roots, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.clean(roots, monitor);
                return null;
            }
        }, "clean", roots);
    }

    public GitRevisionInfo commit(File[] roots, String commitMessage, GitUser author, GitUser commiter, ProgressMonitor monitor) throws GitException {
        return this.commit(roots, commitMessage, author, commiter, false, monitor);
    }

    public GitRevisionInfo commit(final File[] roots, final String commitMessage, final GitUser author, final GitUser commiter, final boolean amend, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<GitRevisionInfo>(){

            @Override
            public GitRevisionInfo call() throws Exception {
                return GitClient.this.delegate.commit(roots, commitMessage, author, commiter, amend, monitor);
            }
        }, "commit", roots);
    }

    public void copyAfter(final File source, final File target, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.copyAfter(source, target, monitor);
                return null;
            }
        }, "copyAfter", new File[]{target});
    }

    public GitBranch createBranch(final String branchName, final String revision, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<GitBranch>(){

            @Override
            public GitBranch call() throws Exception {
                return GitClient.this.delegate.createBranch(branchName, revision, monitor);
            }
        }, "createBranch");
    }

    public GitTag createTag(final String tagName, final String taggedObject, final String message, final boolean signed, final boolean forceUpdate, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<GitTag>(){

            @Override
            public GitTag call() throws Exception {
                return GitClient.this.delegate.createTag(tagName, taggedObject, message, signed, forceUpdate, monitor);
            }
        }, "createTag");
    }

    public void deleteBranch(final String branchName, final boolean forceDeleteUnmerged, final ProgressMonitor monitor) throws GitException.NotMergedException, GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.deleteBranch(branchName, forceDeleteUnmerged, monitor);
                return null;
            }
        }, "deleteBranch");
    }

    public void deleteTag(final String tagName, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.deleteTag(tagName, monitor);
                return null;
            }
        }, "deleteTag");
    }

    public void exportCommit(final String commit, final OutputStream out, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.exportCommit(commit, out, monitor);
                return null;
            }
        }, "exportCommit");
    }

    public void exportDiff(final File[] roots, final GitClient.DiffMode mode, final OutputStream out, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.exportDiff(roots, mode, out, monitor);
                return null;
            }
        }, "exportDiff", roots);
    }

    public void exportDiff(final File[] roots, final String base, final String other, final OutputStream out, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.exportDiff(roots, base, other, out, monitor);
                return null;
            }
        }, "exportDiff", roots);
    }

    public Map<String, GitTransportUpdate> fetch(final String remote, final ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        return new CommandInvoker().runMethod(new Callable<Map<String, GitTransportUpdate>>(){

            @Override
            public Map<String, GitTransportUpdate> call() throws Exception {
                return GitClient.this.delegate.fetch(remote, monitor);
            }
        }, "fetch");
    }

    public Map<String, GitTransportUpdate> fetch(final String remote, final List<String> fetchRefSpecifications, final ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        return new CommandInvoker().runMethod(new Callable<Map<String, GitTransportUpdate>>(){

            @Override
            public Map<String, GitTransportUpdate> call() throws Exception {
                return GitClient.this.delegate.fetch(remote, fetchRefSpecifications, monitor);
            }
        }, "fetch");
    }

    public Map<String, GitBranch> getBranches(final boolean all, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<Map<String, GitBranch>>(){

            @Override
            public Map<String, GitBranch> call() throws Exception {
                return GitClient.this.delegate.getBranches(all, monitor);
            }
        }, "getBranches");
    }

    public Map<File, GitSubmoduleStatus> getSubmoduleStatus(final File[] roots, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<Map<File, GitSubmoduleStatus>>(){

            @Override
            public Map<File, GitSubmoduleStatus> call() throws Exception {
                return GitClient.this.delegate.getSubmoduleStatus(roots, monitor);
            }
        }, "getSubmoduleStatus");
    }

    public Map<String, GitTag> getTags(final ProgressMonitor monitor, final boolean allTags) throws GitException {
        return new CommandInvoker().runMethod(new Callable<Map<String, GitTag>>(){

            @Override
            public Map<String, GitTag> call() throws Exception {
                return GitClient.this.delegate.getTags(monitor, allTags);
            }
        }, "getTags");
    }

    public GitRevisionInfo getCommonAncestor(final String[] revisions, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<GitRevisionInfo>(){

            @Override
            public GitRevisionInfo call() throws Exception {
                return GitClient.this.delegate.getCommonAncestor(revisions, monitor);
            }
        }, "getCommonAncestor");
    }

    public GitRevisionInfo getPreviousRevision(final File file, final String revision, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<GitRevisionInfo>(){

            @Override
            public GitRevisionInfo call() throws Exception {
                return GitClient.this.delegate.getPreviousRevision(file, revision, monitor);
            }
        }, "getPreviousRevision");
    }

    public Map<File, GitStatus> getConflicts(final File[] roots, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<Map<File, GitStatus>>(){

            @Override
            public Map<File, GitStatus> call() throws Exception {
                return GitClient.this.delegate.getConflicts(roots, monitor);
            }
        }, "getConflicts", roots);
    }

    public Map<File, GitStatus> getStatus(File[] roots, ProgressMonitor monitor) throws GitException {
        return this.getStatus(roots, "HEAD", monitor);
    }

    public Map<File, GitStatus> getStatus(final File[] roots, final String revision, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<Map<File, GitStatus>>(){

            @Override
            public Map<File, GitStatus> call() throws Exception {
                return GitClient.this.delegate.getStatus(roots, revision, monitor);
            }
        }, "getStatus", roots);
    }

    public Map<File, GitRevisionInfo.GitFileInfo> getStatus(final File[] roots, final String revisionLeft, final String revisionRight, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<Map<File, GitRevisionInfo.GitFileInfo>>(){

            @Override
            public Map<File, GitRevisionInfo.GitFileInfo> call() throws Exception {
                return GitClient.this.delegate.getStatus(roots, revisionLeft, revisionRight, monitor);
            }
        }, "getStatus", roots);
    }

    public GitRemoteConfig getRemote(final String remoteName, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<GitRemoteConfig>(){

            @Override
            public GitRemoteConfig call() throws Exception {
                return GitClient.this.delegate.getRemote(remoteName, monitor);
            }
        }, "getRemote");
    }

    public Map<String, GitRemoteConfig> getRemotes(final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<Map<String, GitRemoteConfig>>(){

            @Override
            public Map<String, GitRemoteConfig> call() throws Exception {
                return GitClient.this.delegate.getRemotes(monitor);
            }
        }, "getRemotes");
    }

    public File getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public GitRepositoryState getRepositoryState(final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<GitRepositoryState>(){

            @Override
            public GitRepositoryState call() throws Exception {
                return GitClient.this.delegate.getRepositoryState(monitor);
            }
        }, "getRepositoryState");
    }

    public GitUser getUser() throws GitException {
        return new CommandInvoker().runMethod(new Callable<GitUser>(){

            @Override
            public GitUser call() throws Exception {
                return GitClient.this.delegate.getUser();
            }
        }, "getUser");
    }

    public File[] ignore(final File[] files, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<File[]>(){

            @Override
            public File[] call() throws Exception {
                return GitClient.this.delegate.ignore(files, monitor);
            }
        }, "ignore", files);
    }

    public void init(final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.init(monitor);
                return null;
            }
        }, "init");
    }

    public Map<File, GitSubmoduleStatus> initializeSubmodules(final File[] roots, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<Map<File, GitSubmoduleStatus>>(){

            @Override
            public Map<File, GitSubmoduleStatus> call() throws Exception {
                return GitClient.this.delegate.initializeSubmodules(roots, monitor);
            }
        }, "initializeSubmodules");
    }

    public File[] listModifiedIndexEntries(final File[] roots, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<File[]>(){

            @Override
            public File[] call() throws Exception {
                return GitClient.this.delegate.listModifiedIndexEntries(roots, monitor);
            }
        }, "listModifiedIndexEntries", roots);
    }

    public Map<String, GitBranch> listRemoteBranches(final String remoteRepositoryUrl, final ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        return new CommandInvoker().runMethod(new Callable<Map<String, GitBranch>>(){

            @Override
            public Map<String, GitBranch> call() throws Exception {
                return GitClient.this.delegate.listRemoteBranches(remoteRepositoryUrl, monitor);
            }
        }, "listRemoteBranches");
    }

    public Map<String, String> listRemoteTags(final String remoteRepositoryUrl, final ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        return new CommandInvoker().runMethod(new Callable<Map<String, String>>(){

            @Override
            public Map<String, String> call() throws Exception {
                return GitClient.this.delegate.listRemoteTags(remoteRepositoryUrl, monitor);
            }
        }, "listRemoteTags");
    }

    public GitRevisionInfo log(final String revision, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        return new CommandInvoker().runMethod(new Callable<GitRevisionInfo>(){

            @Override
            public GitRevisionInfo call() throws Exception {
                return GitClient.this.delegate.log(revision, monitor);
            }
        }, "log");
    }

    public GitRevisionInfo[] log(final SearchCriteria searchCriteria, final boolean fetchAffectedBranches, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        return new CommandInvoker().runMethod(new Callable<GitRevisionInfo[]>(){

            @Override
            public GitRevisionInfo[] call() throws Exception {
                return GitClient.this.delegate.log(searchCriteria, fetchAffectedBranches, monitor);
            }
        }, "log");
    }

    public GitMergeResult merge(final String revision, final GitRepository.FastForwardOption ffOption, final ProgressMonitor monitor) throws GitException.CheckoutConflictException, GitException {
        return new CommandInvoker().runMethod(new Callable<GitMergeResult>(){

            @Override
            public GitMergeResult call() throws Exception {
                return GitClient.this.delegate.merge(revision, ffOption, monitor);
            }
        }, "merge");
    }

    public GitPullResult pull(final String remote, final List<String> fetchRefSpecifications, final String branchToMerge, final ProgressMonitor monitor) throws GitException.AuthorizationException, GitException.CheckoutConflictException, GitException.MissingObjectException, GitException {
        return new CommandInvoker().runMethod(new Callable<GitPullResult>(){

            @Override
            public GitPullResult call() throws Exception {
                return GitClient.this.delegate.pull(remote, fetchRefSpecifications, branchToMerge, monitor);
            }
        }, "pull");
    }

    public GitPushResult push(final String remote, final List<String> pushRefSpecifications, final List<String> fetchRefSpecifications, final ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        return new CommandInvoker().runMethod(new Callable<GitPushResult>(){

            @Override
            public GitPushResult call() throws Exception {
                return GitClient.this.delegate.push(remote, pushRefSpecifications, fetchRefSpecifications, monitor);
            }
        }, "push");
    }

    public GitRebaseResult rebase(final GitClient.RebaseOperationType operation, final String upstream, final ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        return new CommandInvoker().runMethod(new Callable<GitRebaseResult>(){

            @Override
            public GitRebaseResult call() throws Exception {
                return GitClient.this.delegate.rebase(operation, upstream, monitor);
            }
        }, "rebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        List<org.netbeans.libs.git.GitClient> list = unusedClients;
        synchronized (list) {
            if (this.released) {
                return;
            }
            unusedClients.add(this.delegate);
            this.released = true;
        }
        cleanTask.schedule(15000);
    }

    public void remove(final File[] roots, final boolean cached, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.remove(roots, cached, monitor);
                return null;
            }
        }, "remove", roots);
    }

    public void removeNotificationListener(NotificationListener listener) {
        this.delegate.removeNotificationListener(listener);
    }

    public void removeRemote(final String remote, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.removeRemote(remote, monitor);
                return null;
            }
        }, "removeRemote");
    }

    public void rename(final File source, final File target, final boolean after, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.rename(source, target, after, monitor);
                return null;
            }
        }, "rename", new File[]{source, target});
    }

    public void renameBranch(final String oldName, final String newName, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.renameBranch(oldName, newName, monitor);
                return null;
            }
        }, "renameBranch");
    }

    public void reset(final File[] roots, final String revision, final boolean recursively, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.reset(roots, revision, recursively, monitor);
                return null;
            }
        }, "reset", roots);
    }

    public void reset(final String revision, final GitClient.ResetType resetType, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.reset(revision, resetType, monitor);
                return null;
            }
        }, "reset");
    }

    public GitRevertResult revert(final String revision, final String commitMessage, final boolean commit, final ProgressMonitor monitor) throws GitException.MissingObjectException, GitException.CheckoutConflictException, GitException {
        return new CommandInvoker().runMethod(new Callable<GitRevertResult>(){

            @Override
            public GitRevertResult call() throws Exception {
                return GitClient.this.delegate.revert(revision, commitMessage, commit, monitor);
            }
        }, "revert");
    }

    public void setCallback(GitClientCallback callback) {
        this.delegate.setCallback(callback);
    }

    public void setRemote(final GitRemoteConfig remoteConfig, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.setRemote(remoteConfig, monitor);
                return null;
            }
        }, "setRemote");
    }

    public void stashApply(final int stashIndex, final boolean drop, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.stashApply(stashIndex, drop, monitor);
                return null;
            }
        }, "stashApply");
    }

    public void stashDrop(final int stashIndex, final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.stashDrop(stashIndex, monitor);
                return null;
            }
        }, "stashDrop");
    }

    public void stashDropAll(final ProgressMonitor monitor) throws GitException {
        new CommandInvoker().runMethod(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GitClient.this.delegate.stashDropAll(monitor);
                return null;
            }
        }, "stashDropAll");
    }

    public GitRevisionInfo[] stashList(final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<GitRevisionInfo[]>(){

            @Override
            public GitRevisionInfo[] call() throws Exception {
                return GitClient.this.delegate.stashList(monitor);
            }
        }, "stashList");
    }

    public GitRevisionInfo stashSave(final String message, final boolean includeUntracked, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<GitRevisionInfo>(){

            @Override
            public GitRevisionInfo call() throws Exception {
                return GitClient.this.delegate.stashSave(message, includeUntracked, monitor);
            }
        }, "stashSave");
    }

    public File[] unignore(final File[] files, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<File[]>(){

            @Override
            public File[] call() throws Exception {
                return GitClient.this.delegate.unignore(files, monitor);
            }
        }, "unignore");
    }

    public GitRefUpdateResult updateReference(final String referenceName, final String newId, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<GitRefUpdateResult>(){

            @Override
            public GitRefUpdateResult call() throws Exception {
                return GitClient.this.delegate.updateReference(referenceName, newId, monitor);
            }
        }, "updateReference");
    }

    public Map<File, GitSubmoduleStatus> updateSubmodules(final File[] roots, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<Map<File, GitSubmoduleStatus>>(){

            @Override
            public Map<File, GitSubmoduleStatus> call() throws Exception {
                return GitClient.this.delegate.updateSubmodules(roots, monitor);
            }
        }, "updateSubmodules");
    }

    public GitBranch updateTracking(final String localBranchName, final String remoteBranchName, final ProgressMonitor monitor) throws GitException {
        return new CommandInvoker().runMethod(new Callable<GitBranch>(){

            @Override
            public GitBranch call() throws Exception {
                return GitClient.this.delegate.setUpstreamBranch(localBranchName, remoteBranchName, monitor);
            }
        }, "setUpstreamBranch");
    }

    private static boolean isExclusiveRepositoryAccess(String commandName) {
        return !PARALLELIZABLE_COMMANDS.contains(commandName);
    }

    private static boolean modifiesWorkingTree(String commandName) {
        return !WORKING_TREE_READ_ONLY_COMMANDS.contains(commandName);
    }

    private static boolean withoutAuthenticator(String commandName) {
        return NETWORK_COMMANDS.contains(commandName);
    }

    private final class CommandInvoker {
        private CommandInvoker() {
        }

        private <T> T runMethod(Callable<T> callable, String methodName) throws GitException {
            if (GitClient.this.released) {
                throw new IllegalStateException("Client already released.");
            }
            return this.runMethod(callable, methodName, new File[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T runMethod(Callable<T> callable, String methodName, File[] roots) throws GitException {
            try {
                if (GitClient.isExclusiveRepositoryAccess(methodName)) {
                    LOG.log(Level.FINER, "Running an exclusive command: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot});
                    if (GitClient.this.progressSupport != null) {
                        GitClient.this.progressSupport.setRepositoryStateBlocked(GitClient.this.repositoryRoot, true);
                    }
                    File file = GitClient.this.repositoryRoot;
                    synchronized (file) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        if (GitClient.this.progressSupport != null) {
                            LOG.log(Level.FINEST, "Repository unblocked: {0}", GitClient.this.repositoryRoot);
                            GitClient.this.progressSupport.setRepositoryStateBlocked(GitClient.this.repositoryRoot, false);
                        }
                        return this.runMethodIntern(callable, methodName, roots);
                    }
                }
                LOG.log(Level.FINER, "Running a parallelizable command: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                return this.runMethodIntern(callable, methodName, roots);
            }
            catch (InterruptedException ex) {
                throw new GitCanceledException(ex);
            }
            catch (GitException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex.getCause() != null) {
                    throw new GitException(ex.getCause());
                }
                throw new GitException(ex);
            }
        }

        private <T> T runMethodIntern(final Callable<T> toRun, final String methodName, File[] roots) throws Throwable {
            Utils.logVCSClientEvent((String)"GIT", (String)"JAVALIB");
            boolean refreshIndexTimestamp = GitClient.modifiesWorkingTree(methodName);
            Callable callable = new Callable<T>(){

                @Override
                public T call() throws Exception {
                    Callable callable = new Callable<T>(){

                        @Override
                        public T call() throws Exception {
                            Object v;
                            boolean repositoryInfoRefreshNeeded;
                            block14: {
                                long t;
                                block12: {
                                    Object object;
                                    block13: {
                                        repositoryInfoRefreshNeeded = NEED_REPOSITORY_REFRESH_COMMANDS.contains(methodName);
                                        t = 0L;
                                        if (LOG.isLoggable(Level.FINE)) {
                                            t = System.currentTimeMillis();
                                            LOG.log(Level.FINE, "Starting a git command: [{0}] on repository [{1}]", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                                        }
                                        if (!GitClient.withoutAuthenticator(methodName)) break block12;
                                        object = NetworkSettings.suppressAuthenticationDialog((Callable)toRun);
                                        if (!LOG.isLoggable(Level.FINE)) break block13;
                                        LOG.log(Level.FINE, "Git command finished: [{0}] on repository [{1}], lasted {2} ms", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath(), System.currentTimeMillis() - t});
                                    }
                                    if (repositoryInfoRefreshNeeded) {
                                        LOG.log(Level.FINER, "Refreshing repository info after: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                                        RepositoryInfo info = RepositoryInfo.getInstance(GitClient.this.repositoryRoot);
                                        info.refresh();
                                    }
                                    return object;
                                }
                                try {
                                    v = toRun.call();
                                    if (!LOG.isLoggable(Level.FINE)) break block14;
                                }
                                catch (Exception ex) {
                                    block15: {
                                        Object t2;
                                        block16: {
                                            try {
                                                if (GitClient.this.progressSupport != null && GitClient.this.progressSupport.isCanceled() || !new GitClientExceptionHandler(GitClient.this, GitClient.this.handleAuthenticationIssues).handleException(ex)) break block15;
                                                t2 = this.call();
                                                if (!LOG.isLoggable(Level.FINE)) break block16;
                                            }
                                            catch (Throwable throwable) {
                                                if (LOG.isLoggable(Level.FINE)) {
                                                    LOG.log(Level.FINE, "Git command finished: [{0}] on repository [{1}], lasted {2} ms", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath(), System.currentTimeMillis() - t});
                                                }
                                                if (repositoryInfoRefreshNeeded) {
                                                    LOG.log(Level.FINER, "Refreshing repository info after: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                                                    RepositoryInfo info = RepositoryInfo.getInstance(GitClient.this.repositoryRoot);
                                                    info.refresh();
                                                }
                                                throw throwable;
                                            }
                                            LOG.log(Level.FINE, "Git command finished: [{0}] on repository [{1}], lasted {2} ms", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath(), System.currentTimeMillis() - t});
                                        }
                                        if (repositoryInfoRefreshNeeded) {
                                            LOG.log(Level.FINER, "Refreshing repository info after: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                                            RepositoryInfo info = RepositoryInfo.getInstance(GitClient.this.repositoryRoot);
                                            info.refresh();
                                        }
                                        return t2;
                                    }
                                    throw ex;
                                }
                                LOG.log(Level.FINE, "Git command finished: [{0}] on repository [{1}], lasted {2} ms", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath(), System.currentTimeMillis() - t});
                            }
                            if (repositoryInfoRefreshNeeded) {
                                LOG.log(Level.FINER, "Refreshing repository info after: {0} on {1}", new Object[]{methodName, GitClient.this.repositoryRoot.getAbsolutePath()});
                                RepositoryInfo info = RepositoryInfo.getInstance(GitClient.this.repositoryRoot);
                                info.refresh();
                            }
                            return v;
                        }
                    };
                    return callable.call();
                }
            };
            try {
                if (refreshIndexTimestamp) {
                    return Git.getInstance().runWithoutExternalEvents(GitClient.this.repositoryRoot, methodName, callable);
                }
                return (T)callable.call();
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() != null) {
                    throw ex.getCause();
                }
                throw ex;
            }
        }
    }

    private static class CleanTask
    implements Runnable {
        private CleanTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet<org.netbeans.libs.git.GitClient> toRelease;
            List<org.netbeans.libs.git.GitClient> list = unusedClients;
            synchronized (list) {
                toRelease = new HashSet<org.netbeans.libs.git.GitClient>(unusedClients);
                unusedClients.clear();
            }
            for (org.netbeans.libs.git.GitClient unusuedClient : toRelease) {
                unusuedClient.release();
            }
        }
    }
}

