/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.projects;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.javaee.specs.support.api.JaxWsStackSupport;
import org.netbeans.modules.websvc.api.jaxws.project.JAXWSVersionProvider;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.openide.filesystems.FileObject;

public class J2SEJAXWSVersionProvider
implements JAXWSVersionProvider {
    private Project project;

    public J2SEJAXWSVersionProvider(Project project) {
        this.project = project;
    }

    public String getJAXWSVersion() {
        String version = "2.1.3";
        SourceGroup[] srcGroups = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (srcGroups != null && srcGroups.length > 0) {
            ClassPath classpath = ClassPath.getClassPath((FileObject)srcGroups[0].getRootFolder(), (String)"classpath/compile");
            FileObject fo = classpath.findResource("com/sun/xml/ws/util/version.properties");
            if (fo != null) {
                try {
                    InputStream is = fo.getInputStream();
                    BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                    String ln = null;
                    String ver = null;
                    while ((ln = r.readLine()) != null) {
                        String line = ln.trim();
                        if (!line.startsWith("major-version=")) continue;
                        ver = line.substring(14);
                    }
                    r.close();
                    version = ver;
                }
                catch (IOException ex) {
                    Logger.getLogger(J2SEJAXWSVersionProvider.class.getName()).log(Level.INFO, "Failed to detect JKAX-WS version", ex);
                }
            } else {
                WSStack jdkJaxWsStack = JaxWsStackSupport.getJdkJaxWsStack();
                if (jdkJaxWsStack != null) {
                    return jdkJaxWsStack.getVersion().toString();
                }
            }
        }
        return version;
    }
}

