/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.findusages;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.groovy.refactoring.GroovyRefactoringPlugin;
import org.netbeans.modules.groovy.refactoring.findusages.FindUsagesElement;
import org.netbeans.modules.groovy.refactoring.findusages.impl.AbstractFindUsages;
import org.netbeans.modules.groovy.refactoring.findusages.impl.FindAllSubtypes;
import org.netbeans.modules.groovy.refactoring.findusages.impl.FindAllUsages;
import org.netbeans.modules.groovy.refactoring.findusages.impl.FindDirectSubtypesOnly;
import org.netbeans.modules.groovy.refactoring.findusages.impl.FindMethodUsages;
import org.netbeans.modules.groovy.refactoring.findusages.impl.FindOverridingMethods;
import org.netbeans.modules.groovy.refactoring.findusages.impl.FindTypeUsages;
import org.netbeans.modules.groovy.refactoring.findusages.impl.FindVariableUsages;
import org.netbeans.modules.groovy.refactoring.findusages.model.RefactoringElement;
import org.netbeans.modules.groovy.refactoring.utils.GroovyProjectUtil;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;

public class FindUsagesPlugin
extends GroovyRefactoringPlugin {
    public FindUsagesPlugin(FileObject fileObject, RefactoringElement element, AbstractRefactoring whereUsedQuery) {
        super(element, fileObject, whereUsedQuery);
    }

    public Problem prepare(RefactoringElementsBag elementsBag) {
        if (this.element == null) {
            throw new IllegalStateException("There is no element in refactoring plugin !");
        }
        this.refactorResults(elementsBag, this.collectUsages());
        this.fireProgressListenerStop();
        return null;
    }

    protected void refactorResults(RefactoringElementsBag elementsBag, List<FindUsagesElement> usages) {
        for (FindUsagesElement usage : usages) {
            elementsBag.add(this.refactoring, (RefactoringElementImplementation)usage);
        }
    }

    private List<FindUsagesElement> collectUsages() {
        AbstractFindUsages strategy;
        if (this.isMethodUsage()) {
            strategy = this.getMethodStrategy();
        } else if (this.isClassTypeUsage()) {
            strategy = this.getClassStrategy();
        } else if (this.isVariableUsage()) {
            strategy = this.getVariableStrategy();
        } else {
            throw new IllegalStateException("Not implemented yet for kind: " + this.element.getKind());
        }
        List<FileObject> relevantFiles = this.getRelevantFiles();
        this.fireProgressListenerStart(1, relevantFiles.size());
        for (FileObject relevantFile : relevantFiles) {
            strategy.findUsages(relevantFile);
            this.fireProgressListenerStep();
        }
        return strategy.getResults();
    }

    private boolean isClassTypeUsage() {
        ASTNode node = this.element.getNode();
        switch (this.element.getKind()) {
            case CLASS: 
            case INTERFACE: {
                return true;
            }
            case PROPERTY: 
            case FIELD: {
                if (!(node instanceof ClassNode)) break;
                return true;
            }
        }
        return false;
    }

    private boolean isMethodUsage() {
        switch (this.element.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                return true;
            }
        }
        return false;
    }

    private boolean isVariableUsage() {
        ASTNode node = this.element.getNode();
        switch (this.element.getKind()) {
            case VARIABLE: {
                return true;
            }
            case PROPERTY: 
            case FIELD: {
                if (node instanceof ClassNode) break;
                return true;
            }
        }
        return false;
    }

    private AbstractFindUsages getMethodStrategy() {
        if (this.isFindOverridingMethods()) {
            return new FindOverridingMethods(this.element);
        }
        if (this.isFindUsages()) {
            return new FindMethodUsages(this.element);
        }
        if (this.element.getKind() == ElementKind.CONSTRUCTOR) {
            return new FindAllUsages(this.element);
        }
        return new FindMethodUsages(this.element);
    }

    private AbstractFindUsages getClassStrategy() {
        if (this.isFindAllSubtypes()) {
            return new FindAllSubtypes(this.element);
        }
        if (this.isFindDirectSubtypes()) {
            return new FindDirectSubtypesOnly(this.element);
        }
        if (this.isFindUsages()) {
            return new FindTypeUsages(this.element);
        }
        return new FindAllUsages(this.element);
    }

    private AbstractFindUsages getVariableStrategy() {
        return new FindVariableUsages(this.element);
    }

    private List<FileObject> getRelevantFiles() {
        return GroovyProjectUtil.getGroovyFilesInProject(this.fileObject);
    }

    private boolean isFindOverridingMethods() {
        return this.isSet(WhereUsedQueryConstants.FIND_OVERRIDING_METHODS);
    }

    private boolean isFindAllSubtypes() {
        return this.isSet(WhereUsedQueryConstants.FIND_SUBCLASSES);
    }

    private boolean isFindDirectSubtypes() {
        return this.isSet(WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES);
    }

    private boolean isFindUsages() {
        if (this.refactoring instanceof WhereUsedQuery) {
            return ((WhereUsedQuery)this.refactoring).getBooleanValue((Object)"FIND_REFERENCES");
        }
        return false;
    }

    private boolean isSet(WhereUsedQueryConstants constant) {
        if (this.refactoring instanceof WhereUsedQuery) {
            return ((WhereUsedQuery)this.refactoring).getBooleanValue((Object)constant);
        }
        return false;
    }
}

