/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;

public final class ElementUtils {
    private ElementUtils() {
    }

    public static boolean isAbstractTraitMethod(MethodElement method) {
        return method.getType().isTrait() && method.isAbstract();
    }

    public static boolean isVoidOrNeverType(Collection<TypeResolver> types) {
        if (types.size() == 1) {
            for (TypeResolver returnType : types) {
                String rawTypeName = returnType.getRawTypeName();
                if (!"void".equals(rawTypeName) && !"never".equals(rawTypeName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isToStringMagicMethod(MethodElement method) {
        return method.getName().equals("__toString");
    }

    public static String getToStringMagicMethodBody(TypeElement type, ElementQuery.Index index) {
        StringBuilder sb = new StringBuilder();
        if (index != null) {
            ArrayList<FieldElement> allFields = new ArrayList<FieldElement>(index.getAlllFields(type));
            allFields.sort((f1, f2) -> Integer.compare(f1.getOffset(), f2.getOffset()));
            sb.append("return \"").append(type.getName()).append("[");
            if (allFields.isEmpty()) {
                sb.append("]\";");
            } else {
                boolean isFirst = true;
                for (FieldElement field : allFields) {
                    if (field.isStatic()) continue;
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append("\n. \", ");
                    }
                    sb.append(field.getName(false)).append("=\"").append(" . $this->").append(field.getName(false));
                }
                sb.append("\n. \"]\";");
            }
        }
        return sb.toString();
    }
}

