/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.util.SimpleDocTreeVisitor;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.ReferenceParser;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.DocTreeMaker;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import nbjavac.StringWrapper;

public class DocCommentParser {
    private final ParserFactory fac;
    private final JCDiagnostic.Factory diags;
    private final DiagnosticSource diagSource;
    private final Tokens.Comment comment;
    private final DocTreeMaker m;
    private final Names names;
    private final boolean isHtmlFile;
    private final DocTree.Kind textKind;
    private final Markdown markdown;
    private char[] buf;
    private int bp;
    private int buflen;
    private char ch;
    private int textStart = -1;
    private int lastNonWhite = -1;
    private boolean newline = true;
    private boolean inPre = false;
    private final Map<Name, TagParser> tagParsers;

    public DocCommentParser(ParserFactory fac, DiagnosticSource diagSource, Tokens.Comment comment) {
        this(fac, diagSource, comment, false);
    }

    public DocCommentParser(ParserFactory fac, DiagnosticSource diagSource, Tokens.Comment comment, boolean isHtmlFile) {
        this.fac = fac;
        this.diags = fac.log.diags;
        this.diagSource = diagSource;
        this.comment = comment.stripIndent();
        this.names = fac.names;
        this.isHtmlFile = isHtmlFile;
        this.textKind = isHtmlFile ? DocTree.Kind.TEXT : DocCommentParser.getTextKind(comment);
        this.m = fac.docTreeMaker;
        this.tagParsers = this.createTagParsers();
        this.markdown = this.textKind == DocTree.Kind.MARKDOWN ? new Markdown() : null;
    }

    private static DocTree.Kind getTextKind(Tokens.Comment c) {
        return switch (c.getStyle()) {
            case Tokens.Comment.CommentStyle.JAVADOC_BLOCK -> DocTree.Kind.TEXT;
            case Tokens.Comment.CommentStyle.JAVADOC_LINE -> DocTree.Kind.MARKDOWN;
            default -> throw new IllegalArgumentException(c.getStyle().name());
        };
    }

    public DCTree.DCDocComment parse() {
        List postamble;
        String c = this.comment.getText();
        this.buf = new char[c.length() + 1];
        c.getChars(0, c.length(), this.buf, 0);
        this.buf[this.buf.length - 1] = 26;
        this.buflen = this.buf.length - 1;
        this.bp = -1;
        this.nextChar();
        List preamble = this.isHtmlFile ? this.content(Phase.PREAMBLE) : List.nil();
        List<DCTree> body = this.content(Phase.BODY);
        List<DCTree> tags = this.blockTags();
        List<Object> list = postamble = this.isHtmlFile ? this.content(Phase.POSTAMBLE) : List.nil();
        int pos = this.textKind == DocTree.Kind.MARKDOWN ? 0 : (!preamble.isEmpty() ? ((DCTree)preamble.head).pos : (!body.isEmpty() ? ((DCTree)body.head).pos : (!tags.isEmpty() ? ((DCTree)tags.head).pos : (!postamble.isEmpty() ? ((DCTree)postamble.head).pos : 0))));
        return this.m.at(pos).newDocCommentTree(this.comment, body, tags, preamble, postamble);
    }

    void nextChar() {
        this.ch = this.buf[this.bp < this.buflen ? (this.bp = this.bp + 1) : this.buflen];
        switch (this.ch) {
            case '\n': {
                this.newline = true;
                break;
            }
            case '\r': {
                if (this.bp + 1 < this.buflen && this.buf[this.bp + 1] == '\n') {
                    ++this.bp;
                    this.ch = (char)10;
                }
                this.newline = true;
            }
        }
    }

    char peekChar() {
        return this.buf[this.bp < this.buflen ? this.bp + 1 : this.buflen];
    }

    protected List<DCTree> blockContent() {
        while (this.isHorizontalWhitespace(this.ch) && this.bp < this.buflen) {
            this.nextChar();
        }
        return this.content(Phase.BODY);
    }

    protected List<DCTree> content(Phase phase) {
        ListBuffer<DCTree> trees = new ListBuffer<DCTree>();
        ListBuffer<DCTree> mainTrees = null;
        this.textStart = -1;
        int depth = 1;
        int pos = this.bp;
        if (this.textKind == DocTree.Kind.MARKDOWN) {
            this.initMarkdownLine();
        }
        block36: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\r': {
                    this.nextChar();
                    if (this.textKind != DocTree.Kind.MARKDOWN) continue block36;
                    this.initMarkdownLine();
                    continue block36;
                }
                case '\t': 
                case ' ': {
                    if (this.textKind == DocTree.Kind.MARKDOWN && this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.nextChar();
                    continue block36;
                }
                case '&': {
                    switch (this.textKind) {
                        case MARKDOWN: {
                            this.defaultContentCharacter();
                            continue block36;
                        }
                        case TEXT: {
                            this.entity(trees);
                            continue block36;
                        }
                    }
                    throw this.unknownTextKind(this.textKind);
                }
                case '<': {
                    switch (this.textKind) {
                        case MARKDOWN: {
                            this.defaultContentCharacter();
                            continue block36;
                        }
                        case TEXT: {
                            this.newline = false;
                            if (this.isHtmlFile) {
                                switch (phase.ordinal()) {
                                    case 0: {
                                        if (!this.isEndPreamble()) break;
                                        trees.add(this.html());
                                        if (this.textStart == -1) {
                                            this.textStart = this.bp;
                                            this.lastNonWhite = -1;
                                        }
                                        this.newline = true;
                                        break block36;
                                    }
                                    case 1: {
                                        if (!this.isEndBody()) break;
                                        this.addPendingText(trees, this.lastNonWhite);
                                        break block36;
                                    }
                                }
                            }
                            this.addPendingText(trees, this.bp - 1);
                            trees.add(this.html());
                            if (this.inPre) {
                                if (mainTrees == null) {
                                    mainTrees = trees;
                                    trees = new ListBuffer<DCTree>();
                                }
                            } else if (mainTrees != null) {
                                mainTrees.addAll((Collection<DCTree>)this.normalizePreContent(trees));
                                trees = mainTrees;
                                mainTrees = null;
                            }
                            if (phase == Phase.PREAMBLE || phase == Phase.POSTAMBLE || this.textStart != -1) continue block36;
                            this.textStart = this.bp;
                            this.lastNonWhite = -1;
                            continue block36;
                        }
                    }
                    throw this.unknownTextKind(this.textKind);
                }
                case '{': {
                    switch (phase.ordinal()) {
                        case 0: 
                        case 2: {
                            this.defaultContentCharacter();
                            break;
                        }
                        case 1: {
                            this.inlineTag(trees);
                            break;
                        }
                        case 3: {
                            if (this.inlineTag(trees)) break;
                            ++depth;
                        }
                    }
                    continue block36;
                }
                case '}': {
                    if (phase == Phase.INLINE) {
                        this.newline = false;
                        if (--depth == 0) {
                            this.addPendingText(trees, this.bp - 1);
                            this.nextChar();
                            return trees.toList();
                        }
                        this.nextChar();
                        continue block36;
                    }
                    this.defaultContentCharacter();
                    continue block36;
                }
                case '@': {
                    if (this.newline) {
                        char peek = this.peekChar();
                        if (peek == '@' || peek == '*') {
                            this.addPendingText(trees, this.bp - 1);
                            this.nextChar();
                            trees.add(this.m.at(this.bp - 1).newEscapeTree(this.ch));
                            this.newline = false;
                            this.nextChar();
                            this.textStart = this.bp;
                            continue block36;
                        }
                        if (phase == Phase.BODY) {
                            this.addPendingText(trees, this.lastNonWhite);
                            break block36;
                        }
                    } else if (this.textStart != -1 && this.buf[this.bp - 1] == '*' && this.peekChar() == '/') {
                        this.addPendingText(trees, this.bp - 1);
                        this.nextChar();
                        trees.add(this.m.at(this.bp - 1).newEscapeTree('/'));
                        this.newline = false;
                        this.nextChar();
                        this.textStart = this.bp;
                        continue block36;
                    }
                    this.defaultContentCharacter();
                    continue block36;
                }
                case '\\': {
                    switch (this.textKind) {
                        case MARKDOWN: {
                            this.defaultContentCharacter();
                            this.nextChar();
                            this.defaultContentCharacter();
                            break;
                        }
                        case TEXT: {
                            this.defaultContentCharacter();
                        }
                    }
                    continue block36;
                }
                case '`': 
                case '~': {
                    switch (this.textKind) {
                        case MARKDOWN: {
                            this.newline = false;
                            if (this.textStart == -1) {
                                this.textStart = this.bp;
                            }
                            this.lastNonWhite = this.bp;
                            boolean saveNewline = this.newline;
                            boolean isCodeFence = this.markdown.isCodeFence();
                            if (this.ch == '`' || this.ch == '~' && isCodeFence) {
                                int end = this.markdown.skipCode();
                                if (end == -1) {
                                    if (isCodeFence) {
                                        this.lastNonWhite = this.buflen - 1;
                                        break;
                                    }
                                    this.bp = this.lastNonWhite;
                                    this.newline = saveNewline;
                                    this.nextChar();
                                    break;
                                }
                                this.lastNonWhite = end - 1;
                                break;
                            }
                            this.nextChar();
                            break;
                        }
                        case TEXT: {
                            this.defaultContentCharacter();
                        }
                    }
                    continue block36;
                }
                default: {
                    this.defaultContentCharacter();
                    continue block36;
                }
            }
        }
        if (this.lastNonWhite != -1) {
            this.addPendingText(trees, this.lastNonWhite);
        }
        if (mainTrees != null) {
            mainTrees.addAll((Collection<DCTree>)trees);
            trees = mainTrees;
            mainTrees = null;
        }
        return phase == Phase.INLINE ? List.of(this.erroneous("dc.unterminated.inline.tag", pos)) : trees.toList();
    }

    void defaultContentCharacter() {
        this.newline = false;
        if (this.textStart == -1) {
            this.textStart = this.bp;
        }
        this.lastNonWhite = this.bp;
        this.nextChar();
    }

    void initMarkdownLine() {
        if (this.textStart == -1) {
            this.textStart = this.bp;
        }
        this.markdown.update();
        if (this.markdown.isIndentedCodeBlock()) {
            this.markdown.skipLine();
            this.lastNonWhite = this.bp - 1;
        }
    }

    private IllegalStateException unknownTextKind(DocTree.Kind textKind) {
        return new IllegalStateException(textKind.toString());
    }

    protected List<DCTree> blockTags() {
        ListBuffer<DCTree> tags = new ListBuffer<DCTree>();
        while (this.bp < this.buflen && this.ch == '@') {
            tags.add(this.blockTag());
        }
        return tags.toList();
    }

    protected DCTree blockTag() {
        this.newline = false;
        int p = this.bp;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readTagName();
                TagParser tp = this.tagParsers.get(name);
                if (tp == null) {
                    List<DCTree> content = this.blockContent();
                    return this.m.at(p).newUnknownBlockTagTree((javax.lang.model.element.Name)name, content);
                }
                if (tp.allowsBlock()) {
                    return tp.parse(p, TagParser.Kind.BLOCK);
                }
                return this.erroneous("dc.bad.inline.tag", p);
            }
            int prefPos = this.bp;
            this.blockContent();
            return this.erroneous("dc.no.tag.name", p, prefPos);
        }
        catch (ParseException e) {
            this.blockContent();
            return this.erroneous(e.getMessage(), p, e.pos);
        }
    }

    private String showPos(int p) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(p).append("] ");
        if (p >= 0) {
            for (int i = Math.max(p - 10, 0); i < Math.min(p + 10, this.buflen); ++i) {
                if (i == p) {
                    sb.append("[");
                }
                char c = this.buf[i];
                sb.append(switch (c) {
                    case '\n' -> '|';
                    case ' ' -> '_';
                    default -> c;
                });
                if (i != p) continue;
                sb.append("]");
            }
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean inlineTag(ListBuffer<DCTree> list) {
        this.newline = false;
        this.nextChar();
        if (this.ch == '@') {
            if (this.peekChar() != '@') {
                this.addPendingText(list, this.bp - 2);
                list.add(this.inlineTag());
                this.textStart = this.bp;
                this.lastNonWhite = -1;
                return true;
            }
            if (this.textStart == -1) {
                this.textStart = this.bp - 1;
            }
            this.addPendingText(list, this.bp - 1);
            this.nextChar();
            list.add(this.m.at(this.bp - 1).newEscapeTree('@'));
            this.nextChar();
            this.textStart = -1;
            this.lastNonWhite = this.bp;
            return false;
        }
        if (this.textStart == -1) {
            this.textStart = this.bp - 1;
        }
        this.lastNonWhite = this.bp;
        return false;
    }

    protected DCTree inlineTag() {
        int p = this.bp - 1;
        try {
            this.nextChar();
            if (!this.isIdentifierStart(this.ch)) {
                return this.erroneous("dc.no.tag.name", p, this.bp);
            }
            Name name = this.readTagName();
            TagParser tp = this.tagParsers.get(name);
            if (tp == null) {
                this.skipWhitespace();
                DCTree.DCText text = this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                this.nextChar();
                return ((DCTree.DCEndPosTree)((Object)this.m.at(p).newUnknownInlineTagTree((javax.lang.model.element.Name)name, List.of(text)))).setEndPos(this.bp);
            }
            if (!tp.retainWhiteSpace) {
                this.skipWhitespace();
            }
            if (tp.allowsInline()) {
                DCTree.DCEndPosTree tree = (DCTree.DCEndPosTree)tp.parse(p, TagParser.Kind.INLINE);
                return tree.setEndPos(this.bp);
            }
            DCTree.DCText text = this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
            this.nextChar();
            return ((DCTree.DCEndPosTree)((Object)this.m.at(p).newUnknownInlineTagTree((javax.lang.model.element.Name)name, List.of(text)))).setEndPos(this.bp);
        }
        catch (ParseException e) {
            return this.erroneous(e.getMessage(), p, e.pos);
        }
    }

    private DCTree.DCText inlineText(WhitespaceRetentionPolicy whitespacePolicy) throws ParseException {
        switch (whitespacePolicy.ordinal()) {
            case 2: {
                this.skipWhitespace();
                break;
            }
            case 1: {
                if (this.ch != ' ') break;
                this.nextChar();
                break;
            }
        }
        int pos = this.bp;
        int depth = 1;
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '{': {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    ++depth;
                    break;
                }
                case '}': {
                    if (--depth == 0) {
                        return this.m.at(pos).newTextTree(this.newString(pos, this.bp));
                    }
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    break;
                }
                default: {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                }
            }
            this.nextChar();
        }
        throw new ParseException("dc.unterminated.inline.tag");
    }

    protected DCTree.DCReference reference(ReferenceParser.Mode mode) throws ParseException {
        int pos = this.bp;
        int depth = 0;
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (depth != 0) break;
                    break block9;
                }
                case '(': 
                case '<': {
                    this.newline = false;
                    ++depth;
                    break;
                }
                case ')': 
                case '>': {
                    this.newline = false;
                    --depth;
                    break;
                }
                case '}': {
                    if (this.bp == pos) {
                        return null;
                    }
                    this.newline = false;
                    break block9;
                }
                case '@': {
                    if (!this.newline) break;
                    break block9;
                }
                default: {
                    this.newline = false;
                }
            }
            this.nextChar();
        }
        if (depth > 0) {
            throw new ParseException("dc.unterminated.signature");
        }
        String sig = this.newString(pos, this.bp);
        try {
            ReferenceParser.Reference ref = new ReferenceParser(this.fac).parse(sig, mode);
            return (DCTree.DCReference)this.m.at(pos).newReferenceTree(sig, ref).setEndPos(this.bp);
        }
        catch (ReferenceParser.ParseException pe) {
            throw new ParseException(pos + pe.pos, pe.getMessage());
        }
    }

    protected DCTree.DCIdentifier identifier() throws ParseException {
        this.skipWhitespace();
        int pos = this.bp;
        if (this.isJavaIdentifierStart(this.ch)) {
            Name name = this.readJavaIdentifier();
            return this.m.at(pos).newIdentifierTree(name);
        }
        throw new ParseException("dc.identifier.expected");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DCTree.DCText quotedString() {
        this.newline = false;
        int pos = this.bp;
        this.nextChar();
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    this.nextChar();
                    return this.m.at(pos).newTextTree(this.newString(pos, this.bp));
                }
                case '@': {
                    if (!this.newline) break;
                    return null;
                }
            }
            this.nextChar();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DCTree.DCText inlineWord() {
        int pos = this.bp;
        int depth = 0;
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return this.m.at(pos).newTextTree(this.newString(pos, this.bp));
                }
                case '@': {
                    if (!this.newline) break;
                    return null;
                }
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    if (depth == 0) {
                        return this.m.at(pos).newTextTree(this.newString(pos, this.bp));
                    }
                    --depth;
                }
            }
            this.newline = false;
            this.nextChar();
        }
        return null;
    }

    private List<DCTree> inlineContent() {
        this.skipWhitespace();
        return this.content(Phase.INLINE);
    }

    protected void entity(ListBuffer<DCTree> list) {
        this.newline = false;
        this.addPendingText(list, this.bp - 1);
        list.add(this.entity());
        if (this.textStart == -1) {
            this.textStart = this.bp;
            this.lastNonWhite = -1;
        }
    }

    protected DCTree entity() {
        int p = this.bp;
        this.nextChar();
        Name name = null;
        if (this.ch == '#') {
            int namep = this.bp;
            this.nextChar();
            if (this.isDecimalDigit(this.ch)) {
                this.nextChar();
                while (this.bp < this.buflen && this.isDecimalDigit(this.ch)) {
                    this.nextChar();
                }
                name = this.names.fromChars(this.buf, namep, this.bp - namep);
            } else if (this.ch == 'x' || this.ch == 'X') {
                this.nextChar();
                if (this.isHexDigit(this.ch)) {
                    this.nextChar();
                    while (this.bp < this.buflen && this.isHexDigit(this.ch)) {
                        this.nextChar();
                    }
                    name = this.names.fromChars(this.buf, namep, this.bp - namep);
                }
            }
        } else if (this.isIdentifierStart(this.ch)) {
            name = this.readIdentifier();
        }
        if (name == null) {
            return this.erroneous("dc.bad.entity", p);
        }
        if (this.ch != ';') {
            return this.erroneous("dc.missing.semicolon", p);
        }
        this.nextChar();
        return this.m.at(p).newEntityTree(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEndPreamble() {
        int savedpos = this.bp;
        try {
            if (this.ch == '<') {
                this.nextChar();
            }
            if (this.isIdentifierStart(this.ch)) {
                String name;
                switch (name = StringUtils.toLowerCase(this.readIdentifier().toString())) {
                    case "body": {
                        while (this.bp < this.buflen && this.ch != '>') {
                            this.nextChar();
                        }
                        if (this.ch == '>') {
                            this.nextChar();
                        }
                        while (this.bp < this.buflen && this.isWhitespace(this.ch)) {
                            this.nextChar();
                        }
                        if (this.ch == '<') {
                            this.nextChar();
                            if (this.isIdentifierStart(this.ch) && (name = StringUtils.toLowerCase(this.readIdentifier().toString())).equals("main")) {
                                boolean bl = false;
                                return bl;
                            }
                        }
                        boolean bl = true;
                        return bl;
                    }
                    case "main": {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.bp = savedpos;
            this.ch = this.buf[this.bp];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEndBody() {
        int savedpos = this.bp;
        try {
            if (this.ch == '<') {
                this.nextChar();
            }
            if (this.ch == '/') {
                this.nextChar();
                if (this.isIdentifierStart(this.ch)) {
                    String name;
                    switch (name = StringUtils.toLowerCase(this.readIdentifier().toString())) {
                        case "body": 
                        case "main": {
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.bp = savedpos;
            this.ch = this.buf[this.bp];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean peek(String s) {
        int savedpos = this.bp;
        try {
            if (this.ch == '<') {
                this.nextChar();
            }
            if (this.ch == '/') {
                if (s.charAt(0) != this.ch) {
                    boolean bl = false;
                    return bl;
                }
                s = s.substring(1);
                this.nextChar();
            }
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readIdentifier();
                boolean bl = StringUtils.toLowerCase(name.toString()).equals(s);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.bp = savedpos;
            this.ch = this.buf[this.bp];
        }
    }

    private DCTree html() {
        int p = this.bp;
        this.nextChar();
        if (this.isIdentifierStart(this.ch)) {
            Name name = this.readIdentifier();
            List<DCTree> attrs = this.htmlAttrs();
            if (attrs != null) {
                boolean selfClosing = false;
                if (this.ch == '/') {
                    this.nextChar();
                    selfClosing = true;
                }
                if (this.ch == '>') {
                    this.nextChar();
                    if ("pre".equalsIgnoreCase(name.toString())) {
                        this.inPre = true;
                    }
                    return ((DCTree.DCEndPosTree)((Object)this.m.at(p).newStartElementTree((javax.lang.model.element.Name)name, attrs, selfClosing))).setEndPos(this.bp);
                }
            }
        } else if (this.ch == '/') {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readIdentifier();
                this.skipWhitespace();
                if (this.ch == '>') {
                    this.nextChar();
                    if ("pre".equalsIgnoreCase(name.toString())) {
                        this.inPre = false;
                    }
                    return this.m.at(p).newEndElementTree(name).setEndPos(this.bp);
                }
            }
        } else if (this.ch == '!') {
            this.nextChar();
            if (this.ch == '-') {
                this.nextChar();
                if (this.ch == '-') {
                    this.nextChar();
                    while (this.bp < this.buflen) {
                        int dash = 0;
                        while (this.bp < this.buflen && this.ch == '-') {
                            ++dash;
                            this.nextChar();
                        }
                        if (dash >= 2 && this.ch == '>') {
                            this.nextChar();
                            return this.m.at(p).newCommentTree(this.newString(p, this.bp));
                        }
                        this.nextChar();
                    }
                }
            } else if (this.isIdentifierStart(this.ch) && this.peek("doctype")) {
                this.readIdentifier();
                this.nextChar();
                this.skipWhitespace();
                int d = this.bp;
                while (this.bp < this.buflen) {
                    if (this.ch == '>') {
                        int mark = this.bp;
                        this.nextChar();
                        return this.m.at(d).newDocTypeTree(this.newString(d, mark));
                    }
                    this.nextChar();
                }
            } else {
                String CDATA = "[CDATA[";
                for (int i = 0; i < CDATA.length(); ++i) {
                    if (this.ch != CDATA.charAt(i)) {
                        return this.erroneous("dc.invalid.html", p);
                    }
                    this.nextChar();
                }
                while (this.bp < this.buflen) {
                    if (this.ch == ']') {
                        int n = 0;
                        while (this.bp < this.buflen && this.ch == ']') {
                            ++n;
                            this.nextChar();
                        }
                        if (n < 2 || this.ch != '>') continue;
                        this.nextChar();
                        return this.m.at(p).newTextTree(this.newString(p, this.bp));
                    }
                    this.nextChar();
                }
                return this.erroneous("dc.invalid.html", p);
            }
        }
        this.bp = p + 1;
        this.ch = this.buf[this.bp];
        return this.erroneous("dc.malformed.html", p);
    }

    protected List<DCTree> htmlAttrs() {
        ListBuffer<AttributeTree> attrs = new ListBuffer<AttributeTree>();
        this.skipWhitespace();
        while (this.bp < this.buflen && this.isIdentifierStart(this.ch)) {
            int namePos = this.bp;
            Name name = this.readAttributeName();
            this.skipWhitespace();
            List<DCTree> value = null;
            AttributeTree.ValueKind vkind = AttributeTree.ValueKind.EMPTY;
            if (this.ch == '=') {
                ListBuffer<DCTree> v = new ListBuffer<DCTree>();
                this.nextChar();
                this.skipWhitespace();
                if (this.ch == '\'' || this.ch == '\"') {
                    this.newline = false;
                    vkind = this.ch == '\'' ? AttributeTree.ValueKind.SINGLE : AttributeTree.ValueKind.DOUBLE;
                    char quote = this.ch;
                    this.nextChar();
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && this.ch != quote) {
                        this.attrValueChar(v);
                    }
                    this.addPendingText(v, this.bp - 1, DocTree.Kind.TEXT);
                    this.nextChar();
                } else {
                    vkind = AttributeTree.ValueKind.UNQUOTED;
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && !this.isUnquotedAttrValueTerminator(this.ch)) {
                        this.attrValueChar(v);
                    }
                    this.addPendingText(v, this.bp - 1, DocTree.Kind.TEXT);
                }
                this.skipWhitespace();
                value = v.toList();
            }
            AttributeTree attr = this.m.at(namePos).newAttributeTree((javax.lang.model.element.Name)name, vkind, value);
            attrs.add(attr);
        }
        return attrs.toList();
    }

    ListBuffer<DCTree> normalizePreContent(ListBuffer<DCTree> trees) {
        static enum State {
            BEFORE_CODE,
            AFTER_CODE,
            SUCCEEDED,
            FAILED;

        }
        if (this.textKind == DocTree.Kind.MARKDOWN || this.isHtmlFile) {
            return trees;
        }
        SimpleDocTreeVisitor<DCTree, Context> visitor = new SimpleDocTreeVisitor<DCTree, Context>(){

            @Override
            public DCTree visitText(TextTree text, Context cx) {
                static enum State {
                    BEFORE_CODE,
                    AFTER_CODE,
                    SUCCEEDED,
                    FAILED;

                }
                class Context {
                    State state = State.BEFORE_CODE;

                    Context() {
                        static enum State {
                            BEFORE_CODE,
                            AFTER_CODE,
                            SUCCEEDED,
                            FAILED;

                        }
                    }

                    void unexpectedTree() {
                        static enum State {
                            BEFORE_CODE,
                            AFTER_CODE,
                            SUCCEEDED,
                            FAILED;

                        }
                        if (this.state != State.SUCCEEDED) {
                            this.state = State.FAILED;
                        }
                    }
                }
                if (cx.state == State.BEFORE_CODE && text.getBody().matches("[ \t]+")) {
                    return null;
                }
                if (cx.state == State.AFTER_CODE && text.getBody().startsWith("\n")) {
                    cx.state = State.SUCCEEDED;
                    return DocCommentParser.this.m.at(((DCTree.DCText)text).pos + 1).newTextTree(text.getBody().substring(1));
                }
                cx.unexpectedTree();
                return (DCTree)((Object)text);
            }

            @Override
            public DCTree visitLiteral(LiteralTree literal, Context cx) {
                static enum State {
                    BEFORE_CODE,
                    AFTER_CODE,
                    SUCCEEDED,
                    FAILED;

                }
                if (cx.state == State.BEFORE_CODE && literal.getBody().getBody().startsWith("\n")) {
                    cx.state = State.SUCCEEDED;
                    DCTree.DCText oldBody = (DCTree.DCText)literal.getBody();
                    DCTree.DCText newBody = DocCommentParser.this.m.at(oldBody.pos + 1).newTextTree(oldBody.getBody().substring(1));
                    DocCommentParser.this.m.at(((DCTree)((Object)literal)).pos);
                    return literal.getKind() == DocTree.Kind.CODE ? DocCommentParser.this.m.newCodeTree(newBody) : DocCommentParser.this.m.newLiteralTree(newBody);
                }
                cx.unexpectedTree();
                return (DCTree)((Object)literal);
            }

            @Override
            public DCTree visitStartElement(StartElementTree node, Context cx) {
                static enum State {
                    BEFORE_CODE,
                    AFTER_CODE,
                    SUCCEEDED,
                    FAILED;

                }
                if (cx.state == State.BEFORE_CODE && node.getName().toString().equalsIgnoreCase("code")) {
                    cx.state = State.AFTER_CODE;
                } else {
                    cx.unexpectedTree();
                }
                return (DCTree)((Object)node);
            }

            @Override
            protected DCTree defaultAction(DocTree node, Context cx) {
                cx.unexpectedTree();
                return (DCTree)node;
            }
        };
        Context cx = new Context();
        ListBuffer<DCTree> normalized = new ListBuffer<DCTree>();
        for (DCTree tree : trees) {
            DCTree visited = (DCTree)visitor.visit(tree, cx);
            if (visited != null) {
                normalized.add(visited);
            }
            if (cx.state != State.FAILED) continue;
            return trees;
        }
        return cx.state == State.SUCCEEDED ? normalized : trees;
    }

    protected void attrValueChar(ListBuffer<DCTree> list) {
        switch (this.ch) {
            case '&': {
                this.entity(list);
                break;
            }
            case '{': {
                this.inlineTag(list);
                break;
            }
            default: {
                this.nextChar();
            }
        }
    }

    protected void addPendingText(ListBuffer<DCTree> list, int textEnd) {
        this.addPendingText(list, textEnd, this.textKind);
    }

    protected void addPendingText(ListBuffer<DCTree> list, int textEnd, DocTree.Kind kind) {
        if (this.textStart != -1) {
            if (this.textStart <= textEnd) {
                switch (kind) {
                    case TEXT: {
                        list.add(this.m.at(this.textStart).newTextTree(this.newString(this.textStart, textEnd + 1)));
                        break;
                    }
                    case MARKDOWN: {
                        list.add((DCTree)this.m.at(this.textStart).newRawTextTree(DocTree.Kind.MARKDOWN, this.newString(this.textStart, textEnd + 1)));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(kind.toString());
                    }
                }
            }
            this.textStart = -1;
        }
    }

    protected DCTree.DCErroneous erroneous(String code, int pos) {
        return this.erroneous(code, pos, -1);
    }

    protected DCTree.DCErroneous erroneous(String code, int pos, int pref) {
        int i;
        block4: for (i = this.bp - 1; i > pos; --i) {
            switch (this.buf[i]) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    continue block4;
                }
            }
        }
        if (pref == -1) {
            pref = i;
        }
        int end = i + 1;
        this.textStart = -1;
        JCDiagnostic.DiagnosticPosition dp = DCTree.createDiagnosticPosition(this.comment, pos, pref, end);
        JCDiagnostic diag = this.diags.error(null, this.diagSource, dp, code, new Object[0]);
        return ((DCTree.DCErroneous)this.m.at(pos).newErroneousTree(this.newString(pos, end), (Diagnostic)diag)).setPrefPos(pref);
    }

    protected boolean isIdentifierStart(char ch) {
        return Character.isUnicodeIdentifierStart(ch);
    }

    protected Name readIdentifier() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isUnicodeIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected Name readAttributeName() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '-')) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected Name readTagName() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '.' || this.ch == '-' || this.ch == ':')) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected boolean isJavaIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    protected Name readJavaIdentifier() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isJavaIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected Name readSystemPropertyName() {
        int pos = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isUnicodeIdentifierPart(this.ch) || this.ch == '.') {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, pos, this.bp - pos);
    }

    protected boolean isDecimalDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    protected boolean isHexDigit(char ch) {
        return '0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'f' || 'A' <= ch && ch <= 'F';
    }

    protected boolean isUnquotedAttrValueTerminator(char ch) {
        return switch (ch) {
            case '\t', '\n', '\f', '\r', ' ', '\"', '\'', '<', '=', '>', '`' -> true;
            default -> false;
        };
    }

    protected boolean isWhitespace(char ch) {
        return Character.isWhitespace(ch);
    }

    protected boolean isHorizontalWhitespace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    protected void skipWhitespace() {
        while (this.bp < this.buflen && this.isWhitespace(this.ch)) {
            this.nextChar();
        }
    }

    String newString(int start, int end) {
        return new String(this.buf, start, end - start);
    }

    private Map<Name, TagParser> createTagParsers() {
        TagParser[] parsers = new TagParser[]{new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.AUTHOR){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> name = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newAuthorTree(name);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.CODE, true){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCText text = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(pos).newCodeTree(text);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.DEPRECATED){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> reason = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newDeprecatedTree(reason);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.DOC_ROOT){

            @Override
            public DCTree parse(int pos) throws ParseException {
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(pos).newDocRootTree();
                }
                int savedPos = DocCommentParser.this.bp;
                DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                DocCommentParser.this.nextChar();
                throw new ParseException(savedPos, "dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.EXCEPTION){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference ref = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_DISALLOWED);
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newExceptionTree((ReferenceTree)ref, description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.HIDDEN){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> reason = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newHiddenTree(reason);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.INDEX){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCText term;
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    throw new ParseException("dc.no.content");
                }
                DCTree.DCText dCText = term = DocCommentParser.this.ch == '\"' ? DocCommentParser.this.quotedString() : DocCommentParser.this.inlineWord();
                if (term == null) {
                    throw new ParseException("dc.no.content");
                }
                DocCommentParser.this.skipWhitespace();
                List<Object> description = List.nil();
                if (DocCommentParser.this.ch != '}') {
                    description = DocCommentParser.this.inlineContent();
                } else {
                    DocCommentParser.this.nextChar();
                }
                return DocCommentParser.this.m.at(pos).newIndexTree((DocTree)term, description);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.INHERIT_DOC){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_DISALLOWED);
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    if (ref == null) {
                        return DocCommentParser.this.m.at(pos).newInheritDocTree();
                    }
                    return DocCommentParser.this.m.at(pos).newInheritDocTree(ref);
                }
                int errorPos = DocCommentParser.this.bp;
                DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                DocCommentParser.this.nextChar();
                throw new ParseException(errorPos, "dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_OPTIONAL);
                List<DCTree> label = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(pos).newLinkTree((ReferenceTree)ref, label);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK_PLAIN){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_OPTIONAL);
                List<DCTree> label = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(pos).newLinkPlainTree((ReferenceTree)ref, label);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LITERAL, true){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCText text = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(pos).newLiteralTree(text);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.PARAM){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                boolean typaram = false;
                if (DocCommentParser.this.ch == '<') {
                    typaram = true;
                    DocCommentParser.this.nextChar();
                }
                DCTree.DCIdentifier id = DocCommentParser.this.identifier();
                if (typaram) {
                    if (DocCommentParser.this.ch != '>') {
                        throw new ParseException(DocCommentParser.this.bp, "dc.gt.expected");
                    }
                    DocCommentParser.this.nextChar();
                }
                DocCommentParser.this.skipWhitespace();
                List<DCTree> desc = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newParamTree(typaram, (IdentifierTree)id, desc);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.PROVIDES){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference ref = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_DISALLOWED);
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newProvidesTree((ReferenceTree)ref, description);
            }
        }, new TagParser(TagParser.Kind.EITHER, DocTree.Kind.RETURN){

            @Override
            public DCTree parse(int pos, TagParser.Kind kind) {
                List<DCTree> description = switch (kind.ordinal()) {
                    case 1 -> DocCommentParser.this.blockContent();
                    case 0 -> DocCommentParser.this.inlineContent();
                    default -> throw new IllegalArgumentException(kind.toString());
                };
                return DocCommentParser.this.m.at(pos).newReturnTree(kind == TagParser.Kind.INLINE, description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SEE){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                switch (DocCommentParser.this.ch) {
                    case '\"': {
                        DCTree.DCText string = DocCommentParser.this.quotedString();
                        if (string == null) break;
                        DocCommentParser.this.skipWhitespace();
                        if (DocCommentParser.this.ch != '@' && (DocCommentParser.this.ch != '\u001a' || DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1)) break;
                        return DocCommentParser.this.m.at(pos).newSeeTree(List.of(string));
                    }
                    case '<': {
                        List<DCTree> html = DocCommentParser.this.blockContent();
                        if (html == null) break;
                        return DocCommentParser.this.m.at(pos).newSeeTree(html);
                    }
                    case '@': {
                        if (!DocCommentParser.this.newline) break;
                        throw new ParseException("dc.no.content");
                    }
                    case '\u001a': {
                        if (DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1) break;
                        throw new ParseException("dc.no.content");
                    }
                    default: {
                        if (!DocCommentParser.this.isJavaIdentifierStart(DocCommentParser.this.ch) && DocCommentParser.this.ch != '#') break;
                        DCTree.DCReference ref = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_OPTIONAL);
                        List<DCTree> description = DocCommentParser.this.blockContent();
                        return DocCommentParser.this.m.at(pos).newSeeTree(description.prepend(ref));
                    }
                }
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_DATA){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newSerialDataTree(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_FIELD){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCIdentifier name = DocCommentParser.this.identifier();
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference type = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_DISALLOWED);
                List<DCTree> description = null;
                if (DocCommentParser.this.isWhitespace(DocCommentParser.this.ch)) {
                    DocCommentParser.this.skipWhitespace();
                    description = DocCommentParser.this.blockContent();
                }
                return DocCommentParser.this.m.at(pos).newSerialFieldTree((IdentifierTree)name, (ReferenceTree)type, description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newSerialTree(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SINCE){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newSinceTree(description);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.SNIPPET){

            @Override
            DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                List<DCTree> attributes = this.tagAttrs();
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(pos).newSnippetTree(attributes, (TextTree)null);
                }
                if (DocCommentParser.this.ch == ':') {
                    DocCommentParser.this.newline = false;
                    DocCommentParser.this.nextChar();
                    while (DocCommentParser.this.bp < DocCommentParser.this.buflen && DocCommentParser.this.isHorizontalWhitespace(DocCommentParser.this.ch)) {
                        DocCommentParser.this.nextChar();
                    }
                    if (!DocCommentParser.this.newline) {
                        if (DocCommentParser.this.bp >= DocCommentParser.this.buf.length - 1) {
                            throw new ParseException("dc.no.content");
                        }
                        throw new ParseException("dc.unexpected.content");
                    }
                    DocCommentParser.this.nextChar();
                    DCTree.DCText text = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.RETAIN_ALL);
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(pos).newSnippetTree(attributes, (TextTree)text);
                }
                if (DocCommentParser.this.bp >= DocCommentParser.this.buf.length - 1) {
                    throw new ParseException("dc.no.content");
                }
                throw new ParseException("dc.unexpected.content");
            }

            private List<DCTree> tagAttrs() {
                ListBuffer<AttributeTree> attrs = new ListBuffer<AttributeTree>();
                DocCommentParser.this.skipWhitespace();
                while (DocCommentParser.this.bp < DocCommentParser.this.buflen && DocCommentParser.this.isIdentifierStart(DocCommentParser.this.ch)) {
                    int namePos = DocCommentParser.this.bp;
                    Name name = DocCommentParser.this.readAttributeName();
                    DocCommentParser.this.skipWhitespace();
                    List<DCTree> value = null;
                    AttributeTree.ValueKind vkind = AttributeTree.ValueKind.EMPTY;
                    if (DocCommentParser.this.ch == '=') {
                        ListBuffer<DCTree> v = new ListBuffer<DCTree>();
                        DocCommentParser.this.nextChar();
                        DocCommentParser.this.skipWhitespace();
                        if (DocCommentParser.this.ch == '\'' || DocCommentParser.this.ch == '\"') {
                            DocCommentParser.this.newline = false;
                            vkind = DocCommentParser.this.ch == '\'' ? AttributeTree.ValueKind.SINGLE : AttributeTree.ValueKind.DOUBLE;
                            char quote = DocCommentParser.this.ch;
                            DocCommentParser.this.nextChar();
                            DocCommentParser.this.textStart = DocCommentParser.this.bp;
                            while (DocCommentParser.this.bp < DocCommentParser.this.buflen && DocCommentParser.this.ch != quote) {
                                DocCommentParser.this.nextChar();
                            }
                            DocCommentParser.this.addPendingText(v, DocCommentParser.this.bp - 1, DocTree.Kind.TEXT);
                            DocCommentParser.this.nextChar();
                        } else {
                            vkind = AttributeTree.ValueKind.UNQUOTED;
                            DocCommentParser.this.textStart = DocCommentParser.this.bp;
                            while (DocCommentParser.this.bp < DocCommentParser.this.buflen && DocCommentParser.this.ch != '}' && DocCommentParser.this.ch != ':' && !DocCommentParser.this.isUnquotedAttrValueTerminator(DocCommentParser.this.ch)) {
                                DocCommentParser.this.nextChar();
                            }
                            DocCommentParser.this.addPendingText(v, DocCommentParser.this.bp - 1, DocTree.Kind.TEXT);
                        }
                        DocCommentParser.this.skipWhitespace();
                        value = v.toList();
                    }
                    AttributeTree attr = DocCommentParser.this.m.at(namePos).newAttributeTree((javax.lang.model.element.Name)name, vkind, value);
                    attrs.add(attr);
                }
                return attrs.toList();
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SPEC){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCText url = DocCommentParser.this.inlineWord();
                if (url == null || url.isBlank()) {
                    throw new ParseException("dc.no.url");
                }
                DocCommentParser.this.skipWhitespace();
                List<DCTree> title = DocCommentParser.this.blockContent();
                if (title.isEmpty() || DCTree.isBlank(title)) {
                    throw new ParseException("dc.no.title");
                }
                return DocCommentParser.this.m.at(pos).newSpecTree((TextTree)url, title);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.SUMMARY){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> summary = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(pos).newSummaryTree(summary);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.SYSTEM_PROPERTY){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    throw new ParseException("dc.no.content");
                }
                Name propertyName = DocCommentParser.this.readSystemPropertyName();
                if (propertyName == null) {
                    throw new ParseException("dc.no.content");
                }
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch != '}') {
                    DocCommentParser.this.nextChar();
                    throw new ParseException("dc.unexpected.content");
                }
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(pos).newSystemPropertyTree(propertyName);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.THROWS){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference ref = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_DISALLOWED);
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newThrowsTree((ReferenceTree)ref, description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.USES){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference ref = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_DISALLOWED);
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newUsesTree((ReferenceTree)ref, description);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.VALUE){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCText format;
                DocCommentParser.this.skipWhitespace();
                switch (DocCommentParser.this.ch) {
                    case '%': {
                        format = DocCommentParser.this.inlineWord();
                        DocCommentParser.this.skipWhitespace();
                        break;
                    }
                    case '\"': {
                        format = DocCommentParser.this.quotedString();
                        DocCommentParser.this.skipWhitespace();
                        break;
                    }
                    default: {
                        format = null;
                    }
                }
                DCTree.DCReference ref = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_REQUIRED);
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return format == null ? DocCommentParser.this.m.at(pos).newValueTree(ref) : DocCommentParser.this.m.at(pos).newValueTree(format, ref);
                }
                DocCommentParser.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.VERSION){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newVersionTree(description);
            }
        }};
        HashMap<Name, TagParser> tagParsers = new HashMap<Name, TagParser>();
        for (TagParser p : parsers) {
            tagParsers.put(this.names.fromString(p.getTreeKind().tagName), p);
        }
        return tagParsers;
    }

    class Markdown {
        private final java.util.List<BlockInfo> containers = new ArrayList<BlockInfo>();
        private LeafBlockKind leafKind = LeafBlockKind.NONE;
        private int blockId = 0;

        Markdown() {
        }

        void update() {
            LeafBlockKind prevLeafKind = this.leafKind;
            int indent = this.readIndent(0);
            String line = this.peekLine();
            int peekIndex = 0;
            int blockIndex = 0;
            while (true) {
                if (blockIndex == this.containers.size()) {
                    if (prevLeafKind == LeafBlockKind.FENCED_CODE) {
                        return;
                    }
                    int codeIndent = (this.containers.isEmpty() ? 0 : this.containers.get((int)(this.containers.size() - 1)).indent) + 4;
                    if (indent >= codeIndent && prevLeafKind != LeafBlockKind.PARAGRAPH) {
                        this.leafKind = LeafBlockKind.INDENTED_CODE;
                        if (this.leafKind != prevLeafKind) {
                            ++this.blockId;
                        }
                        return;
                    }
                    LineKind peekLineKind = this.getLineKind(line.substring(peekIndex));
                    switch (peekLineKind.ordinal()) {
                        case 5: 
                        case 6: {
                            int count = indent;
                            while (DocCommentParser.this.ch != ' ' && DocCommentParser.this.ch != '\t') {
                                ++count;
                                DocCommentParser.this.nextChar();
                            }
                            int listItemIndent = this.readIndent(count);
                            this.containers.add(new BlockInfo(ContainerBlockKind.LIST_ITEM, listItemIndent));
                            ++blockIndex;
                            peekIndex = listItemIndent - indent;
                            ++this.blockId;
                            break;
                        }
                        case 7: {
                            this.containers.add(new BlockInfo(ContainerBlockKind.QUOTE, indent + 1));
                            ++blockIndex;
                            ++peekIndex;
                            ++this.blockId;
                            break;
                        }
                        case 8: {
                            this.leafKind = LeafBlockKind.PARAGRAPH;
                            return;
                        }
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            this.leafKind = LeafBlockKind.NONE;
                            ++this.blockId;
                            return;
                        }
                        case 4: {
                            this.leafKind = LeafBlockKind.FENCED_CODE;
                            ++this.blockId;
                            return;
                        }
                    }
                    continue;
                }
                BlockInfo block = this.containers.get(blockIndex);
                ContainerBlockKind blockKind = block.blockKind;
                switch (blockKind.ordinal()) {
                    case 0: {
                        if (indent >= block.indent) {
                            ++blockIndex;
                            break;
                        }
                        LineKind peekLineKind = this.getLineKind(line.substring(peekIndex));
                        if (peekLineKind == LineKind.BLANK) {
                            ++blockIndex;
                            break;
                        }
                        if (peekLineKind == LineKind.OTHER && prevLeafKind == LeafBlockKind.PARAGRAPH) {
                            return;
                        }
                        this.closeContainer(blockIndex);
                        ++this.blockId;
                        break;
                    }
                    case 1: {
                        LineKind peekLineKind = this.getLineKind(line.substring(peekIndex));
                        if (peekLineKind == LineKind.BLOCK_QUOTE) {
                            ++blockIndex;
                            ++peekIndex;
                            break;
                        }
                        if (peekLineKind == LineKind.OTHER && prevLeafKind == LeafBlockKind.PARAGRAPH) {
                            return;
                        }
                        this.closeContainer(blockIndex);
                        ++this.blockId;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(blockKind.toString());
                    }
                }
            }
        }

        boolean isIndentedCodeBlock() {
            return this.leafKind == LeafBlockKind.INDENTED_CODE;
        }

        boolean isCodeFence() {
            return this.leafKind == LeafBlockKind.FENCED_CODE;
        }

        private void closeContainer(int index) {
            this.containers.subList(index, this.containers.size()).clear();
        }

        void skipLine() {
            while (DocCommentParser.this.bp < DocCommentParser.this.buflen) {
                if (DocCommentParser.this.ch == '\n' || DocCommentParser.this.ch == '\r') {
                    return;
                }
                DocCommentParser.this.nextChar();
            }
        }

        int skipCode() {
            char term = DocCommentParser.this.ch;
            int count = this.count(term);
            LeafBlockKind initialLeafKind = this.leafKind;
            boolean isFenced = this.leafKind == LeafBlockKind.FENCED_CODE;
            int initialBlockId = this.blockId;
            block3: while (DocCommentParser.this.bp < DocCommentParser.this.buflen) {
                switch (DocCommentParser.this.ch) {
                    case '\n': 
                    case '\r': {
                        DocCommentParser.this.nextChar();
                        this.update();
                        if (isFenced) {
                            if ((this.leafKind != LeafBlockKind.FENCED_CODE || DocCommentParser.this.ch != term || this.count(DocCommentParser.this.ch) < count) && this.blockId == initialBlockId) continue block3;
                            this.leafKind = LeafBlockKind.NONE;
                            return DocCommentParser.this.bp;
                        }
                        if (this.blockId == initialBlockId) continue block3;
                        return -1;
                    }
                }
                if (DocCommentParser.this.ch == term && initialLeafKind != LeafBlockKind.FENCED_CODE && this.count(DocCommentParser.this.ch) == count) {
                    return DocCommentParser.this.bp;
                }
                DocCommentParser.this.nextChar();
            }
            return -1;
        }

        private int readIndent(int initialCount) {
            int TABSTOP = 4;
            int indent = initialCount;
            while (DocCommentParser.this.bp < DocCommentParser.this.buflen) {
                switch (DocCommentParser.this.ch) {
                    case ' ': {
                        ++indent;
                        break;
                    }
                    case '\t': {
                        indent += 4 - indent % 4;
                        break;
                    }
                    default: {
                        return indent;
                    }
                }
                DocCommentParser.this.nextChar();
            }
            return indent;
        }

        private LineKind getLineKind(String s) {
            if (StringWrapper.isBlank((String)s)) {
                return LineKind.BLANK;
            }
            switch (s.charAt(0)) {
                case '#': 
                case '*': 
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '=': 
                case '>': 
                case '_': 
                case '`': 
                case '~': {
                    for (LineKind lk : LineKind.values()) {
                        if (!lk.pattern.matcher(s).matches()) continue;
                        return lk;
                    }
                    break;
                }
            }
            return LineKind.OTHER;
        }

        private String peekLine() {
            for (int p = DocCommentParser.this.bp; p < DocCommentParser.this.buflen; ++p) {
                switch (DocCommentParser.this.buf[p]) {
                    case '\n': 
                    case '\r': {
                        return DocCommentParser.this.newString(DocCommentParser.this.bp, p);
                    }
                }
            }
            return DocCommentParser.this.newString(DocCommentParser.this.bp, DocCommentParser.this.buflen);
        }

        private int count(char c) {
            int n = 1;
            DocCommentParser.this.nextChar();
            while (DocCommentParser.this.bp < DocCommentParser.this.buflen && DocCommentParser.this.ch == c) {
                ++n;
                DocCommentParser.this.nextChar();
            }
            return n;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[containers:" + String.valueOf(this.containers) + ", leafKind:" + String.valueOf((Object)this.leafKind) + ", blockId:" + this.blockId + "]";
        }

        private static enum LeafBlockKind {
            NONE,
            PARAGRAPH,
            FENCED_CODE,
            INDENTED_CODE;

        }

        private record BlockInfo(ContainerBlockKind blockKind, int indent) {
        }

        private static enum ContainerBlockKind {
            LIST_ITEM,
            QUOTE;

        }
    }

    private static enum Phase {
        PREAMBLE,
        BODY,
        POSTAMBLE,
        INLINE;

    }

    private static abstract class TagParser {
        final Kind kind;
        final DocTree.Kind treeKind;
        final boolean retainWhiteSpace;

        TagParser(Kind k, DocTree.Kind tk) {
            this.kind = k;
            this.treeKind = tk;
            this.retainWhiteSpace = false;
        }

        TagParser(Kind k, DocTree.Kind tk, boolean retainWhiteSpace) {
            this.kind = k;
            this.treeKind = tk;
            this.retainWhiteSpace = retainWhiteSpace;
        }

        boolean allowsBlock() {
            return this.kind != Kind.INLINE;
        }

        boolean allowsInline() {
            return this.kind != Kind.BLOCK;
        }

        DocTree.Kind getTreeKind() {
            return this.treeKind;
        }

        DCTree parse(int pos, Kind kind) throws ParseException {
            if (kind != this.kind && this.kind != Kind.EITHER) {
                throw new IllegalArgumentException(kind.toString());
            }
            return this.parse(pos);
        }

        DCTree parse(int pos) throws ParseException {
            throw new UnsupportedOperationException();
        }

        static enum Kind {
            INLINE,
            BLOCK,
            EITHER;

        }
    }

    static class ParseException
    extends Exception {
        private static final long serialVersionUID = 0L;
        final int pos;

        ParseException(String key) {
            this(-1, key);
        }

        ParseException(int pos, String key) {
            super(key);
            this.pos = pos;
        }
    }

    private static enum WhitespaceRetentionPolicy {
        RETAIN_ALL,
        REMOVE_FIRST_SPACE,
        REMOVE_ALL;

    }

    static enum LineKind {
        BLANK(Pattern.compile("[ \t]*")),
        ATX_HEADER(Pattern.compile("#{1,6}([ \t].*|$)")),
        SETEXT_UNDERLINE(Pattern.compile("(=+|-+)[ \t]*")),
        THEMATIC_BREAK(Pattern.compile("((\\*[ \t]*+){3,})|((-[ \t]*+){3,})|((_[ \t]*+){3,})")),
        CODE_FENCE(Pattern.compile("(`{3,}[^`]*+)|(~{3,}.*+)")),
        BULLETED_LIST_ITEM(Pattern.compile("[-+*][ \t].*")),
        ORDERED_LIST_ITEM(Pattern.compile("[0-9]{1,9}[.)][ \t].*")),
        BLOCK_QUOTE(Pattern.compile(">.*")),
        OTHER(Pattern.compile(".*"));

        final Pattern pattern;

        private LineKind(Pattern p) {
            this.pattern = p;
        }
    }
}

