/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.web.jsf.editor.facelets.AbstractFaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrarySupport;
import org.netbeans.modules.web.jsf.editor.facelets.LibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.LibraryDescriptorException;
import org.netbeans.modules.web.jsf.editor.facelets.TldProxyLibraryDescriptor;
import org.netbeans.modules.web.jsfapi.api.LibraryType;
import org.netbeans.modules.web.jsfapi.spi.LibraryUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class FaceletsLibrary
extends AbstractFaceletsLibrary {
    private final Set<String> validNamespaces;
    private final Map<String, AbstractFaceletsLibrary.NamedComponent> components = new HashMap<String, AbstractFaceletsLibrary.NamedComponent>();
    private LibraryDescriptor libraryDescriptor;
    private LibraryDescriptor faceletsLibraryDescriptor;
    private String defaultPrefix;
    private final URL libraryDescriptorSource;

    public FaceletsLibrary(FaceletsLibrarySupport support, Set<String> allValidNamespaces, URL libraryDescriptorSourceURL) {
        super(support, allValidNamespaces.iterator().next());
        this.validNamespaces = allValidNamespaces;
        this.libraryDescriptorSource = libraryDescriptorSourceURL;
    }

    protected synchronized LibraryDescriptor getFaceletsLibraryDescriptor() throws LibraryDescriptorException {
        if (this.faceletsLibraryDescriptor == null) {
            FileObject libraryDescriptorSourceFile = URLMapper.findFileObject((URL)this.libraryDescriptorSource);
            this.faceletsLibraryDescriptor = FaceletsLibraryDescriptor.create(libraryDescriptorSourceFile);
        }
        return this.faceletsLibraryDescriptor;
    }

    @Override
    public Map<String, ? extends AbstractFaceletsLibrary.NamedComponent> getComponentsMap() {
        return this.components;
    }

    public String getNamespace() {
        return this.validNamespaces.iterator().next();
    }

    @Override
    public URL getLibraryDescriptorSource() {
        return this.libraryDescriptorSource;
    }

    public LibraryType getType() {
        return LibraryType.CLASS;
    }

    public String getDefaultNamespace() {
        return null;
    }

    @Override
    public synchronized String getDefaultPrefix() {
        if (this.defaultPrefix == null) {
            try {
                this.defaultPrefix = this.getFaceletsLibraryDescriptor().getPrefix();
            }
            catch (LibraryDescriptorException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (this.defaultPrefix == null) {
                this.defaultPrefix = super.getDefaultPrefix();
            }
            if (this.defaultPrefix == null) {
                this.defaultPrefix = LibraryUtils.generateDefaultPrefix((String)this.getNamespace());
            }
        }
        return this.defaultPrefix;
    }

    @Override
    public synchronized LibraryDescriptor getLibraryDescriptor() {
        if (this.libraryDescriptor == null) {
            try {
                this.libraryDescriptor = new TldProxyLibraryDescriptor(this.getFaceletsLibraryDescriptor(), this.support.getJsfSupport().getIndex());
            }
            catch (LibraryDescriptorException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.libraryDescriptor;
    }

    public void putConverter(String name, String id) {
        this.components.put(name, new AbstractFaceletsLibrary.Converter(name, id, null));
    }

    public void putConverter(String name, String id, Class handlerClass) {
        this.components.put(name, new AbstractFaceletsLibrary.Converter(name, id, handlerClass));
    }

    public void putValidator(String name, String id) {
        this.components.put(name, new AbstractFaceletsLibrary.Validator(name, id, null));
    }

    public void putValidator(String name, String id, Class handlerClass) {
        this.components.put(name, new AbstractFaceletsLibrary.Validator(name, id, handlerClass));
    }

    public void putBehavior(String name, String id) {
        this.components.put(name, new AbstractFaceletsLibrary.Behavior(name, id, null));
    }

    public void putBehavior(String name, String id, Class handlerClass) {
        this.components.put(name, new AbstractFaceletsLibrary.Behavior(name, id, handlerClass));
    }

    public void putTagHandler(String name, Class type) {
        this.components.put(name, new AbstractFaceletsLibrary.TagHandler(name, type));
    }

    public void putComponent(String name, String componentType, String rendererType) {
        this.components.put(name, new AbstractFaceletsLibrary.Component(name, componentType, rendererType, null));
    }

    public void putComponent(String name, String componentType, String rendererType, Class handlerClass) {
        this.components.put(name, new AbstractFaceletsLibrary.Component(name, componentType, rendererType, handlerClass));
    }

    public void putUserTag(String name, URL source) {
        this.components.put(name, new AbstractFaceletsLibrary.UserTag(name, source));
    }

    public void putCompositeComponentTag(String name, String resourceId) {
        this.components.put(name, new AbstractFaceletsLibrary.CompositeComponentTag(name, resourceId));
    }

    public void putFunction(String name, Method method) {
        this.components.put(name, new AbstractFaceletsLibrary.Function(name, method));
    }

    public AbstractFaceletsLibrary.NamedComponent createNamedComponent(String name) {
        return new AbstractFaceletsLibrary.NamedComponent(name);
    }

    public AbstractFaceletsLibrary.Function createFunction(String name, Method method) {
        return new AbstractFaceletsLibrary.Function(name, method);
    }

    public Set<String> getValidNamespaces() {
        return this.validNamespaces;
    }
}

