/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.jtreg;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.Transport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public class JPDAStart
implements Runnable {
    private static final RequestProcessor RP = new RequestProcessor(JPDAStart.class);
    private String transport = "dt_socket";
    private String name;
    private String stopClassName;
    private String stopMethod;
    private ClassPath additionalSourcePath;
    private final Object[] lock = new Object[3];
    private Project project;
    private final String actionName;
    private final InputOutput io;

    JPDAStart(InputOutput inputOutput, String actionName) {
        this.io = inputOutput;
        this.actionName = actionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<String, Integer> execute(Project project) throws Throwable {
        this.project = project;
        this.io.getOut().println("NetBeans: JPDA Listening Start...");
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            RP.post((Runnable)this);
            this.lock.wait();
            if (this.lock[1] != null) {
                throw (Throwable)this.lock[1];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Pair.of((Object)((String)this.lock[2]), (Object)((Integer)this.lock[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            try {
                Transport t;
                ListeningConnector lc = null;
                Iterator<ListeningConnector> i = Bootstrap.virtualMachineManager().listeningConnectors().iterator();
                while (i.hasNext() && ((t = (lc = i.next()).transport()) == null || !t.name().equals(this.getTransport()))) {
                }
                if (lc == null) {
                    throw new RuntimeException("No trasports named " + this.getTransport() + " found!");
                }
                final Map<String, Connector.Argument> args = lc.defaultArguments();
                String address = lc.startListening(args);
                int colon = address.indexOf(58);
                int port = Integer.parseInt(address.substring(colon + 1));
                Connector.IntegerArgument portArg = (Connector.IntegerArgument)args.get("port");
                portArg.setValue(port);
                this.lock[0] = port;
                this.lock[2] = colon != -1 ? address.substring(0, colon) : null;
                this.io.getOut().println("JPDA Address: " + address);
                this.io.getOut().println("Port:" + this.lock[0]);
                ClassPath sourcePath = ClassPath.EMPTY;
                if (this.getAdditionalSourcePath() != null) {
                    sourcePath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{sourcePath, this.getAdditionalSourcePath()});
                }
                ClassPath jdkSourcePath = ClassPath.EMPTY;
                final HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("sourcepath", sourcePath);
                properties.put("name", this.getName());
                properties.put("jdksources", jdkSourcePath);
                properties.put("baseDir", FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
                final ListeningConnector flc = lc;
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JPDADebugger.startListening((ListeningConnector)flc, (Map)args, (Object[])new Object[]{properties});
                        }
                        catch (DebuggerStartException ex) {
                            JPDAStart.this.io.getErr().println("Debugger Start Error.");
                            Logger.getLogger(JPDAStart.class.getName()).log(Level.INFO, "Debugger Start Error.", ex);
                        }
                    }
                });
            }
            catch (IOException ioex) {
                this.io.getErr().println("IO Error:");
                this.lock[1] = ioex;
            }
            catch (IllegalConnectorArgumentsException icaex) {
                this.io.getErr().println("Illegal Connector");
                this.lock[1] = icaex;
            }
            finally {
                this.lock.notify();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStopClassName() {
        return this.stopClassName;
    }

    public void setStopClassName(String stopClassName) {
        this.stopClassName = stopClassName;
    }

    public String getStopMethod() {
        return this.stopMethod;
    }

    public void setStopMethod(String stopMethod) {
        this.stopMethod = stopMethod;
    }

    public ClassPath getAdditionalSourcePath() {
        return this.additionalSourcePath;
    }

    public void setAdditionalSourcePath(ClassPath additionalSourcePath) {
        this.additionalSourcePath = additionalSourcePath;
    }

    private static class Listener
    extends DebuggerManagerAdapter {
        private MethodBreakpoint breakpoint;
        private final Set<JPDADebugger> debuggers = new HashSet<JPDADebugger>();

        Listener(MethodBreakpoint breakpoint) {
            this.breakpoint = breakpoint;
        }

        public void propertyChange(PropertyChangeEvent e) {
            int state;
            if ("state".equals(e.getPropertyName()) && ((state = ((Integer)e.getNewValue()).intValue()) == 4 || state == 3)) {
                if (this.breakpoint != null) {
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.breakpoint);
                    this.breakpoint = null;
                }
                this.dispose();
            }
        }

        private void dispose() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("debuggerEngines", (DebuggerManagerListener)this);
            for (JPDADebugger d : this.debuggers) {
                d.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            }
        }

        public void engineAdded(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.addPropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            this.debuggers.add(debugger);
        }

        public void engineRemoved(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            this.debuggers.remove(debugger);
        }

        private void replaceBreakpoint(MethodBreakpoint b2) {
            this.breakpoint = b2;
        }
    }
}

