/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.actions;

import java.awt.Point;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;
import org.netbeans.modules.web.jsf.navigation.graph.actions.SystemFileSystemSupport;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class PageFlowPopupProvider
implements PopupMenuProvider {
    private static final String PATH_PAGEFLOW_NODE_ACTIONS = "PageFlowEditor/PopupActions/PageFlowSceneElement";
    private static final String PATH_PAGEFLOW_SCENE_ACTIONS = "PageFlowEditor/PopupActions/Scene";
    private WeakReference<Lookup> lookupWRef = new WeakReference<Object>(null);
    private WeakReference<PageFlowScene> refPageFlowScene;

    public JPopupMenu getPopupMenu(Widget widget, Point point) {
        PageFlowScene scene = (PageFlowScene)widget.getScene();
        this.setGraphScene(scene);
        Object obj = scene.getHoveredObject();
        PageFlowView view = scene.getPageFlowView();
        if (obj != null) {
            Set elements = scene.getSelectedObjects();
            if (!elements.contains(obj)) {
                HashSet<Object> set = new HashSet<Object>();
                set.add(obj);
                scene.setSelectedObjects(set);
            }
            if (obj instanceof Page) {
                Action[] actions;
                Page pageNode = (Page)obj;
                Action[] pageNodeActions = pageNode.getActions(true);
                Action[] fileSystemActions = SystemFileSystemSupport.getActions(PATH_PAGEFLOW_NODE_ACTIONS);
                if (pageNodeActions == null || pageNodeActions.length == 0) {
                    actions = fileSystemActions;
                } else if (fileSystemActions == null || fileSystemActions.length == 0) {
                    actions = pageNodeActions;
                } else {
                    actions = new Action[pageNodeActions.length + fileSystemActions.length];
                    System.arraycopy(fileSystemActions, 0, actions, 0, fileSystemActions.length);
                    System.arraycopy(pageNodeActions, 0, actions, fileSystemActions.length, pageNodeActions.length);
                }
                return Utilities.actionsToPopup((Action[])actions, (Lookup)view.getLookup());
            }
            if (obj instanceof Pin) {
                Pin pinNode = (Pin)obj;
                Action[] actions = pinNode.getActions();
                return Utilities.actionsToPopup((Action[])actions, (Lookup)view.getLookup());
            }
            return Utilities.actionsToPopup((Action[])SystemFileSystemSupport.getActions(PATH_PAGEFLOW_NODE_ACTIONS), (Lookup)view.getLookup());
        }
        return Utilities.actionsToPopup((Action[])SystemFileSystemSupport.getActions(PATH_PAGEFLOW_SCENE_ACTIONS), (Lookup)view.getLookup());
    }

    private Lookup getLookup() {
        Lookup lookup = (Lookup)this.lookupWRef.get();
        if (lookup == null) {
            InstanceContent ic = new InstanceContent();
            ic.add((Object)this.getGraphScene());
            lookup = new AbstractLookup((AbstractLookup.Content)ic);
            this.lookupWRef = new WeakReference<Lookup>(lookup);
        }
        return lookup;
    }

    public PageFlowScene getGraphScene() {
        PageFlowScene scene = null;
        if (this.refPageFlowScene != null) {
            scene = (PageFlowScene)((Object)this.refPageFlowScene.get());
        }
        return scene;
    }

    public void setGraphScene(PageFlowScene graphScene) {
        this.refPageFlowScene = new WeakReference<PageFlowScene>(graphScene);
    }
}

