/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.nativeimage.debugger.displayer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.nativeimage.api.debug.NIVariable;

final class Utils {
    private Utils() {
    }

    static Map<String, NIVariable> getVarsByName(NIVariable[] vars) {
        switch (vars.length) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                return Collections.singletonMap(vars[0].getName(), vars[0]);
            }
        }
        HashMap<String, NIVariable> varsByName = new HashMap<String, NIVariable>(vars.length);
        for (NIVariable var : vars) {
            varsByName.put(var.getName(), var);
        }
        return Collections.unmodifiableMap(varsByName);
    }

    @CheckForNull
    static NIVariable findChild(NIVariable[] children, String ... names) {
        NIVariable ch = null;
        for (String name : names) {
            if (ch != null) {
                children = ch.getChildren();
            }
            if ((ch = Utils.findChild(name, children)) != null) continue;
            return null;
        }
        return ch;
    }

    @CheckForNull
    private static NIVariable findChild(String name, NIVariable[] children) {
        for (NIVariable var : children) {
            if (!name.equals(var.getName())) continue;
            return var;
        }
        return null;
    }

    static String quoteJavaTypes(String expr) {
        String clazz = "(class ";
        int i = expr.indexOf("(class ");
        if (i >= 0) {
            StringBuilder quoted = new StringBuilder();
            int j = 0;
            do {
                quoted.append(Utils.quoteJavaVarNames(expr.substring(j, i += "(class ".length())));
                j = expr.indexOf(41, i);
                if (j > 0) {
                    while (expr.charAt(j - 1) == '*') {
                        --j;
                    }
                } else {
                    return expr;
                }
                quoted.append('\'');
                quoted.append(expr.substring(i, j));
                quoted.append('\'');
            } while ((i = expr.indexOf("(class ", j)) > 0);
            quoted.append(Utils.quoteJavaVarNames(expr.substring(j)));
            return quoted.toString();
        }
        return expr;
    }

    private static String quoteJavaVarNames(String expr) {
        int i = expr.indexOf(46);
        if (i > 0) {
            StringBuilder quoted = new StringBuilder();
            int i0 = 0;
            do {
                int i2;
                int i1;
                char c = '\u0000';
                for (i1 = i - 1; i1 >= i0 && ((c = expr.charAt(i1)) == '.' || Character.isJavaIdentifierPart(c)); --i1) {
                }
                if (i1 >= i0) {
                    c = expr.charAt(++i1);
                }
                if (!Character.isJavaIdentifierStart(c)) {
                    quoted.append(expr.substring(i0, ++i));
                    i0 = i;
                    continue;
                }
                for (i2 = i + 1; i2 < expr.length() && ((c = expr.charAt(i2)) == '.' || Character.isJavaIdentifierPart(c)); ++i2) {
                }
                quoted.append(expr.substring(i0, i1));
                quoted.append('\'');
                quoted.append(expr.substring(i1, i2));
                quoted.append('\'');
                i0 = i2;
            } while ((i = expr.indexOf(46, i0)) > 0);
            quoted.append(expr.substring(i0));
            return quoted.toString();
        }
        return expr;
    }
}

