/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import com.sun.el.parser.ELParserTokenManager;
import com.sun.el.parser.SimpleCharStream;
import com.sun.el.parser.Token;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.OffsetRange;

public class ELPreprocessor {
    private static final Logger LOG = Logger.getLogger(ELPreprocessor.class.getName());
    public static final String[][] XML_ENTITY_REFS_CONVERSION_TABLE = new String[][]{{"&amp;", "&"}, {"&gt;", ">"}, {"&lt;", "<"}, {"&quot;", "\""}, {"&apos;", "'"}};
    public static final String[][] ESCAPED_CHARACTERS = new String[][]{{"\\\\", "\\"}, {"\\<", "<"}, {"\\>", ">"}, {"\\\"", "\""}, {"\\'", "'"}, {"\\&", "&"}};
    private final String originalExpression;
    private final String[][][] conversionTables;
    private String preprocessedExpression;
    private final boolean[] diffs;
    private List<OffsetRange> stringLiterals = new LinkedList<OffsetRange>();

    public ELPreprocessor(String expression, String[][] ... conversionTables) {
        this.originalExpression = expression;
        this.conversionTables = conversionTables;
        this.diffs = new boolean[this.originalExpression.length()];
        this.init();
    }

    public String getOriginalExpression() {
        return this.originalExpression;
    }

    public String getPreprocessedExpression() {
        return this.preprocessedExpression;
    }

    public int getOriginalOffset(int preprocessedELoffset) {
        int diff = 0;
        for (int i = 0; i < this.originalExpression.length(); ++i) {
            int pointer = i + diff;
            if (pointer == preprocessedELoffset) {
                return i;
            }
            diff += this.diffs[i] ? -1 : 0;
        }
        assert (preprocessedELoffset == this.preprocessedExpression.length());
        return this.originalExpression.length();
    }

    public int getPreprocessedOffset(int originalOffset) {
        int diff = 0;
        for (int i = 0; i < originalOffset; ++i) {
            diff += this.diffs[i] ? -1 : 0;
        }
        return originalOffset + diff;
    }

    private void init() {
        long start = System.nanoTime();
        boolean[] localDiffs = new boolean[this.diffs.length];
        String result = this.originalExpression;
        this.preprocessStringLiterals();
        LOG.log(Level.FINEST, "StringLiteral preprocessing took: {0} ns", System.nanoTime() - start);
        String[][][] stringArray = this.conversionTables;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[][] table;
            for (String[] patternPair : table = stringArray[i]) {
                int match;
                System.arraycopy(this.diffs, 0, localDiffs, 0, this.diffs.length);
                StringBuilder resolved = new StringBuilder();
                String source = patternPair[0];
                String dest = patternPair[1];
                assert (source.length() >= dest.length()) : "no expanding rules supported!";
                int lastMatchEnd = 0;
                while ((match = result.indexOf(source, lastMatchEnd)) != -1) {
                    if (this.isInsideStringLiteral(match)) {
                        resolved.append(result.substring(lastMatchEnd, match));
                        resolved.append(source);
                        lastMatchEnd = match + source.length();
                        continue;
                    }
                    resolved.append(result.substring(lastMatchEnd, match));
                    resolved.append(dest);
                    int originalSourceMatch = this.getOriginalOffset(match);
                    int patternsLenDiff = source.length() - dest.length();
                    for (int i2 = originalSourceMatch; i2 < originalSourceMatch + patternsLenDiff; ++i2) {
                        localDiffs[i2] = true;
                    }
                    lastMatchEnd = match + source.length();
                }
                resolved.append(result.substring(lastMatchEnd));
                result = resolved.toString();
                System.arraycopy(localDiffs, 0, this.diffs, 0, this.diffs.length);
            }
        }
        this.preprocessedExpression = result;
        LOG.log(Level.FINEST, "All preprocessing took: {0} ns", System.nanoTime() - start);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ELPreprocessor.class.getSimpleName());
        sb.append('(');
        sb.append(System.identityHashCode(this));
        sb.append(')');
        sb.append('\n');
        for (String[][] table : this.conversionTables) {
            sb.append("table:");
            for (String[] pattern : table) {
                sb.append('(');
                sb.append(pattern[0]);
                sb.append("->");
                sb.append(pattern[1]);
                sb.append(')');
            }
            sb.append(' ');
        }
        sb.append('\n');
        sb.append("source:");
        sb.append(this.getOriginalExpression());
        sb.append("\n");
        sb.append("diffs :");
        for (int i = 0; i < this.diffs.length; ++i) {
            sb.append(this.diffs[i] ? "-" : "0");
        }
        sb.append("\n");
        sb.append("result:");
        sb.append(this.getPreprocessedExpression());
        sb.append("\n");
        return sb.toString();
    }

    private void preprocessStringLiterals() {
        if (!this.originalExpression.contains("'") && !this.originalExpression.contains("\"")) {
            return;
        }
        SimpleCharStream simpleCharStream = new SimpleCharStream((Reader)new StringReader(this.originalExpression));
        ELParserTokenManager tokenManager = new ELParserTokenManager(simpleCharStream);
        while (true) {
            Token t = tokenManager.getNextToken();
            if (t.kind == 0) break;
            if (t.kind != 14) continue;
            this.stringLiterals.add(new OffsetRange(t.beginColumn, t.beginColumn + t.image.length() - 1));
        }
    }

    private boolean isInsideStringLiteral(int offset) {
        for (OffsetRange offsetRange : this.stringLiterals) {
            if (offsetRange.getStart() > offset || offsetRange.getEnd() <= offset) continue;
            return true;
        }
        return false;
    }
}

