/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import com.sun.el.parser.Node;
import com.sun.el.parser.NodeVisitor;
import javax.el.ELException;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.el.ELPreprocessor;

public final class ELElement {
    private final Node node;
    private final OffsetRange embeddedOffset;
    private final ELException error;
    private final ELPreprocessor expression;
    private final Snapshot snapshot;
    private final OffsetRange originalOffset;

    private ELElement(Node node, ELException error, ELPreprocessor expression, OffsetRange embeddedOffset, Snapshot snapshot) {
        assert (node == null || error == null);
        this.node = node;
        this.embeddedOffset = embeddedOffset;
        this.snapshot = snapshot;
        this.error = error;
        this.expression = expression;
        int origStart = snapshot.getOriginalOffset(embeddedOffset.getStart());
        int origEnd = snapshot.getOriginalOffset(embeddedOffset.getEnd());
        this.originalOffset = new OffsetRange(origStart, origEnd);
    }

    static ELElement valid(Node node, ELPreprocessor expression, OffsetRange embeddedOffset, Snapshot snapshot) {
        return new ELElement(node, null, expression, embeddedOffset, snapshot);
    }

    static ELElement error(ELException error, ELPreprocessor expression, OffsetRange embeddedOffset, Snapshot snapshot) {
        return new ELElement(null, error, expression, embeddedOffset, snapshot);
    }

    public ELElement makeValidCopy(Node node, ELPreprocessor expression) {
        assert (!this.isValid());
        return ELElement.valid(node, expression, this.embeddedOffset, this.snapshot);
    }

    public Node getNode() {
        return this.node;
    }

    public OffsetRange getEmbeddedOffset() {
        return this.embeddedOffset;
    }

    public OffsetRange getOriginalOffset() {
        return this.originalOffset;
    }

    public OffsetRange getOriginalOffset(Node node) {
        int start = this.originalOffset.getStart() + this.expression.getOriginalOffset(node.startOffset());
        int end = this.originalOffset.getStart() + this.expression.getOriginalOffset(node.endOffset());
        return new OffsetRange(start, end);
    }

    public boolean isValid() {
        return this.error == null;
    }

    public ELException getError() {
        return this.error;
    }

    public ELPreprocessor getExpression() {
        return this.expression;
    }

    public Node findNodeAt(final int offset) {
        assert (this.getOriginalOffset().containsInclusive(offset));
        if (this.getNode() == null) {
            return null;
        }
        final Node[] result = new Node[1];
        this.getNode().accept(new NodeVisitor(){

            public void visit(Node node) throws ELException {
                int nodeFrom = ELElement.this.expression.getOriginalOffset(node.startOffset());
                int nodeTo = ELElement.this.expression.getOriginalOffset(node.endOffset());
                if (ELElement.this.originalOffset.getStart() + nodeFrom <= offset && ELElement.this.originalOffset.getStart() + nodeTo > offset) {
                    result[0] = node;
                }
            }
        });
        return result[0];
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public String toString() {
        return "ELElement{expression=" + this.expression + " node=" + this.node + " offset=" + this.embeddedOffset + " error=" + this.error + '}';
    }
}

