/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger.models;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Action;
import org.netbeans.modules.cpplite.debugger.CPPFrame;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebugger;
import org.netbeans.modules.cpplite.debugger.CPPThread;
import org.netbeans.modules.cpplite.debugger.Utils;
import org.netbeans.modules.cpplite.debugger.models.Bundle;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public class CallStackModel
implements TreeModel,
NodeModel,
NodeActionsProvider,
TableModel,
CPPLiteDebugger.StateListener {
    private static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    private static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private static final Object[] NO_STACK = new Object[]{Bundle.CTL_CallStackModel_noStack()};
    private final CPPLiteDebugger debugger;
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public CallStackModel(ContextProvider contextProvider) {
        this.debugger = (CPPLiteDebugger)contextProvider.lookupFirst(null, CPPLiteDebugger.class);
        this.debugger.addStateListener((CPPLiteDebugger.StateListener)WeakListeners.create(CPPLiteDebugger.StateListener.class, (EventListener)this, (Object)this.debugger));
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            CPPThread currentThread = this.debugger.getCurrentThread();
            if (currentThread == null) {
                return NO_STACK;
            }
            return currentThread.getStack();
        }
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof CPPFrame) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            CPPThread currentThread = this.debugger.getCurrentThread();
            if (currentThread == null) {
                return 0;
            }
            CPPFrame[] stack = currentThread.getStack();
            if (stack == null) {
                return 1;
            }
            return stack.length;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof CPPFrame) {
            CPPFrame frame = (CPPFrame)node;
            return frame.getName();
        }
        if (node == "Root") {
            return "Root";
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof CPPFrame) {
            CPPFrame frame = (CPPFrame)node;
            return frame == this.debugger.getCurrentFrame() ? CURRENT_CALL_STACK : CALL_STACK;
        }
        if (node == "Root") {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof CPPFrame) {
            CPPFrame frame = (CPPFrame)node;
            return frame.getDescription();
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node instanceof CPPFrame) {
            Line line = ((CPPFrame)node).location();
            if (line != null) {
                Utils.showLine(new Line[]{line});
            }
            ((CPPFrame)node).makeCurrent();
            return;
        }
        throw new UnknownTypeException(node);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        return new Action[0];
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (columnID == "CallStackFrameLocation" && node instanceof CPPFrame) {
            String sourceName;
            CPPFrame frame = (CPPFrame)node;
            URI sourceURI = frame.getSourceURI();
            if (sourceURI == null) {
                return "";
            }
            try {
                FileObject file = URLMapper.findFileObject((URL)sourceURI.toURL());
                sourceName = file.getPath();
            }
            catch (MalformedURLException ex) {
                sourceName = sourceURI.toString();
            }
            int line = frame.getLine();
            if (line > 0) {
                return sourceName + ':' + line;
            }
            return sourceName + ":?";
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (columnID == "CallStackFrameLocation" && node instanceof CPPFrame) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    private void fireChanges() {
        ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)this);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)event);
        }
    }

    @Override
    public void suspended(boolean suspended) {
        this.fireChanges();
    }

    @Override
    public void finished() {
    }

    @Override
    public void currentThread(CPPThread thread) {
        this.fireChanges();
    }

    @Override
    public void currentFrame(CPPFrame frame) {
        this.fireChanges();
    }
}

