/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration;
import com.amazonaws.services.elasticbeanstalk.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateConfigurationTemplateRequestMarshaller
implements Marshaller<Request<CreateConfigurationTemplateRequest>, CreateConfigurationTemplateRequest> {
    public Request<CreateConfigurationTemplateRequest> marshall(CreateConfigurationTemplateRequest createConfigurationTemplateRequest) {
        SourceConfiguration sourceConfiguration;
        if (createConfigurationTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createConfigurationTemplateRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreateConfigurationTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createConfigurationTemplateRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)createConfigurationTemplateRequest.getApplicationName()));
        }
        if (createConfigurationTemplateRequest.getTemplateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)createConfigurationTemplateRequest.getTemplateName()));
        }
        if (createConfigurationTemplateRequest.getSolutionStackName() != null) {
            request.addParameter("SolutionStackName", StringUtils.fromString((String)createConfigurationTemplateRequest.getSolutionStackName()));
        }
        if (createConfigurationTemplateRequest.getPlatformArn() != null) {
            request.addParameter("PlatformArn", StringUtils.fromString((String)createConfigurationTemplateRequest.getPlatformArn()));
        }
        if ((sourceConfiguration = createConfigurationTemplateRequest.getSourceConfiguration()) != null) {
            if (sourceConfiguration.getApplicationName() != null) {
                request.addParameter("SourceConfiguration.ApplicationName", StringUtils.fromString((String)sourceConfiguration.getApplicationName()));
            }
            if (sourceConfiguration.getTemplateName() != null) {
                request.addParameter("SourceConfiguration.TemplateName", StringUtils.fromString((String)sourceConfiguration.getTemplateName()));
            }
        }
        if (createConfigurationTemplateRequest.getEnvironmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)createConfigurationTemplateRequest.getEnvironmentId()));
        }
        if (createConfigurationTemplateRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createConfigurationTemplateRequest.getDescription()));
        }
        if (!createConfigurationTemplateRequest.getOptionSettings().isEmpty() || !((SdkInternalList)createConfigurationTemplateRequest.getOptionSettings()).isAutoConstruct()) {
            SdkInternalList optionSettingsList = (SdkInternalList)createConfigurationTemplateRequest.getOptionSettings();
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue.getResourceName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringUtils.fromString((String)optionSettingsListValue.getResourceName()));
                }
                if (optionSettingsListValue.getNamespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString((String)optionSettingsListValue.getNamespace()));
                }
                if (optionSettingsListValue.getOptionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString((String)optionSettingsListValue.getOptionName()));
                }
                if (optionSettingsListValue.getValue() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString((String)optionSettingsListValue.getValue()));
                }
                ++optionSettingsListIndex;
            }
        }
        if (!createConfigurationTemplateRequest.getTags().isEmpty() || !((SdkInternalList)createConfigurationTemplateRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createConfigurationTemplateRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

