/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.model.api;

import com.oracle.js.parser.ir.Node;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.doc.api.JsDocumentationSupport;
import org.netbeans.modules.javascript2.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.AnonymousObject;
import org.netbeans.modules.javascript2.model.JsFunctionImpl;
import org.netbeans.modules.javascript2.model.JsFunctionReference;
import org.netbeans.modules.javascript2.model.JsObjectImpl;
import org.netbeans.modules.javascript2.model.JsObjectReference;
import org.netbeans.modules.javascript2.model.JsWithObjectImpl;
import org.netbeans.modules.javascript2.model.ModelAccessor;
import org.netbeans.modules.javascript2.model.ModelElementFactoryAccessor;
import org.netbeans.modules.javascript2.model.ModelExtender;
import org.netbeans.modules.javascript2.model.ModelResolver;
import org.netbeans.modules.javascript2.model.OccurrenceBuilder;
import org.netbeans.modules.javascript2.model.ParameterObject;
import org.netbeans.modules.javascript2.model.api.Bundle;
import org.netbeans.modules.javascript2.model.api.Index;
import org.netbeans.modules.javascript2.model.api.IndexedElement;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.JsWith;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.model.api.Occurrence;
import org.netbeans.modules.javascript2.model.spi.ModelContainer;
import org.netbeans.modules.javascript2.model.spi.ModelElementFactory;
import org.netbeans.modules.javascript2.model.spi.ObjectInterceptor;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.netbeans.modules.javascript2.types.api.Identifier;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.netbeans.modules.parsing.api.Snapshot;

public final class Model {
    private static final AtomicBoolean assertFired = new AtomicBoolean(false);
    private static final Logger LOGGER = Logger.getLogger(Model.class.getName());
    private static final Comparator<Map.Entry<String, ? extends JsObject>> PROPERTIES_COMPARATOR = (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey());
    private static final Comparator<TypeUsage> RETURN_TYPES_COMPARATOR = (o1, o2) -> o1.getType().compareTo(o2.getType());
    private static final Pattern OBJECT_PATTERN = Pattern.compile("(FUNCTION|OBJECT) (\\S+) \\[ANONYMOUS: (true|false), DECLARED: (true|false)( - (\\S+))?(, MODIFIERS: ((PUBLIC|STATIC|PROTECTED|PRIVATE|DEPRECATED|ABSTRACT)(, (PUBLIC|STATIC|PROTECTED|PRIVATE|DEPRECATED|ABSTRACT))*))?, (FUNCTION|METHOD|CONSTRUCTOR|OBJECT|PROPERTY|VARIABLE|FIELD|FILE|PARAMETER|ANONYMOUS_OBJECT|PROPERTY_GETTER|PROPERTY_SETTER|OBJECT_LITERAL|CATCH_BLOCK)\\]");
    private static final Pattern RETURN_TYPE_PATTERN = Pattern.compile("(\\S+), RESOLVED: (true|false)");
    private final org.netbeans.modules.javascript2.types.spi.ParserResult parserResult;
    private final OccurrenceBuilder occurrenceBuilder;
    private final Map<String, Map<Integer, List<TypeUsage>>> returnTypesFromFrameworks;
    private ModelResolver visitor;
    private boolean resolveWithObjects;

    private Model(org.netbeans.modules.javascript2.types.spi.ParserResult parserResult) {
        this.parserResult = parserResult;
        this.occurrenceBuilder = new OccurrenceBuilder(parserResult);
        this.resolveWithObjects = false;
        this.returnTypesFromFrameworks = new HashMap<String, Map<Integer, List<TypeUsage>>>();
    }

    public static Model getModel(ParserResult parserResult, boolean reload) {
        if (parserResult instanceof org.netbeans.modules.javascript2.types.spi.ParserResult) {
            org.netbeans.modules.javascript2.types.spi.ParserResult r = (org.netbeans.modules.javascript2.types.spi.ParserResult)parserResult;
            ModelContainer c = (ModelContainer)r.getLookup().lookup(ModelContainer.class);
            if (c != null) {
                return c.getModel(r, reload);
            }
            return new Model(r);
        }
        return null;
    }

    private synchronized ModelResolver getModelVisitor() {
        boolean resolveWindowProperties = false;
        if (this.visitor == null) {
            long start = System.currentTimeMillis();
            this.visitor = ModelResolver.create(this.parserResult, this.occurrenceBuilder);
            if (this.visitor == null) {
                throw new IllegalStateException("No ModelResolver for result: " + this.parserResult);
            }
            this.visitor.init();
            long startResolve = System.currentTimeMillis();
            this.occurrenceBuilder.processOccurrences(this.visitor.getGlobalObject());
            this.resolveLocalTypes(this.visitor.getGlobalObject(), JsDocumentationSupport.getDocumentationHolder((org.netbeans.modules.javascript2.types.spi.ParserResult)this.parserResult));
            ModelElementFactory elementFactory = ModelElementFactoryAccessor.getDefault().createModelElementFactory();
            long startCallingME = System.currentTimeMillis();
            this.visitor.processCalls(elementFactory, this.returnTypesFromFrameworks);
            for (ObjectInterceptor objectInterceptor : ModelExtender.getDefault().getObjectInterceptors()) {
                objectInterceptor.interceptGlobal(this.visitor.getGlobalObject(), elementFactory);
            }
            resolveWindowProperties = !this.resolveWithObjects;
            long end = System.currentTimeMillis();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(MessageFormat.format("Building model took {0}ms. Resolving types took {1}ms. Extending model took {2}", end - start, startCallingME - startResolve, end - startCallingME));
            }
        } else if (this.resolveWithObjects) {
            this.resolveWithObjects = false;
            resolveWindowProperties = true;
            Index jsIndex = Index.get(this.parserResult.getSnapshot().getSource().getFileObject());
            this.processWithObjectIn(this.visitor.getGlobalObject(), jsIndex);
        }
        if (resolveWindowProperties) {
            this.processWindowsProperties(this.visitor.getGlobalObject());
        }
        return this.visitor;
    }

    private void processWithObjectIn(JsObject where, Index jsIndex) {
        if (where.getProperties().isEmpty()) {
            return;
        }
        ArrayList<? extends JsObject> properties = new ArrayList<JsObject>(where.getProperties().values());
        for (JsObject jsObject : properties) {
            if (jsObject instanceof JsWith) {
                this.processWithObject((JsWith)jsObject, jsIndex, null);
                continue;
            }
            this.processWithObjectIn(jsObject, jsIndex);
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void processWithObject(JsWith with, Index jsIndex, List<String> outerExpression) {
        Collection<TypeUsage> withTypes = with.getTypes();
        withTypes.clear();
        Collection<Object> resolveTypeFromExpression = new ArrayList<TypeUsage>();
        int offset = ((JsWithObjectImpl)with).getExpressionRange().getEnd();
        List<String> ech = ModelUtils.resolveExpressionChain(this.parserResult.getSnapshot(), offset, false);
        ArrayList<String> originalExp = new ArrayList<String>(ech);
        if (outerExpression == null) {
            outerExpression = ech;
            resolveTypeFromExpression.addAll(ModelUtils.resolveTypeFromExpression(this, jsIndex, ech, offset, true));
            resolveTypeFromExpression = ModelUtils.resolveTypes(resolveTypeFromExpression, this, jsIndex, true);
            withTypes.addAll(resolveTypeFromExpression);
        } else {
            JsObject fromType;
            ech.addAll(outerExpression);
            boolean resolved = false;
            resolveTypeFromExpression.addAll(ModelUtils.resolveTypeFromExpression(this, jsIndex, ech, offset, true));
            resolveTypeFromExpression = ModelUtils.resolveTypes(resolveTypeFromExpression, this, jsIndex, true);
            for (TypeUsage type : resolveTypeFromExpression) {
                fromType = ModelUtils.findJsObjectByName(this.visitor.getGlobalObject(), type.getType());
                if (fromType == null) continue;
                resolved = true;
                outerExpression = ech;
                withTypes.add(type);
                break;
            }
            if (!resolved) {
                resolveTypeFromExpression.clear();
                resolveTypeFromExpression.addAll(ModelUtils.resolveTypeFromExpression(this, jsIndex, originalExp, offset, true));
                resolveTypeFromExpression = ModelUtils.resolveTypes(resolveTypeFromExpression, this, jsIndex, true);
                for (TypeUsage type : resolveTypeFromExpression) {
                    fromType = ModelUtils.findJsObjectByName(this.visitor.getGlobalObject(), type.getType());
                    if (fromType == null) continue;
                    resolved = true;
                    outerExpression = originalExp;
                    withTypes.add(type);
                    break;
                }
            }
        }
        for (JsWith innerWith : with.getInnerWiths()) {
            this.processWithObject(innerWith, jsIndex, outerExpression);
        }
        for (TypeUsage type : resolveTypeFromExpression) {
            JsObject jsWithProperty;
            JsObject fromType = ModelUtils.findJsObjectByName(this.visitor.getGlobalObject(), type.getType());
            if (fromType != null) {
                this.processWithExpressionOccurrences(fromType, ((JsWithObjectImpl)with).getExpressionRange(), originalExp);
                Collection<TypeUsage> assignments = ModelUtils.resolveTypes(fromType.getAssignments(), this, jsIndex, true);
                for (TypeUsage assignment : assignments) {
                    Collection<IndexedElement> properties = jsIndex.getProperties(assignment.getType());
                    for (IndexedElement indexedElement : properties) {
                        jsWithProperty = with.getProperty(indexedElement.getName());
                        if (jsWithProperty == null) continue;
                        this.moveProperty(fromType, jsWithProperty);
                        if (!jsWithProperty.isDeclared()) continue;
                        ((JsObjectImpl)jsWithProperty).setDeclared(false);
                    }
                }
                for (JsObject fromTypeProperty : fromType.getProperties().values()) {
                    JsObject jsWithProperty2 = with.getProperty(fromTypeProperty.getName());
                    if (jsWithProperty2 == null) continue;
                    this.moveProperty(fromType, jsWithProperty2);
                    if (!jsWithProperty2.isDeclared()) continue;
                    ((JsObjectImpl)jsWithProperty2).setDeclared(false);
                }
                this.resolveLocalTypes(fromType, JsDocumentationSupport.getDocumentationHolder((org.netbeans.modules.javascript2.types.spi.ParserResult)this.parserResult));
                continue;
            }
            Collection<IndexedElement> properties = jsIndex.getProperties(type.getType());
            if (properties.isEmpty()) continue;
            StringBuilder fqn = new StringBuilder();
            for (int i = outerExpression.size() - 1; i > -1; --i) {
                fqn.append(outerExpression.get(--i));
                fqn.append('.');
            }
            if (fqn.length() <= 0) continue;
            DeclarationScope ds = ModelUtils.getDeclarationScope(with);
            JsObject fromExpression = ModelUtils.findJsObjectByName((JsObject)ds, fqn.toString());
            if (fromExpression == null) {
                int position = ((JsWithObjectImpl)with).getExpressionRange().getStart();
                JsObject parent = this.visitor.getGlobalObject();
                StringTokenizer stringTokenizer = new StringTokenizer(type.getType(), ".");
                while (stringTokenizer.hasMoreTokens()) {
                    String name = stringTokenizer.nextToken();
                    JsObject newObject = parent.getProperty(name);
                    if (newObject == null) {
                        newObject = new JsObjectImpl(parent, new Identifier(name, position), new OffsetRange(position, position + name.length()), false, null, null);
                        parent.addProperty(name, newObject);
                    }
                    position = position + name.length() + 1;
                    parent = newObject;
                }
                fromExpression = parent;
            }
            if (fromExpression == null) continue;
            for (IndexedElement indexedElement : properties) {
                jsWithProperty = with.getProperty(indexedElement.getName());
                if (jsWithProperty == null) continue;
                this.moveProperty(fromExpression, jsWithProperty);
            }
            this.processWithExpressionOccurrences(fromExpression, ((JsWithObjectImpl)with).getExpressionRange(), originalExp);
        }
        boolean hasOuter = with.getOuterWith() != null;
        ArrayList<? extends JsObject> withProperties = new ArrayList<JsObject>(with.getProperties().values());
        DeclarationScope withDS = ModelUtils.getDeclarationScope(with);
        for (JsObject jsWithProperty : withProperties) {
            if (jsWithProperty instanceof JsWith) continue;
            String name = jsWithProperty.getName();
            boolean moved = false;
            if (hasOuter) {
                this.moveProperty(with.getOuterWith(), jsWithProperty);
                moved = true;
            } else {
                JsObject variable = ModelUtils.getScopeVariable(withDS, name);
                if (variable != null && variable.getParent() != null) {
                    this.moveProperty(variable.getParent(), jsWithProperty);
                    moved = true;
                }
            }
            if (moved) continue;
            this.moveProperty(this.visitor.getGlobalObject(), jsWithProperty);
        }
    }

    private void processWithExpressionOccurrences(JsObject jsObject, OffsetRange expRange, List<String> expression) {
        TokenSequence ts;
        JsObject parent = jsObject.getParent();
        boolean isThis = false;
        if (expression.size() > 1 && expression.get(expression.size() - 2).equals("this")) {
            parent = ModelUtils.findJsObject(this, expRange.getStart());
            if (parent instanceof JsWith) {
                parent = parent.getParent();
            }
            parent = this.visitor.resolveThis(parent);
            isThis = true;
        }
        if ((ts = LexUtilities.getJsTokenSequence((Snapshot)this.parserResult.getSnapshot(), (int)expRange.getEnd())) == null) {
            return;
        }
        if (isThis) {
            ts.move(expRange.getStart());
        } else {
            ts.move(expRange.getEnd());
        }
        if (isThis && !ts.moveNext()) {
            return;
        }
        if (!isThis && !ts.movePrevious()) {
            return;
        }
        Token token = ts.token();
        if (isThis) {
            for (int i = expression.size() - 4; i > -1; --i) {
                String name = expression.get(i--);
                while (!(Model.isIdentifier(token) && Model.isIdentifier(token) && token.text().toString().equals(name) || ts.offset() >= expRange.getEnd() || !ts.moveNext())) {
                    token = ts.token();
                }
                if (parent == null || !Model.isIdentifier(token) || !token.text().toString().equals(name)) continue;
                JsObject property = parent.getProperty(name);
                if (property != null) {
                    property.addOccurrence(new OffsetRange(ts.offset(), ts.offset() + name.length()));
                }
                parent = property;
            }
        } else {
            for (int i = 0; i < expression.size() - 1; ++i) {
                String name = expression.get(i++);
                while (!(Model.isIdentifier(token) && Model.isIdentifier(token) && token.text().toString().equals(name) || ts.offset() <= expRange.getStart() || !ts.movePrevious())) {
                    token = ts.token();
                }
                if (parent == null || !Model.isIdentifier(token) || !token.text().toString().equals(name)) continue;
                JsObject property = parent.getProperty(name);
                if (property != null) {
                    property.addOccurrence(new OffsetRange(ts.offset(), ts.offset() + name.length()));
                }
                parent = parent.getParent();
            }
        }
    }

    private void moveProperty(JsObject newParent, JsObject property) {
        Object newProperty = newParent.getProperty(property.getName());
        if (property.getParent() != null) {
            property.getParent().getProperties().remove(property.getName());
        }
        if (newProperty == null) {
            ((JsObjectImpl)property).setParent(newParent);
            newParent.addProperty(property.getName(), (JsObject)property);
        } else {
            if (property.isDeclared() && !newProperty.isDeclared()) {
                Object tmpProperty = newProperty;
                newParent.addProperty(property.getName(), (JsObject)property);
                ((JsObjectImpl)property).setParent(newParent);
                newProperty = property;
                property = tmpProperty;
            }
            JsObjectImpl.moveOccurrenceOfProperties((JsObjectImpl)newProperty, (JsObject)property);
            for (Occurrence occurrence : property.getOccurrences()) {
                newProperty.addOccurrence(occurrence.getOffsetRange());
            }
            ArrayList<? extends JsObject> propertiesToMove = new ArrayList<JsObject>(property.getProperties().values());
            for (JsObject jsObject : propertiesToMove) {
                this.moveProperty((JsObject)newProperty, jsObject);
            }
            this.resolveLocalTypes((JsObject)newProperty, JsDocumentationSupport.getDocumentationHolder((org.netbeans.modules.javascript2.types.spi.ParserResult)this.parserResult));
        }
    }

    private void processWindowsProperties(JsObject globalObject) {
        JsObject window = globalObject.getProperty("window");
        if (window != null) {
            for (JsObject jsObject : window.getProperties().values()) {
                JsObject globalVar = globalObject.getProperty(jsObject.getName());
                if (globalVar == null) continue;
                JsObjectImpl.moveOccurrence((JsObjectImpl)globalVar, jsObject);
                JsObjectImpl.moveOccurrenceOfProperties((JsObjectImpl)jsObject, globalVar);
            }
        }
    }

    public JsObject getGlobalObject() {
        return this.getModelVisitor().getGlobalObject();
    }

    public Collection<TypeUsage> getReturnTypesFromFrameworks(String name, int offsetCall) {
        Map<Integer, List<TypeUsage>> returnTypes = this.returnTypesFromFrameworks.get(name);
        return returnTypes != null ? (Collection)returnTypes.get(offsetCall) : null;
    }

    public synchronized void resolve() {
        if (this.visitor == null) {
            this.getModelVisitor();
        }
        if (this.resolveWithObjects) {
            this.getModelVisitor();
        }
    }

    public Collection<? extends JsObject> getVariables(int offset) {
        ArrayList<JsObject> result = new ArrayList<JsObject>();
        for (DeclarationScope scope = ModelUtils.getDeclarationScope(this, offset); scope != null; scope = scope.getParentScope()) {
            for (JsObject jsObject : ((JsObject)scope).getProperties().values()) {
                if (jsObject.isAnonymous()) continue;
                result.add(jsObject);
            }
            if (!(scope instanceof JsFunction)) continue;
            for (JsObject jsObject : ((JsFunction)scope).getParameters()) {
                result.add(jsObject);
            }
        }
        return result;
    }

    public JsObject findVariable(String name, int offset) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Collection<? extends JsObject> variables = this.getVariables(offset);
        for (JsObject jsObject : variables) {
            if (!name.equals(jsObject.getName())) continue;
            return jsObject;
        }
        return null;
    }

    public JsObject getDeclarationObject(int offset) {
        DeclarationScope scope = ModelUtils.getDeclarationScope(this, offset);
        return (JsObject)scope;
    }

    private void resolveLocalTypes(JsObject object, JsDocumentationHolder docHolder) {
        HashSet<String> alreadyResolved = new HashSet<String>();
        this.resolveLocalTypes(object, docHolder, alreadyResolved);
    }

    private void resolveLocalTypes(JsObject object, JsDocumentationHolder docHolder, Set<String> alreadyResolvedObjects) {
        boolean isTopObject;
        if (object instanceof JsFunctionReference && !object.isAnonymous()) {
            return;
        }
        if (object instanceof JsObjectReference && object.getJSKind() == JsElement.Kind.CLASS) {
            return;
        }
        String fqn = object.getFullyQualifiedName();
        boolean bl = isTopObject = object.getJSKind() == JsElement.Kind.FILE;
        if (alreadyResolvedObjects.contains(fqn)) {
            if (!assertFired.get()) {
                assertFired.set(true);
                assert (false) : "Probably cycle in the javascript model of file: " + object.getFileObject().getPath();
            }
            System.out.println("alreadyResolved: " + fqn);
            return;
        }
        if (!isTopObject) {
            alreadyResolvedObjects.add(fqn);
        }
        if (object instanceof JsFunctionImpl) {
            ((JsFunctionImpl)object).resolveTypes(docHolder);
        } else {
            ((JsObjectImpl)object).resolveTypes(docHolder);
            if (object instanceof JsWith) {
                this.resolveWithObjects = true;
            }
        }
        ArrayList<? extends JsObject> copy = new ArrayList<JsObject>(object.getProperties().values());
        ArrayList<String> namesBefore = new ArrayList<String>(object.getProperties().keySet());
        Collections.reverse(copy);
        for (JsObject jsObject : copy) {
            this.resolveLocalTypes(jsObject, docHolder, alreadyResolvedObjects);
        }
        ArrayList<String> namesAfter = new ArrayList<String>(object.getProperties().keySet());
        for (String propertyName : namesAfter) {
            if (namesBefore.contains(propertyName)) continue;
            this.resolveLocalTypes(object.getProperty(propertyName), docHolder, alreadyResolvedObjects);
        }
        if (!isTopObject) {
            alreadyResolvedObjects.remove(fqn);
        }
    }

    public List<Identifier> getNodeName(Node node) {
        ModelResolver resolver = ModelResolver.create(this.parserResult, this.occurrenceBuilder);
        if (resolver == null) {
            throw new IllegalStateException("No ModelResolver for result: " + this.parserResult);
        }
        return resolver.getASTNodeName(node);
    }

    public void writeModel(Printer printer) {
        Model.writeObject(printer, this.getGlobalObject(), null);
    }

    public void writeModel(Printer printer, boolean resolve) {
        Model.writeObject(printer, this.getGlobalObject(), resolve ? this.parserResult : null);
    }

    public void writeObject(Printer printer, JsObject object, boolean resolve) {
        Model.writeObject(printer, object, resolve ? this.parserResult : null);
    }

    public static void writeObject(Printer printer, JsObject object, @NullAllowed org.netbeans.modules.javascript2.types.spi.ParserResult parseResult) {
        StringBuilder sb = new StringBuilder();
        Model.writeObject(printer, object, parseResult, sb, "", new HashSet<JsObject>());
        String rest = sb.toString();
        if (!rest.isEmpty()) {
            printer.println(rest);
        }
    }

    public static Collection<JsObject> readModel(BufferedReader reader, JsObject parent, @NullAllowed String sourceLabel, URL defaultDocUrl) throws IOException {
        String line = null;
        StringBuilder pushback = new StringBuilder();
        ArrayList<JsObject> ret = new ArrayList<JsObject>();
        while (pushback.length() > 0 || (line = reader.readLine()) != null) {
            if (pushback.length() > 0) {
                line = pushback.toString();
                pushback.setLength(0);
            }
            if (line.trim().isEmpty()) continue;
            ret.add(Model.readObject(parent, line, 0, reader, pushback, false, sourceLabel, defaultDocUrl == null ? null : Documentation.create((String)Bundle.LBL_DefaultDocContentForURL(), (URL)defaultDocUrl)));
        }
        return ret;
    }

    private static JsObject readObject(JsObject parent, String firstLine, int indent, BufferedReader reader, StringBuilder pushback, boolean parameter, String sourceLabel, Documentation defaultDoc) throws IOException {
        JsObject object = Model.readObject(parent, firstLine, parameter, sourceLabel);
        ParsingState state = null;
        String line = null;
        StringBuilder innerPushback = new StringBuilder();
        block6: while (innerPushback.length() > 0 || (line = reader.readLine()) != null) {
            if (innerPushback.length() > 0) {
                line = innerPushback.toString();
                innerPushback.setLength(0);
            }
            if (line.length() < indent || !line.substring(0, indent).trim().isEmpty()) {
                pushback.append(line);
                break;
            }
            if ("# DOCUMENTATION URL".equals(line.trim())) {
                state = ParsingState.DOCUMETATION_URL;
                continue;
            }
            if ("# RETURN TYPES".equals(line.trim())) {
                state = ParsingState.RETURN;
                continue;
            }
            if ("# PARAMETERS".equals(line.trim())) {
                state = ParsingState.PARAMETER;
                continue;
            }
            if ("# PROPERTIES".equals(line.trim())) {
                state = ParsingState.PROPERTY;
                continue;
            }
            if ("# SEPARATOR".equals(line.trim())) break;
            if (state == null) {
                pushback.append(line);
                break;
            }
            switch (state) {
                case DOCUMETATION_URL: {
                    ((JsObjectImpl)object).setDocumentation(Documentation.create((String)Bundle.LBL_DefaultDocContentForURL(), (URL)new URL(line.trim())));
                    continue block6;
                }
                case RETURN: {
                    Matcher matcher = RETURN_TYPE_PATTERN.matcher(line.trim());
                    if (!matcher.matches()) {
                        throw new IOException("Unexpected line: " + line);
                    }
                    ((JsFunctionImpl)object).addReturnType(new TypeUsage(matcher.group(1), -1, Boolean.parseBoolean(matcher.group(2))));
                    continue block6;
                }
                case PARAMETER: {
                    JsObject parameterObject = Model.readObject(object, line.trim(), indent + 8, reader, innerPushback, true, sourceLabel, null);
                    ((JsFunctionImpl)object).addParameter(parameterObject);
                    continue block6;
                }
                case PROPERTY: {
                    int index = line.indexOf(58);
                    assert (index > 0 && index < line.length()) : line;
                    String name = line.substring(0, index);
                    String value = line.substring(index + 1);
                    int newIndent = name.length();
                    name = name.trim();
                    JsObject property = Model.readObject(object, value.trim(), newIndent, reader, innerPushback, false, sourceLabel, defaultDoc);
                    object.addProperty(name, property);
                    continue block6;
                }
            }
            throw new IOException("Unexpected line: " + line);
        }
        if (defaultDoc != null && object.getDocumentation() == null) {
            ((JsObjectImpl)object).setDocumentation(defaultDoc);
        }
        return object;
    }

    private static JsObject readObject(JsObject parent, String line, boolean parameter, String sourceLabel) throws IOException {
        JsObjectImpl ret;
        Matcher m = OBJECT_PATTERN.matcher(line);
        if (!m.matches()) {
            throw new IOException("Malformed line: " + line);
        }
        boolean function = "FUNCTION".equals(m.group(1));
        String name = m.group(2);
        boolean anonymous = Boolean.valueOf(m.group(3));
        boolean declared = Boolean.valueOf(m.group(4));
        String strModifiers = m.group(8);
        JsElement.Kind kind = JsElement.Kind.valueOf(m.group(12));
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        if (modifiers != null) {
            String[] parts = strModifiers.split(", ");
            for (String part : parts) {
                modifiers.add(Modifier.valueOf((String)part));
            }
        }
        if (parameter) {
            ret = new ParameterObject(parent, new Identifier(name, OffsetRange.NONE), null, sourceLabel);
        } else if (function) {
            JsFunctionImpl functionImpl = new JsFunctionImpl(null, parent, new Identifier(name, OffsetRange.NONE), Collections.emptyList(), OffsetRange.NONE, null, sourceLabel);
            functionImpl.setAnonymous(anonymous);
            ret = functionImpl;
        } else {
            ret = anonymous ? new AnonymousObject(parent, name, OffsetRange.NONE, null, sourceLabel) : new JsObjectImpl(parent, new Identifier(name, OffsetRange.NONE), OffsetRange.NONE, null, sourceLabel);
        }
        ret.setJsKind(kind);
        ret.setDeclared(declared);
        ret.getModifiers().clear();
        for (Modifier modifier : modifiers) {
            ret.addModifier(modifier);
        }
        ret.getProperties().clear();
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private static void writeObject(Printer printer, JsObject jsObject, org.netbeans.modules.javascript2.types.spi.ParserResult parseResult, StringBuilder sb, String ident, Set<JsObject> path) {
        void var8_15;
        if (jsObject instanceof JsFunction) {
            sb.append("FUNCTION ");
        } else {
            sb.append("OBJECT ");
        }
        sb.append(jsObject.getName());
        sb.append(" [");
        sb.append("ANONYMOUS: ");
        sb.append(jsObject.isAnonymous());
        sb.append(", DECLARED: ");
        sb.append(jsObject.isDeclared());
        if (jsObject.getDeclarationName() != null) {
            sb.append(" - ").append(jsObject.getDeclarationName().getName());
        }
        if (!jsObject.getModifiers().isEmpty()) {
            sb.append(", MODIFIERS: ");
            for (Modifier m : jsObject.getModifiers()) {
                sb.append(m.toString());
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        sb.append(", ");
        sb.append((Object)jsObject.getJSKind());
        sb.append("]");
        path.add(jsObject);
        if (jsObject instanceof JsFunction) {
            JsFunction function = (JsFunction)jsObject;
            if (!function.getReturnTypes().isEmpty()) {
                Model.newLine(printer, sb, ident);
                sb.append("# RETURN TYPES");
                Object ret = function.getReturnTypes();
                if (parseResult != null) {
                    ret = ModelUtils.resolveTypes(ret, Model.getModel((ParserResult)parseResult, false), Index.get(parseResult.getSnapshot().getSource().getFileObject()), true);
                }
                ArrayList<? extends JsObject> arrayList = new ArrayList<JsObject>((Collection<? extends JsObject>)ret);
                arrayList.sort(RETURN_TYPES_COMPARATOR);
                for (TypeUsage typeUsage : arrayList) {
                    Model.newLine(printer, sb, ident);
                    sb.append(typeUsage.getType());
                    sb.append(", RESOLVED: ");
                    sb.append(typeUsage.isResolved());
                }
            }
            if (!function.getParameters().isEmpty()) {
                Model.newLine(printer, sb, ident);
                sb.append("# PARAMETERS");
                for (JsObject jsObject2 : function.getParameters()) {
                    Model.newLine(printer, sb, ident);
                    if (path.contains(jsObject2)) {
                        sb.append("CYCLE ").append(jsObject2.getFullyQualifiedName());
                        continue;
                    }
                    Model.writeObject(printer, jsObject2, parseResult, sb, ident + "        ", path);
                }
            }
        }
        int length = 0;
        for (String string : jsObject.getProperties().keySet()) {
            if (string.length() <= length) continue;
            length = string.length();
        }
        StringBuilder identBuilder = new StringBuilder(ident);
        identBuilder.append(' ');
        boolean bl = false;
        while (var8_15 < length) {
            identBuilder.append(' ');
            ++var8_15;
        }
        ArrayList<Map.Entry<String, ? extends JsObject>> arrayList = new ArrayList<Map.Entry<String, ? extends JsObject>>(jsObject.getProperties().entrySet());
        if (!arrayList.isEmpty()) {
            Model.newLine(printer, sb, ident);
            sb.append("# PROPERTIES");
            arrayList.sort(PROPERTIES_COMPARATOR);
            for (Map.Entry entry : arrayList) {
                Model.newLine(printer, sb, ident);
                sb.append((String)entry.getKey());
                for (int i = ((String)entry.getKey()).length(); i < length; ++i) {
                    sb.append(' ');
                }
                sb.append(" : ");
                if (path.contains(entry.getValue())) {
                    sb.append("CYCLE ").append(((JsObject)entry.getValue()).getFullyQualifiedName());
                    continue;
                }
                Model.writeObject(printer, (JsObject)entry.getValue(), parseResult, sb, identBuilder.toString(), path);
            }
        }
        path.remove(jsObject);
    }

    private static void newLine(Printer printer, StringBuilder sb, String ident) {
        printer.println(sb.toString());
        sb.setLength(0);
        sb.append(ident);
    }

    private static boolean isIdentifier(Token token) {
        return token.id() == JsTokenId.IDENTIFIER || token.id() == JsTokenId.PRIVATE_IDENTIFIER;
    }

    static {
        ModelAccessor.setDefault(new ModelAccessor(){

            @Override
            public Model createModel(org.netbeans.modules.javascript2.types.spi.ParserResult result) {
                return new Model(result);
            }
        });
    }

    public static interface Printer {
        public void println(String var1);
    }

    private static enum ParsingState {
        DOCUMETATION_URL,
        RETURN,
        PARAMETER,
        PROPERTY;

    }
}

