/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets.k8s;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cloud.oracle.NotificationUtils;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.assets.k8s.Bundle;
import org.netbeans.modules.cloud.oracle.assets.k8s.ClusterItem;
import org.netbeans.modules.cloud.oracle.assets.k8s.ConfigMapProvider;
import org.netbeans.modules.cloud.oracle.assets.k8s.CreateSecretRotationCronJobCommand;
import org.netbeans.modules.cloud.oracle.assets.k8s.KubernetesUtils;
import org.netbeans.modules.cloud.oracle.developer.ContainerTagItem;
import org.netbeans.modules.cloud.oracle.steps.ProjectStep;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class RunInClusterAction
implements ActionListener {
    private final ContainerTagItem context;
    private static final String APP = "app";
    private static final RequestProcessor RP = new RequestProcessor(RunInClusterAction.class);

    public RunInClusterAction(ContainerTagItem context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RP.post(() -> this.runInCluster());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInCluster() {
        ProgressHandle h;
        String projectName;
        ClusterItem cluster = CloudAssets.getDefault().getItem(ClusterItem.class);
        try {
            Project project = (Project)((CompletableFuture)Steps.getDefault().executeMultistep(new ProjectStep(), Lookup.EMPTY).thenApply(values -> (Project)values.getValueForStep(ProjectStep.class))).get();
            ProjectInformation pi = ProjectUtils.getInformation((Project)project);
            projectName = pi.getDisplayName();
            h = ProgressHandle.createHandle((String)Bundle.Deploying(projectName, cluster.getName()));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        try {
            h.start();
            CreateSecretRotationCronJobCommand srcc = new CreateSecretRotationCronJobCommand();
            h.progress(Bundle.CreatingSecretRotationCronJob());
            srcc.createSecretRotationCronJob().join();
            KubernetesUtils.runWithClient(cluster, client -> {
                DeploymentList dList = (DeploymentList)((NonNamespaceOperation)client.apps().deployments().inNamespace(cluster.getNamespace())).list();
                Deployment existingDeployment = (Deployment)KubernetesUtils.findResource(client, (KubernetesResourceList<? extends HasMetadata>)dList, projectName);
                ConfigMapProvider configMapProvider = new ConfigMapProvider(projectName, cluster);
                configMapProvider.createConfigMap();
                if (existingDeployment != null) {
                    ((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(cluster.getNamespace())).withName(projectName)).edit(d -> ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)new DeploymentBuilder(d).editSpec().editTemplate().editSpec().editFirstContainer().withImage(this.context.getUrl())).endContainer()).endSpec()).endTemplate()).endSpec()).build());
                    ((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(cluster.getNamespace())).withName(projectName)).edit(d -> ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)new DeploymentBuilder(d).editSpec().editTemplate().editMetadata().addToAnnotations("kubectl.kubernetes.io/restartedAt", Instant.now().toString())).endMetadata()).endTemplate()).endSpec()).build());
                } else {
                    Deployment newDeployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.VolumesNested)((PodSpecFluent.VolumesNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ImagePullSecretsNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(projectName)).addToLabels(APP, projectName)).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(2))).withNewSelector().addToMatchLabels(APP, projectName)).endSelector()).withNewTemplate().withNewMetadata().addToLabels(APP, projectName)).endMetadata()).withNewSpec().addNewImagePullSecret().withName("docker-bearer-vscode-generated-ocirsecret")).endImagePullSecret()).addNewContainer().withName(projectName)).withImage(this.context.getUrl())).addNewPort().withContainerPort(Integer.valueOf(8080))).endPort()).addNewEnv().withName("MICRONAUT_CONFIG_FILES")).withValue(configMapProvider.getMicronautConfigFiles())).endEnv()).addNewEnv().withName("MICRONAUT_ENVIRONMENTS")).withValue("oraclecloud")).endEnv()).addNewVolumeMount().withName("configuration")).withMountPath("/etc/conf")).withReadOnly(Boolean.TRUE)).endVolumeMount()).endContainer()).addNewVolume().withName("configuration")).withConfigMap(configMapProvider.getVolumeSource())).endVolume()).endSpec()).endTemplate()).endSpec()).build();
                    ((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace(cluster.getNamespace())).resource((Object)newDeployment)).create();
                }
            });
        }
        catch (ThreadDeath x) {
            throw x;
        }
        catch (Throwable t) {
            NotificationUtils.showErrorMessage(t.getMessage());
        }
        finally {
            h.finish();
        }
    }
}

