/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EncryptDataDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="associatedData")
    private final Map<String, String> associatedData;
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="loggingContext")
    private final Map<String, String> loggingContext;
    @JsonProperty(value="plaintext")
    private final String plaintext;
    @JsonProperty(value="keyVersionId")
    private final String keyVersionId;
    @JsonProperty(value="encryptionAlgorithm")
    private final EncryptionAlgorithm encryptionAlgorithm;

    @Deprecated
    @ConstructorProperties(value={"associatedData", "keyId", "loggingContext", "plaintext", "keyVersionId", "encryptionAlgorithm"})
    public EncryptDataDetails(Map<String, String> associatedData, String keyId, Map<String, String> loggingContext, String plaintext, String keyVersionId, EncryptionAlgorithm encryptionAlgorithm) {
        this.associatedData = associatedData;
        this.keyId = keyId;
        this.loggingContext = loggingContext;
        this.plaintext = plaintext;
        this.keyVersionId = keyVersionId;
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Map<String, String> getAssociatedData() {
        return this.associatedData;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public Map<String, String> getLoggingContext() {
        return this.loggingContext;
    }

    public String getPlaintext() {
        return this.plaintext;
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EncryptDataDetails(");
        sb.append("super=").append(super.toString());
        sb.append("associatedData=").append(String.valueOf(this.associatedData));
        sb.append(", keyId=").append(String.valueOf(this.keyId));
        sb.append(", loggingContext=").append(String.valueOf(this.loggingContext));
        sb.append(", plaintext=").append(String.valueOf(this.plaintext));
        sb.append(", keyVersionId=").append(String.valueOf(this.keyVersionId));
        sb.append(", encryptionAlgorithm=").append(String.valueOf((Object)this.encryptionAlgorithm));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptDataDetails)) {
            return false;
        }
        EncryptDataDetails other = (EncryptDataDetails)((Object)o);
        return Objects.equals(this.associatedData, other.associatedData) && Objects.equals(this.keyId, other.keyId) && Objects.equals(this.loggingContext, other.loggingContext) && Objects.equals(this.plaintext, other.plaintext) && Objects.equals(this.keyVersionId, other.keyVersionId) && Objects.equals((Object)this.encryptionAlgorithm, (Object)other.encryptionAlgorithm) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.associatedData == null ? 43 : this.associatedData.hashCode());
        result = result * 59 + (this.keyId == null ? 43 : this.keyId.hashCode());
        result = result * 59 + (this.loggingContext == null ? 43 : this.loggingContext.hashCode());
        result = result * 59 + (this.plaintext == null ? 43 : this.plaintext.hashCode());
        result = result * 59 + (this.keyVersionId == null ? 43 : this.keyVersionId.hashCode());
        result = result * 59 + (this.encryptionAlgorithm == null ? 43 : this.encryptionAlgorithm.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum EncryptionAlgorithm implements BmcEnum
    {
        Aes256Gcm("AES_256_GCM"),
        RsaOaepSha1("RSA_OAEP_SHA_1"),
        RsaOaepSha256("RSA_OAEP_SHA_256");

        private final String value;
        private static Map<String, EncryptionAlgorithm> map;

        private EncryptionAlgorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EncryptionAlgorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid EncryptionAlgorithm: " + key);
        }

        static {
            map = new HashMap<String, EncryptionAlgorithm>();
            for (EncryptionAlgorithm v : EncryptionAlgorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="associatedData")
        private Map<String, String> associatedData;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="loggingContext")
        private Map<String, String> loggingContext;
        @JsonProperty(value="plaintext")
        private String plaintext;
        @JsonProperty(value="keyVersionId")
        private String keyVersionId;
        @JsonProperty(value="encryptionAlgorithm")
        private EncryptionAlgorithm encryptionAlgorithm;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder associatedData(Map<String, String> associatedData) {
            this.associatedData = associatedData;
            this.__explicitlySet__.add("associatedData");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder loggingContext(Map<String, String> loggingContext) {
            this.loggingContext = loggingContext;
            this.__explicitlySet__.add("loggingContext");
            return this;
        }

        public Builder plaintext(String plaintext) {
            this.plaintext = plaintext;
            this.__explicitlySet__.add("plaintext");
            return this;
        }

        public Builder keyVersionId(String keyVersionId) {
            this.keyVersionId = keyVersionId;
            this.__explicitlySet__.add("keyVersionId");
            return this;
        }

        public Builder encryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            this.__explicitlySet__.add("encryptionAlgorithm");
            return this;
        }

        public EncryptDataDetails build() {
            EncryptDataDetails model = new EncryptDataDetails(this.associatedData, this.keyId, this.loggingContext, this.plaintext, this.keyVersionId, this.encryptionAlgorithm);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EncryptDataDetails model) {
            if (model.wasPropertyExplicitlySet("associatedData")) {
                this.associatedData(model.getAssociatedData());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("loggingContext")) {
                this.loggingContext(model.getLoggingContext());
            }
            if (model.wasPropertyExplicitlySet("plaintext")) {
                this.plaintext(model.getPlaintext());
            }
            if (model.wasPropertyExplicitlySet("keyVersionId")) {
                this.keyVersionId(model.getKeyVersionId());
            }
            if (model.wasPropertyExplicitlySet("encryptionAlgorithm")) {
                this.encryptionAlgorithm(model.getEncryptionAlgorithm());
            }
            return this;
        }
    }
}

