/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.keymanagement.model.ExternalKeyManagerMetadata;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateVaultDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="externalKeyManagerMetadata")
    private final ExternalKeyManagerMetadata externalKeyManagerMetadata;
    @JsonProperty(value="vaultType")
    private final VaultType vaultType;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "definedTags", "displayName", "freeformTags", "externalKeyManagerMetadata", "vaultType"})
    public CreateVaultDetails(String compartmentId, Map<String, Map<String, Object>> definedTags, String displayName, Map<String, String> freeformTags, ExternalKeyManagerMetadata externalKeyManagerMetadata, VaultType vaultType) {
        this.compartmentId = compartmentId;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.externalKeyManagerMetadata = externalKeyManagerMetadata;
        this.vaultType = vaultType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public ExternalKeyManagerMetadata getExternalKeyManagerMetadata() {
        return this.externalKeyManagerMetadata;
    }

    public VaultType getVaultType() {
        return this.vaultType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateVaultDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", externalKeyManagerMetadata=").append(String.valueOf((Object)this.externalKeyManagerMetadata));
        sb.append(", vaultType=").append(String.valueOf((Object)this.vaultType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateVaultDetails)) {
            return false;
        }
        CreateVaultDetails other = (CreateVaultDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals((Object)this.externalKeyManagerMetadata, (Object)other.externalKeyManagerMetadata) && Objects.equals((Object)this.vaultType, (Object)other.vaultType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.externalKeyManagerMetadata == null ? 43 : this.externalKeyManagerMetadata.hashCode());
        result = result * 59 + (this.vaultType == null ? 43 : this.vaultType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum VaultType implements BmcEnum
    {
        VirtualPrivate("VIRTUAL_PRIVATE"),
        Default("DEFAULT"),
        External("EXTERNAL");

        private final String value;
        private static Map<String, VaultType> map;

        private VaultType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static VaultType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid VaultType: " + key);
        }

        static {
            map = new HashMap<String, VaultType>();
            for (VaultType v : VaultType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="externalKeyManagerMetadata")
        private ExternalKeyManagerMetadata externalKeyManagerMetadata;
        @JsonProperty(value="vaultType")
        private VaultType vaultType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder externalKeyManagerMetadata(ExternalKeyManagerMetadata externalKeyManagerMetadata) {
            this.externalKeyManagerMetadata = externalKeyManagerMetadata;
            this.__explicitlySet__.add("externalKeyManagerMetadata");
            return this;
        }

        public Builder vaultType(VaultType vaultType) {
            this.vaultType = vaultType;
            this.__explicitlySet__.add("vaultType");
            return this;
        }

        public CreateVaultDetails build() {
            CreateVaultDetails model = new CreateVaultDetails(this.compartmentId, this.definedTags, this.displayName, this.freeformTags, this.externalKeyManagerMetadata, this.vaultType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateVaultDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("externalKeyManagerMetadata")) {
                this.externalKeyManagerMetadata(model.getExternalKeyManagerMetadata());
            }
            if (model.wasPropertyExplicitlySet("vaultType")) {
                this.vaultType(model.getVaultType());
            }
            return this;
        }
    }
}

