/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc;

import com.oracle.bmc.util.internal.FileUtils;
import com.oracle.bmc.util.internal.StringUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigFileReader {
    public static final String DEFAULT_FILE_PATH = "~/.oci/config";
    public static final String FALLBACK_DEFAULT_FILE_PATH = "~/.oraclebmc/config";
    private static final String DEFAULT_PROFILE_NAME = "DEFAULT";
    public static final String OCI_CONFIG_FILE_PATH_ENV_VAR_NAME = "OCI_CONFIG_FILE";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFileReader.class);

    public static ConfigFile parseDefault() throws IOException {
        return ConfigFileReader.parseDefault(null);
    }

    public static ConfigFile parseDefault(@Nullable String profile) throws IOException {
        File effectiveFile = null;
        File defaultFile = new File(FileUtils.expandUserHome(DEFAULT_FILE_PATH));
        String fallbackConfigFilePath = System.getenv(OCI_CONFIG_FILE_PATH_ENV_VAR_NAME);
        if (StringUtils.isBlank(fallbackConfigFilePath)) {
            fallbackConfigFilePath = FALLBACK_DEFAULT_FILE_PATH;
        }
        File fallbackDefaultFile = new File(FileUtils.expandUserHome(fallbackConfigFilePath));
        if (defaultFile.exists() && defaultFile.isFile()) {
            effectiveFile = defaultFile;
        } else if (fallbackDefaultFile.exists() && fallbackDefaultFile.isFile()) {
            effectiveFile = fallbackDefaultFile;
        }
        if (effectiveFile != null) {
            LOG.debug("Loading config file from: {}", (Object)effectiveFile);
            return ConfigFileReader.parse(effectiveFile.getAbsolutePath(), profile);
        }
        throw new IOException(String.format("Can't load the default config from '%s' or '%s' because it does not exist or it is not a file.", defaultFile.getAbsolutePath(), fallbackDefaultFile.getAbsolutePath()));
    }

    public static ConfigFile parse(String configurationFilePath) throws IOException {
        return ConfigFileReader.parse(configurationFilePath, null);
    }

    public static ConfigFile parse(String configurationFilePath, @Nullable String profile) throws IOException {
        return ConfigFileReader.parse(new FileInputStream(new File(FileUtils.expandUserHome(configurationFilePath))), profile);
    }

    public static ConfigFile parse(InputStream configurationStream, @Nullable String profile) throws IOException {
        return ConfigFileReader.parse(configurationStream, profile, StandardCharsets.UTF_8);
    }

    public static ConfigFile parse(InputStream configurationStream, @Nullable String profile, @Nonnull Charset charset) throws IOException {
        ConfigAccumulator accumulator = new ConfigAccumulator();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(configurationStream, charset));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                accumulator.accept(line);
            }
        }
        if (!accumulator.foundDefaultProfile) {
            LOG.info("No DEFAULT profile was specified in the configuration");
        }
        if (profile != null && !accumulator.configurationsByProfile.containsKey(profile)) {
            throw new IllegalArgumentException("No profile named " + profile + " exists in the configuration file");
        }
        return new ConfigFile(accumulator, profile);
    }

    private ConfigFileReader() {
    }

    private static final class ConfigAccumulator {
        final Map<String, Map<String, String>> configurationsByProfile = new HashMap<String, Map<String, String>>();
        private String currentProfile = null;
        private boolean foundDefaultProfile = false;

        private ConfigAccumulator() {
        }

        private void accept(String line) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty()) {
                return;
            }
            if (trimmedLine.charAt(0) == '#') {
                return;
            }
            if (trimmedLine.charAt(0) == '[' && trimmedLine.charAt(trimmedLine.length() - 1) == ']') {
                this.currentProfile = trimmedLine.substring(1, trimmedLine.length() - 1).trim();
                if (this.currentProfile.isEmpty()) {
                    throw new IllegalStateException("Cannot have empty profile name: " + line);
                }
                if (this.currentProfile.equals(ConfigFileReader.DEFAULT_PROFILE_NAME)) {
                    this.foundDefaultProfile = true;
                }
                if (!this.configurationsByProfile.containsKey(this.currentProfile)) {
                    this.configurationsByProfile.put(this.currentProfile, new HashMap());
                }
                return;
            }
            int splitIndex = trimmedLine.indexOf(61);
            if (splitIndex == -1) {
                throw new IllegalStateException("Found line with no key-value pair: " + line);
            }
            String key = trimmedLine.substring(0, splitIndex).trim();
            String value = trimmedLine.substring(splitIndex + 1).trim();
            if (key.isEmpty()) {
                throw new IllegalStateException("Found line with no key: " + line);
            }
            if (this.currentProfile == null) {
                throw new IllegalStateException("Config parse error, attempted to read configuration without specifying a profile: " + line);
            }
            this.configurationsByProfile.get(this.currentProfile).put(key, value);
        }
    }

    public static final class ConfigFile {
        private final ConfigAccumulator accumulator;
        private final String profile;

        @ConstructorProperties(value={"accumulator", "profile"})
        private ConfigFile(ConfigAccumulator accumulator, String profile) {
            this.accumulator = accumulator;
            this.profile = profile;
        }

        public String get(String key) {
            if (this.profile != null && this.accumulator.configurationsByProfile.get(this.profile).containsKey(key)) {
                return this.accumulator.configurationsByProfile.get(this.profile).get(key);
            }
            return this.accumulator.foundDefaultProfile ? this.accumulator.configurationsByProfile.get(ConfigFileReader.DEFAULT_PROFILE_NAME).get(key) : null;
        }
    }
}

