/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.monitoring.model.SummarizeMetricsDataDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class SummarizeMetricsDataRequest
extends BmcRequest<SummarizeMetricsDataDetails> {
    private String compartmentId;
    private SummarizeMetricsDataDetails summarizeMetricsDataDetails;
    private String opcRequestId;
    private Boolean compartmentIdInSubtree;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public SummarizeMetricsDataDetails getSummarizeMetricsDataDetails() {
        return this.summarizeMetricsDataDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    @InternalSdk
    public SummarizeMetricsDataDetails getBody$() {
        return this.summarizeMetricsDataDetails;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).summarizeMetricsDataDetails(this.summarizeMetricsDataDetails).opcRequestId(this.opcRequestId).compartmentIdInSubtree(this.compartmentIdInSubtree);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",summarizeMetricsDataDetails=").append(String.valueOf((Object)this.summarizeMetricsDataDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeMetricsDataRequest)) {
            return false;
        }
        SummarizeMetricsDataRequest other = (SummarizeMetricsDataRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.summarizeMetricsDataDetails, (Object)other.summarizeMetricsDataDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.summarizeMetricsDataDetails == null ? 43 : this.summarizeMetricsDataDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeMetricsDataRequest, SummarizeMetricsDataDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private SummarizeMetricsDataDetails summarizeMetricsDataDetails = null;
        private String opcRequestId = null;
        private Boolean compartmentIdInSubtree = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder summarizeMetricsDataDetails(SummarizeMetricsDataDetails summarizeMetricsDataDetails) {
            this.summarizeMetricsDataDetails = summarizeMetricsDataDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeMetricsDataRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.summarizeMetricsDataDetails(o.getSummarizeMetricsDataDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeMetricsDataRequest build() {
            SummarizeMetricsDataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SummarizeMetricsDataDetails body) {
            this.summarizeMetricsDataDetails(body);
            return this;
        }

        public SummarizeMetricsDataRequest buildWithoutInvocationCallback() {
            SummarizeMetricsDataRequest request = new SummarizeMetricsDataRequest();
            request.compartmentId = this.compartmentId;
            request.summarizeMetricsDataDetails = this.summarizeMetricsDataDetails;
            request.opcRequestId = this.opcRequestId;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            return request;
        }
    }
}

