/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.message;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.message.Message;
import org.primefaces.context.RequestContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.UINotificationRenderer;
import org.primefaces.util.WidgetBuilder;

public class MessageRenderer
extends UINotificationRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Message uiMessage = (Message)component;
        UIComponent target = SearchExpressionFacade.resolveComponent(context, (UIComponent)uiMessage, uiMessage.getFor());
        String targetClientId = target.getClientId(context);
        this.encodeMarkup(context, uiMessage, targetClientId);
        this.encodeScript(context, uiMessage, targetClientId);
    }

    protected void encodeMarkup(FacesContext context, Message uiMessage, String targetClientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String display = uiMessage.getDisplay();
        boolean iconOnly = display.equals("icon");
        boolean escape = uiMessage.isEscape();
        String styleClass = display.equals("tooltip") ? "ui-message ui-helper-hidden" : "ui-message";
        Iterator msgs = context.getMessages(targetClientId);
        writer.startElement("div", (UIComponent)uiMessage);
        writer.writeAttribute("id", (Object)uiMessage.getClientId(context), null);
        writer.writeAttribute("aria-live", (Object)"polite", null);
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isClientSideValidationEnabled()) {
            writer.writeAttribute("data-display", (Object)display, null);
            writer.writeAttribute("data-target", (Object)targetClientId, null);
        }
        if (msgs.hasNext()) {
            String severityName;
            FacesMessage msg = (FacesMessage)msgs.next();
            if (!this.shouldRender(uiMessage, msg, severityName = this.getSeverityName(msg))) {
                writer.writeAttribute("class", (Object)styleClass, null);
                writer.endElement("div");
                return;
            }
            FacesMessage.Severity severity = msg.getSeverity();
            String severityKey = null;
            if (severity.equals(FacesMessage.SEVERITY_ERROR)) {
                severityKey = "error";
            } else if (severity.equals(FacesMessage.SEVERITY_INFO)) {
                severityKey = "info";
            } else if (severity.equals(FacesMessage.SEVERITY_WARN)) {
                severityKey = "warn";
            } else if (severity.equals(FacesMessage.SEVERITY_FATAL)) {
                severityKey = "fatal";
            }
            styleClass = styleClass + " ui-message-" + severityKey + " ui-widget ui-corner-all";
            if (iconOnly) {
                styleClass = styleClass + " ui-message-icon-only ui-helper-clearfix";
            }
            writer.writeAttribute("class", (Object)styleClass, null);
            if (!display.equals("text")) {
                this.encodeIcon(writer, severityKey, msg.getDetail(), iconOnly);
            }
            if (!iconOnly) {
                if (uiMessage.isShowSummary()) {
                    this.encodeText(writer, msg.getSummary(), severityKey + "-summary", escape);
                }
                if (uiMessage.isShowDetail()) {
                    this.encodeText(writer, msg.getDetail(), severityKey + "-detail", escape);
                }
            }
            msg.rendered();
        } else {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        writer.endElement("div");
    }

    protected void encodeText(ResponseWriter writer, String text, String severity, boolean escape) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-message-" + severity), null);
        if (escape) {
            writer.writeText((Object)text, null);
        } else {
            writer.write(text);
        }
        writer.endElement("span");
    }

    protected void encodeIcon(ResponseWriter writer, String severity, String title, boolean iconOnly) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-message-" + severity + "-icon"), null);
        if (iconOnly) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext context, Message uiMessage, String targetClientId) throws IOException {
        if (uiMessage.getDisplay().equals("tooltip")) {
            String clientId = uiMessage.getClientId(context);
            WidgetBuilder wb = this.getWidgetBuilder(context);
            wb.initWithDomReady("Message", uiMessage.resolveWidgetVar(), clientId).attr("target", targetClientId).finish();
        }
    }
}

