/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.spi.project.support.GenericSources;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class TestDataDirsNodeFactory
implements NodeFactory {
    public NodeList<?> createNodes(Project p) {
        NbModuleProject prj = (NbModuleProject)p.getLookup().lookup(NbModuleProject.class);
        return new TestDataDirsNL(prj);
    }

    private static class TestDataDirsNL
    implements NodeList<SourceGroup> {
        private final NbModuleProject project;

        public TestDataDirsNL(NbModuleProject project) {
            this.project = project;
        }

        public List<SourceGroup> keys() {
            ArrayList<SourceGroup> keys = new ArrayList<SourceGroup>();
            for (String testType : this.project.supportedTestTypes()) {
                FileObject root;
                String dataDir = this.project.evaluator().getProperty("test." + testType + ".data.dir");
                if (dataDir == null || (root = this.project.getHelper().resolveFileObject(dataDir)) == null) continue;
                String displayName = NbBundle.getMessage(TestDataDirsNodeFactory.class, (String)("TestDataDirsNodeFactory." + testType + "_test_data"));
                keys.add(GenericSources.group((Project)this.project, (FileObject)root, (String)testType, (String)displayName, null, null));
            }
            return keys;
        }

        public Node node(final SourceGroup key) {
            try {
                Node nodeDelegate = DataObject.find((FileObject)key.getRootFolder()).getNodeDelegate();
                return new FilterNode(nodeDelegate, null, (Lookup)new ProxyLookup(new Lookup[]{nodeDelegate.getLookup(), Lookups.singleton((Object)new PathFinder(key))})){

                    public String getName() {
                        return key.getName();
                    }

                    public String getDisplayName() {
                        return key.getDisplayName();
                    }
                };
            }
            catch (DataObjectNotFoundException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public void addNotify() {
        }

        public void removeNotify() {
        }
    }

    public static final class PathFinder
    implements org.netbeans.spi.project.ui.PathFinder {
        private final SourceGroup g;

        PathFinder(SourceGroup g) {
            this.g = g;
        }

        public Node findPath(Node rootNode, Object o) {
            FileObject fo;
            if (o instanceof FileObject) {
                fo = (FileObject)o;
            } else if (o instanceof DataObject) {
                fo = ((DataObject)o).getPrimaryFile();
            } else {
                return null;
            }
            FileObject groupRoot = this.g.getRootFolder();
            if (FileUtil.isParentOf((FileObject)groupRoot, (FileObject)fo)) {
                return this.findPathReduced(fo, rootNode);
            }
            if (groupRoot.equals(fo)) {
                return rootNode;
            }
            return null;
        }

        private Node findPathPlain(FileObject fo, FileObject groupRoot, Node rootNode) {
            FileObject folder = fo.isFolder() ? fo : fo.getParent();
            String relPath = FileUtil.getRelativePath((FileObject)groupRoot, (FileObject)folder);
            ArrayList<String> path = new ArrayList<String>();
            StringTokenizer strtok = new StringTokenizer(relPath, "/");
            while (strtok.hasMoreTokens()) {
                String token = strtok.nextToken();
                path.add(token);
            }
            try {
                Node folderNode;
                Node node = folderNode = folder.equals(groupRoot) ? rootNode : NodeOp.findPath((Node)rootNode, Collections.enumeration(path));
                if (fo.isFolder()) {
                    return folderNode;
                }
                Node[] childs = folderNode.getChildren().getNodes(true);
                for (int i = 0; i < childs.length; ++i) {
                    DataObject dobj = (DataObject)childs[i].getLookup().lookup(DataObject.class);
                    if (dobj == null || !dobj.getPrimaryFile().getNameExt().equals(fo.getNameExt())) continue;
                    return childs[i];
                }
            }
            catch (NodeNotFoundException e) {
                e.printStackTrace();
            }
            return null;
        }

        private Node findPathReduced(FileObject fo, Node n) {
            FileObject f = (FileObject)n.getLookup().lookup(FileObject.class);
            if (f == fo) {
                return n;
            }
            if (f != null && FileUtil.isParentOf((FileObject)f, (FileObject)fo)) {
                for (Node child : n.getChildren().getNodes(true)) {
                    Node found = this.findPathReduced(fo, child);
                    if (found == null) continue;
                    return found;
                }
            }
            return null;
        }
    }
}

