/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.debugger.jpda.ui.completion.ClassCompletionProvider;
import org.netbeans.modules.debugger.jpda.ui.completion.ClassSearchScopeType;
import org.netbeans.modules.debugger.jpda.ui.completion.ElementCompletionItem;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ExceptionCompletionProvider
implements CompletionProvider {
    private static final Logger LOG = Logger.getLogger(ExceptionCompletionProvider.class.getName());
    private static final Set<? extends ClassIndex.SearchScopeType> scopeAll = Collections.singleton(new ClassSearchScopeType());

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType != 1) {
            return null;
        }
        return new AsyncCompletionTask(new AsyncCompletionQuery(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                try {
                    String text;
                    if (caretOffset < 0) {
                        caretOffset = 0;
                    }
                    try {
                        text = doc.getText(0, caretOffset);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        text = "";
                    }
                    LOG.log(Level.FINE, "Completion query for ''{0}''", text);
                    ClasspathInfo cpi = ClassCompletionProvider.getClassPathInfo();
                    JavaSource jsrc = JavaSource.create((ClasspathInfo)cpi, (FileObject[])new FileObject[0]);
                    try {
                        jsrc.runUserActionTask((Task)new CompletionUserTask(resultSet, cpi, text, caretOffset), true);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                finally {
                    LOG.fine("Completion result set finished.");
                    resultSet.finish();
                }
            }
        }, component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 1;
    }

    private static class CompletionUserTask
    implements Task<CompilationController> {
        private final CompletionResultSet resultSet;
        private final ClasspathInfo cpi;
        private final String prefix;
        private final int lastPrefixDot;
        private final int caretOffset;

        private CompletionUserTask(CompletionResultSet resultSet, ClasspathInfo cpi, String prefix, int caretOffset) {
            this.resultSet = resultSet;
            this.cpi = cpi;
            this.prefix = prefix;
            this.lastPrefixDot = prefix.lastIndexOf(46);
            this.caretOffset = caretOffset;
        }

        public void run(CompilationController cc) throws Exception {
            block12: {
                LOG.log(Level.FINE, "  Running CompletionUserTask, compilation controller = {0}", cc);
                cc.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement thr = cc.getElements().getTypeElement("java.lang.Throwable");
                LOG.log(Level.FINE, "  Filling results, throwable element = {0}", thr);
                if (thr == null) break block12;
                DeclaredType type = cc.getTypes().getDeclaredType(thr, new TypeMirror[0]);
                LOG.log(Level.FINE, "  Filling results, throwable declared type = {0}", type);
                if (type != null) {
                    Set<ClassSearchScopeType> scope = Collections.singleton(new ClassSearchScopeType(this.prefix));
                    int n = this.prefix.length();
                    ClassIndex classIndex = this.cpi.getClassIndex();
                    Set packageNames = classIndex.getPackageNames(this.prefix, false, scope);
                    LOG.log(Level.FINE, "  Have package names = {0}", packageNames);
                    HashSet<String> resultPackages = new HashSet<String>();
                    HashSet<String> fullResultPackages = new HashSet<String>();
                    for (String pn : packageNames) {
                        int dot = pn.indexOf(46, n);
                        if (dot > 0) {
                            pn = pn.substring(0, dot);
                        }
                        String fpn = pn;
                        if (this.lastPrefixDot > 0) {
                            pn = pn.substring(this.lastPrefixDot + 1);
                        }
                        if (resultPackages.contains(pn)) continue;
                        resultPackages.add(pn);
                        fullResultPackages.add(fpn);
                        LOG.log(Level.FINE, "  Considering package: ''{0}''", pn);
                    }
                    List<DeclaredType> types = this.fillSubTypes(cc, type);
                    if (this.lastPrefixDot > 0) {
                        HashSet<String> classPackages = new HashSet<String>();
                        for (DeclaredType dt : types) {
                            String fqn;
                            TypeElement elem = (TypeElement)dt.asElement();
                            String className = fqn = elem.getQualifiedName().toString();
                            className = className.substring(this.lastPrefixDot + 1);
                            if (fqn.length() <= n) continue;
                            int dot = fqn.indexOf(46, n);
                            if (dot > 0) {
                                String pn = fqn.substring(0, dot);
                                if (resultPackages.contains(pn = pn.substring(this.lastPrefixDot + 1))) {
                                    classPackages.add(pn);
                                }
                            }
                            if (dot >= 0 && fullResultPackages.contains(fqn.substring(0, dot))) continue;
                            LOG.log(Level.FINE, "  Adding class name ''{0}''", className);
                            ElementCompletionItem eci = new ElementCompletionItem(className, elem.getKind(), this.caretOffset);
                            eci.setElement(elem);
                            this.resultSet.addItem((CompletionItem)eci);
                        }
                        for (String pn : classPackages) {
                            this.resultSet.addItem((CompletionItem)new ElementCompletionItem(pn, ElementKind.PACKAGE, this.caretOffset));
                        }
                    } else {
                        for (DeclaredType dt : types) {
                            TypeElement elem = (TypeElement)dt.asElement();
                            String className = elem.getSimpleName().toString();
                            LOG.log(Level.FINE, "  Adding class name ''{0}''", className);
                            ElementCompletionItem eci = new ElementCompletionItem(className, elem.getKind(), this.caretOffset);
                            eci.setElement(elem);
                            this.resultSet.addItem((CompletionItem)eci);
                        }
                        for (String pn : resultPackages) {
                            this.resultSet.addItem((CompletionItem)new ElementCompletionItem(pn, ElementKind.PACKAGE, this.caretOffset));
                        }
                    }
                }
            }
        }

        private List<DeclaredType> fillSubTypes(CompilationController cc, DeclaredType dType) {
            ArrayList<DeclaredType> subtypes = new ArrayList<DeclaredType>();
            Types types = cc.getTypes();
            if (this.prefix != null && this.prefix.length() > 2 && this.lastPrefixDot < 0) {
                ClassIndex.NameKind kind = ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
                for (ElementHandle handle : this.cpi.getClassIndex().getDeclaredTypes(this.prefix, kind, EnumSet.allOf(ClassIndex.SearchScope.class))) {
                    TypeElement te = (TypeElement)handle.resolve((CompilationInfo)cc);
                    if (te == null || !types.isSubtype(types.getDeclaredType(te, new TypeMirror[0]), dType)) continue;
                    subtypes.add(types.getDeclaredType(te, new TypeMirror[0]));
                }
            } else {
                HashSet<TypeElement> elems = new HashSet<TypeElement>();
                LinkedList<DeclaredType> bases = new LinkedList<DeclaredType>();
                bases.add(dType);
                ClassIndex index = this.cpi.getClassIndex();
                while (!bases.isEmpty()) {
                    DeclaredType head = (DeclaredType)bases.remove();
                    TypeElement elem = (TypeElement)head.asElement();
                    if (!elems.add(elem)) continue;
                    if (this.accept(elem)) {
                        subtypes.add(head);
                    }
                    for (ElementHandle eh : index.getElements(ElementHandle.create((Element)elem), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.allOf(ClassIndex.SearchScope.class))) {
                        TypeElement e = (TypeElement)eh.resolve((CompilationInfo)cc);
                        if (e == null) continue;
                        DeclaredType dt = types.getDeclaredType(e, new TypeMirror[0]);
                        bases.add(dt);
                    }
                }
            }
            return subtypes;
        }

        private boolean accept(TypeElement elem) {
            String className = this.lastPrefixDot < 0 ? elem.getSimpleName().toString() : elem.getQualifiedName().toString();
            return className.length() >= this.prefix.length() && className.substring(0, this.prefix.length()).equalsIgnoreCase(this.prefix);
        }
    }
}

