/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetMaintenanceRunRequest
extends BmcRequest<Void> {
    private String maintenanceRunId;

    public String getMaintenanceRunId() {
        return this.maintenanceRunId;
    }

    public Builder toBuilder() {
        return new Builder().maintenanceRunId(this.maintenanceRunId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",maintenanceRunId=").append(String.valueOf(this.maintenanceRunId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMaintenanceRunRequest)) {
            return false;
        }
        GetMaintenanceRunRequest other = (GetMaintenanceRunRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.maintenanceRunId, other.maintenanceRunId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maintenanceRunId == null ? 43 : this.maintenanceRunId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMaintenanceRunRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String maintenanceRunId = null;

        public Builder maintenanceRunId(String maintenanceRunId) {
            this.maintenanceRunId = maintenanceRunId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMaintenanceRunRequest o) {
            this.maintenanceRunId(o.getMaintenanceRunId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMaintenanceRunRequest build() {
            GetMaintenanceRunRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMaintenanceRunRequest buildWithoutInvocationCallback() {
            GetMaintenanceRunRequest request = new GetMaintenanceRunRequest();
            request.maintenanceRunId = this.maintenanceRunId;
            return request;
        }
    }
}

