/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDbHomePatchHistoryEntryRequest
extends BmcRequest<Void> {
    private String dbHomeId;
    private String patchHistoryEntryId;

    public String getDbHomeId() {
        return this.dbHomeId;
    }

    public String getPatchHistoryEntryId() {
        return this.patchHistoryEntryId;
    }

    public Builder toBuilder() {
        return new Builder().dbHomeId(this.dbHomeId).patchHistoryEntryId(this.patchHistoryEntryId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbHomeId=").append(String.valueOf(this.dbHomeId));
        sb.append(",patchHistoryEntryId=").append(String.valueOf(this.patchHistoryEntryId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDbHomePatchHistoryEntryRequest)) {
            return false;
        }
        GetDbHomePatchHistoryEntryRequest other = (GetDbHomePatchHistoryEntryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbHomeId, other.dbHomeId) && Objects.equals(this.patchHistoryEntryId, other.patchHistoryEntryId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbHomeId == null ? 43 : this.dbHomeId.hashCode());
        result = result * 59 + (this.patchHistoryEntryId == null ? 43 : this.patchHistoryEntryId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDbHomePatchHistoryEntryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbHomeId = null;
        private String patchHistoryEntryId = null;

        public Builder dbHomeId(String dbHomeId) {
            this.dbHomeId = dbHomeId;
            return this;
        }

        public Builder patchHistoryEntryId(String patchHistoryEntryId) {
            this.patchHistoryEntryId = patchHistoryEntryId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDbHomePatchHistoryEntryRequest o) {
            this.dbHomeId(o.getDbHomeId());
            this.patchHistoryEntryId(o.getPatchHistoryEntryId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDbHomePatchHistoryEntryRequest build() {
            GetDbHomePatchHistoryEntryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDbHomePatchHistoryEntryRequest buildWithoutInvocationCallback() {
            GetDbHomePatchHistoryEntryRequest request = new GetDbHomePatchHistoryEntryRequest();
            request.dbHomeId = this.dbHomeId;
            request.patchHistoryEntryId = this.patchHistoryEntryId;
            return request;
        }
    }
}

