/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousDatabaseApex
extends ExplicitlySetBmcModel {
    @JsonProperty(value="apexVersion")
    private final String apexVersion;
    @JsonProperty(value="ordsVersion")
    private final String ordsVersion;

    @Deprecated
    @ConstructorProperties(value={"apexVersion", "ordsVersion"})
    public AutonomousDatabaseApex(String apexVersion, String ordsVersion) {
        this.apexVersion = apexVersion;
        this.ordsVersion = ordsVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getApexVersion() {
        return this.apexVersion;
    }

    public String getOrdsVersion() {
        return this.ordsVersion;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutonomousDatabaseApex(");
        sb.append("super=").append(super.toString());
        sb.append("apexVersion=").append(String.valueOf(this.apexVersion));
        sb.append(", ordsVersion=").append(String.valueOf(this.ordsVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutonomousDatabaseApex)) {
            return false;
        }
        AutonomousDatabaseApex other = (AutonomousDatabaseApex)((Object)o);
        return Objects.equals(this.apexVersion, other.apexVersion) && Objects.equals(this.ordsVersion, other.ordsVersion) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.apexVersion == null ? 43 : this.apexVersion.hashCode());
        result = result * 59 + (this.ordsVersion == null ? 43 : this.ordsVersion.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="apexVersion")
        private String apexVersion;
        @JsonProperty(value="ordsVersion")
        private String ordsVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder apexVersion(String apexVersion) {
            this.apexVersion = apexVersion;
            this.__explicitlySet__.add("apexVersion");
            return this;
        }

        public Builder ordsVersion(String ordsVersion) {
            this.ordsVersion = ordsVersion;
            this.__explicitlySet__.add("ordsVersion");
            return this;
        }

        public AutonomousDatabaseApex build() {
            AutonomousDatabaseApex model = new AutonomousDatabaseApex(this.apexVersion, this.ordsVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutonomousDatabaseApex model) {
            if (model.wasPropertyExplicitlySet("apexVersion")) {
                this.apexVersion(model.getApexVersion());
            }
            if (model.wasPropertyExplicitlySet("ordsVersion")) {
                this.ordsVersion(model.getOrdsVersion());
            }
            return this;
        }
    }
}

