/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.registry;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Properties;
import javax.xml.registry.Connection;
import javax.xml.registry.FederatedConnection;
import javax.xml.registry.JAXRException;

public abstract class ConnectionFactory {
    private static final String CONNECTION_FACTORY_CLASS = "javax.xml.registry.ConnectionFactoryClass";
    private static final String DEFAULT_CONNECTION_FACTORY = "com.sun.xml.registry.common.ConnectionFactoryImpl";

    public abstract void setProperties(Properties var1) throws JAXRException;

    public abstract Properties getProperties() throws JAXRException;

    public abstract Connection createConnection() throws JAXRException;

    public abstract FederatedConnection createFederatedConnection(Collection var1) throws JAXRException;

    public static ConnectionFactory newInstance() throws JAXRException {
        try {
            return (ConnectionFactory)ConnectionFactory.find(CONNECTION_FACTORY_CLASS, DEFAULT_CONNECTION_FACTORY);
        }
        catch (Exception ex) {
            throw new JAXRException("Unable to create ConnectionFactory: " + ex.getMessage());
        }
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws JAXRException {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new JAXRException("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new JAXRException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Object find(String factoryId, String fallbackClassName) throws JAXRException {
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception x) {
            throw new JAXRException(x.toString(), x);
        }
        try {
            String systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                return ConnectionFactory.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        try {
            String javah = System.getProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "jaxr.properties";
            File f = new File(configFile);
            if (f.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(f));
                String factoryClassName = props.getProperty(factoryId);
                return ConnectionFactory.newInstance(factoryClassName, classLoader);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        String serviceId = "META-INF/services/" + factoryId;
        try {
            InputStream is = null;
            is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
            if (is != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String factoryClassName = rd.readLine();
                rd.close();
                if (factoryClassName != null && !"".equals(factoryClassName)) {
                    return ConnectionFactory.newInstance(factoryClassName, classLoader);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (fallbackClassName == null) {
            throw new JAXRException("Provider for " + factoryId + " cannot be found", null);
        }
        return ConnectionFactory.newInstance(fallbackClassName, classLoader);
    }
}

