/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.nodes;

import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Map;
import org.netbeans.modules.payara.common.nodes.Hk2ItemNode;
import org.netbeans.modules.payara.common.nodes.actions.OpenURLActionCookie;
import org.netbeans.modules.payara.spi.Decorator;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.netbeans.modules.payara.spi.Utils;
import org.netbeans.modules.payara.spi.WSDesc;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class Hk2WSNode
extends Hk2ItemNode {
    private final WSDesc ws;
    private final Lookup lu;

    public Hk2WSNode(final Lookup lookup, final WSDesc ws, Decorator decorator) {
        super(Children.LEAF, lookup, ws.getName(), decorator);
        this.setDisplayName(ws.getName());
        this.setShortDescription(NbBundle.getMessage(Hk2WSNode.class, (String)"WS_NODE_DESC", (Object)ws.getName(), (Object)ws.getWsdlUrl()));
        this.ws = ws;
        this.lu = lookup;
        this.getCookieSet().add((Node.Cookie)new OpenURLActionCookie(){

            @Override
            public String getWebURL() {
                String result = null;
                PayaraModule commonModule = (PayaraModule)lookup.lookup(PayaraModule.class);
                if (commonModule != null) {
                    Map<String, String> ip = commonModule.getInstanceProperties();
                    String host = ip.get("httphostname");
                    if (null == host) {
                        host = ip.get("host");
                    }
                    String httpPort = ip.get("httpportnumber");
                    String url = ip.get("url");
                    result = url == null || !url.contains("ee6wc") ? Utils.getHttpListenerProtocol(host, httpPort) + "://" + host + ":" + httpPort + "/" + ws.getTestURL() : "http://" + host + ":" + httpPort + "/" + ws.getTestURL();
                    if (result.endsWith("//")) {
                        result = result.substring(0, result.length() - 1);
                    }
                }
                return result;
            }
        });
    }

    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() {
        String result = "";
        PayaraModule commonModule = (PayaraModule)this.lu.lookup(PayaraModule.class);
        if (commonModule != null) {
            Map<String, String> ip = commonModule.getInstanceProperties();
            String host = ip.get("httphostname");
            if (null == host) {
                host = ip.get("host");
            }
            String httpPort = ip.get("httpportnumber");
            String url = ip.get("url");
            result = url == null || !url.contains("ee6wc") ? Utils.getHttpListenerProtocol(host, httpPort) + "://" + host + ":" + httpPort + "/" + this.ws.getTestURL() : "http://" + host + ":" + httpPort + "/" + this.ws.getTestURL();
            if (result.endsWith("//")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return new StringSelection(result);
    }
}

