/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository.dependency.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class AddDependencyUI
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager explorerManager = new ExplorerManager();
    private final JButton addButton;
    private JScrollPane jScrollPane1;
    private JLabel lblDescription;

    public AddDependencyUI(String libDef) {
        this.initComponents();
        this.lblDescription.setText(NbBundle.getMessage(AddDependencyUI.class, (String)"LBL_Description", (Object)libDef));
        this.addButton = new JButton(NbBundle.getMessage(AddDependencyUI.class, (String)"BTN_Add"));
        this.addButton.setEnabled(false);
        AbstractNode openProjectsNode = new AbstractNode(Children.create((ChildFactory)new ChildFactory<Project>(){

            protected boolean createKeys(List<Project> toPopulate) {
                for (Project project : OpenProjects.getDefault().getOpenProjects()) {
                    if (project.getLookup().lookup(NbMavenProject.class) == null) continue;
                    toPopulate.add(project);
                }
                return true;
            }

            protected Node createNodeForKey(Project key) {
                return new OpenProjectNode(key);
            }
        }, (boolean)true));
        this.explorerManager.setRootContext((Node)openProjectsNode);
        BeanTreeView beanTreeView = (BeanTreeView)this.jScrollPane1;
        beanTreeView.setPopupAllowed(false);
        beanTreeView.setRootVisible(false);
        this.explorerManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("selectedNodes")) {
                    Node[] selectedNodes = AddDependencyUI.this.explorerManager.getSelectedNodes();
                    boolean enable = false;
                    for (Node node : selectedNodes) {
                        if (!(node instanceof OpenProjectNode)) continue;
                        enable = true;
                        break;
                    }
                    AddDependencyUI.this.addButton.setEnabled(enable);
                }
            }
        });
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    private void initComponents() {
        this.jScrollPane1 = new BeanTreeView();
        this.lblDescription = new JLabel();
        this.jScrollPane1.setBorder(BorderFactory.createEtchedBorder(null, UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")));
        this.lblDescription.setText(NbBundle.getMessage(AddDependencyUI.class, (String)"LBL_Description"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 330, Short.MAX_VALUE).addComponent(this.lblDescription, GroupLayout.Alignment.LEADING, -1, 330, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblDescription, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 369, Short.MAX_VALUE)));
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public List<Project> getSelectedMavenProjects() {
        Node[] selectedNodes;
        ArrayList<Project> mavenProjects = new ArrayList<Project>();
        for (Node node : selectedNodes = this.explorerManager.getSelectedNodes()) {
            mavenProjects.add((Project)node.getLookup().lookup(Project.class));
        }
        return mavenProjects;
    }

    private static class OpenProjectNode
    extends AbstractNode {
        private ProjectInformation pi;

        public OpenProjectNode(Project project) {
            super(Children.LEAF, Lookups.singleton((Object)project));
            this.pi = ProjectUtils.getInformation((Project)project);
        }

        public Image getIcon(int arg0) {
            return ImageUtilities.icon2Image((Icon)this.pi.getIcon());
        }

        public String getDisplayName() {
            return this.pi.getDisplayName();
        }
    }
}

