/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.apache.lucene.search.BooleanQuery;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.repository.Bundle;
import org.netbeans.modules.maven.repository.M2RepositoryBrowser;
import org.netbeans.modules.maven.repository.VersionNode;
import org.openide.actions.DeleteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class FindResultsNode
extends AbstractNode {
    private static final String FIND_IN_REPO = "org/netbeans/modules/maven/repository/FindInRepo.png";
    private static final String ARTIFACT_BADGE = "org/netbeans/modules/maven/repository/ArtifactBadge.png";
    private static final String EMPTY_ICON = "org/netbeans/modules/maven/repository/empty.png";
    private static final String WAIT_ICON = "org/netbeans/modules/maven/repository/wait.gif";
    private static final RequestProcessor queryRP = new RequestProcessor(FindResultsNode.class.getName(), 10);
    private final M2RepositoryBrowser.QueryRequest queryRequest;
    private String toAppend;
    private final HtmlDisplayNameChanger changer = new HtmlDisplayNameChanger();
    private static Node noResultsNode;
    private static Node tooGeneralNode;
    private static Node partialNode;

    FindResultsNode(M2RepositoryBrowser.QueryRequest request) {
        super(Children.LEAF, Lookups.singleton((Object)request));
        this.changer.setNode(this);
        this.setChildren(Children.create((ChildFactory)new FindResultsChildren(request.fields, request.infos, this.changer), (boolean)true));
        this.setDisplayName(request.fields.get(0).getValue());
        this.setIconBaseWithExtension(FIND_IN_REPO);
        this.queryRequest = request;
    }

    public boolean canDestroy() {
        return true;
    }

    private void changeHDM(String toAppend) {
        this.toAppend = toAppend;
        this.fireDisplayNameChange(null, null);
    }

    public void destroy() throws IOException {
        M2RepositoryBrowser.remove(this.queryRequest);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(DeleteAction.class)};
    }

    public String getHtmlDisplayName() {
        StringBuilder base = new StringBuilder().append(this.getDisplayName());
        if (this.toAppend != null) {
            base.append(" <font color='!controlShadow'>[");
            base.append(this.toAppend);
            base.append("]</font>");
        }
        return base.toString();
    }

    private static Node getNoResultsNode() {
        if (noResultsNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)FindResultsNode.WAIT_ICON);
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Empty");
            nd.setDisplayName(Bundle.LBL_Node_Empty());
            noResultsNode = nd;
        }
        return new FilterNode(noResultsNode, Children.LEAF);
    }

    private static Node getPartialNode() {
        if (partialNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)FindResultsNode.EMPTY_ICON);
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("partial");
            nd.setDisplayName(Bundle.LBL_Node_Partial());
            partialNode = nd;
        }
        return new FilterNode(partialNode, Children.LEAF);
    }

    private static Node getTooGeneralNode() {
        if (tooGeneralNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)FindResultsNode.EMPTY_ICON);
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Too General");
            nd.setDisplayName(Bundle.LBL_Node_TooGeneral());
            tooGeneralNode = nd;
        }
        return new FilterNode(tooGeneralNode, Children.LEAF);
    }

    private static class HtmlDisplayNameChanger {
        private FindResultsNode node;

        private HtmlDisplayNameChanger() {
        }

        void changeHtmlDisplayName(String toAppend) {
            assert (this.node != null);
            this.node.changeHDM(toAppend);
        }

        void setNode(FindResultsNode node) {
            this.node = node;
        }
    }

    private static class FindResultsChildren
    extends ChildFactory.Detachable<Node> {
        private List<Node> nodes;
        private final List<QueryField> fields;
        private final List<RepositoryInfo> infos;
        private final HtmlDisplayNameChanger changer;

        FindResultsChildren(List<QueryField> fields, List<RepositoryInfo> infos, HtmlDisplayNameChanger changer) {
            this.fields = fields;
            this.infos = infos;
            this.changer = changer;
        }

        protected Node createNodeForKey(Node key) {
            return key;
        }

        protected boolean createKeys(List<Node> toPopulate) {
            if (this.nodes != null) {
                toPopulate.addAll(this.nodes);
            } else {
                queryRP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RepositoryQueries.Result result = RepositoryQueries.findResult((List)fields, (List)infos);
                            this.update((RepositoryQueries.Result<NBVersionInfo>)result, result.isPartial());
                            if (result.isPartial()) {
                                result.waitForSkipped();
                                this.update((RepositoryQueries.Result<NBVersionInfo>)result, false);
                            }
                            if (result.getReturnedResultCount() != result.getTotalResultCount()) {
                                changer.changeHtmlDisplayName(Bundle.MSG_Narrow(result.getReturnedResultCount(), result.getTotalResultCount()));
                            }
                        }
                        catch (BooleanQuery.TooManyClauses exc) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    nodes = Collections.singletonList(FindResultsNode.getTooGeneralNode());
                                }
                            });
                        }
                        catch (OutOfMemoryError oome) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    nodes = Collections.singletonList(FindResultsNode.getTooGeneralNode());
                                }
                            });
                        }
                    }
                });
            }
            return true;
        }

        void update(RepositoryQueries.Result<NBVersionInfo> result, final boolean partial) {
            final HashMap<String, ArrayList<NBVersionInfo>> map = new HashMap<String, ArrayList<NBVersionInfo>>();
            if (result.getResults() != null) {
                for (NBVersionInfo nbvi : result.getResults()) {
                    String key = nbvi.getGroupId() + " : " + nbvi.getArtifactId();
                    ArrayList<NBVersionInfo> get = (ArrayList<NBVersionInfo>)map.get(key);
                    if (get == null) {
                        get = new ArrayList<NBVersionInfo>();
                        map.put(key, get);
                    }
                    get.add(nbvi);
                }
            }
            final ArrayList keyList = new ArrayList(map.keySet());
            Collections.sort(keyList);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.updateResultNodes(keyList, map, partial);
                }
            });
        }

        private void updateResultNodes(List<String> keyList, Map<String, List<NBVersionInfo>> map, boolean partial) {
            if (keyList.size() > 0) {
                HashMap<String, Node> currentNodes = new HashMap<String, Node>();
                if (this.nodes != null) {
                    for (Node nd : this.nodes) {
                        currentNodes.put(nd.getName(), nd);
                    }
                }
                ArrayList<Node> newNodes = new ArrayList<Node>(keyList.size());
                for (String key : keyList) {
                    Object nd = (Node)currentNodes.get(key);
                    if (null != nd) {
                        ((ArtifactNode)((Object)nd)).setVersionInfos(map.get(key));
                    } else {
                        nd = new ArtifactNode(key, map.get(key));
                    }
                    newNodes.add((Node)nd);
                }
                if (partial) {
                    newNodes.add(FindResultsNode.getPartialNode());
                }
                this.nodes = newNodes;
                this.refresh(false);
            } else {
                this.nodes = partial ? Collections.singletonList(FindResultsNode.getPartialNode()) : Collections.singletonList(FindResultsNode.getNoResultsNode());
            }
        }
    }

    private static class ArtifactNode
    extends AbstractNode {
        private List<NBVersionInfo> versionInfos;
        private ArtifactNodeChildren myChildren = (ArtifactNodeChildren)this.getChildren();

        public ArtifactNode(String name, List<NBVersionInfo> list) {
            super((Children)new ArtifactNodeChildren(list));
            this.versionInfos = list;
            this.setName(name);
            this.setDisplayName(name);
        }

        public Image getIcon(int arg0) {
            Image badge = ImageUtilities.loadImage((String)FindResultsNode.ARTIFACT_BADGE, (boolean)true);
            return badge;
        }

        public Image getOpenedIcon(int arg0) {
            return this.getIcon(arg0);
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }

        public List<NBVersionInfo> getVersionInfos() {
            return new ArrayList<NBVersionInfo>(this.versionInfos);
        }

        public void setVersionInfos(List<NBVersionInfo> infos) {
            this.versionInfos = infos;
            this.myChildren.setNewKeys(infos);
        }

        static class ArtifactNodeChildren
        extends Children.Keys<NBVersionInfoTuple> {
            private List<NBVersionInfoTuple> keys;

            public ArtifactNodeChildren(List<NBVersionInfo> keys) {
                this.keys = this.processKeys(keys);
            }

            protected Node[] createNodes(NBVersionInfoTuple info) {
                return new Node[]{new VersionNode(info.repo, info.info, info.info.isJavadocExists(), info.info.isSourcesExists(), true)};
            }

            protected void addNotify() {
                this.setKeys(this.keys);
            }

            protected void setNewKeys(List<NBVersionInfo> keys) {
                this.keys = this.processKeys(keys);
                this.setKeys(this.keys);
            }

            private List<NBVersionInfoTuple> processKeys(List<NBVersionInfo> keys) {
                ArrayList<NBVersionInfoTuple> toRet = new ArrayList<NBVersionInfoTuple>();
                HashMap<RepositoryInfo, HashSet<NBVersionInfo>> map = new HashMap<RepositoryInfo, HashSet<NBVersionInfo>>();
                for (NBVersionInfo k : keys) {
                    RepositoryInfo rinf = RepositoryPreferences.getInstance().getRepositoryInfoById(k.getRepoId());
                    NBVersionInfoTuple t = new NBVersionInfoTuple(k, rinf);
                    toRet.add(t);
                    HashSet<NBVersionInfo> set = (HashSet<NBVersionInfo>)map.get(rinf);
                    if (set == null) {
                        set = new HashSet<NBVersionInfo>();
                        map.put(rinf, set);
                    }
                    set.add(k);
                }
                Iterator it = toRet.iterator();
                block1: while (it.hasNext()) {
                    NBVersionInfoTuple one = (NBVersionInfoTuple)it.next();
                    if (!one.repo.isLocal()) continue;
                    for (Map.Entry ent : map.entrySet()) {
                        if (((RepositoryInfo)ent.getKey()).equals((Object)one.repo)) continue;
                        for (NBVersionInfo ver : (Set)ent.getValue()) {
                            if (one.info.compareToWithoutRepoId(ver) != 0) continue;
                            it.remove();
                            continue block1;
                        }
                    }
                }
                return toRet;
            }
        }

        static class NBVersionInfoTuple {
            final NBVersionInfo info;
            final RepositoryInfo repo;

            public NBVersionInfoTuple(NBVersionInfo info, RepositoryInfo repo) {
                this.info = info;
                this.repo = repo;
            }
        }
    }
}

