/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.ant.freeform.Actions;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.LookupMerger;
import org.openide.util.Lookup;

public class LookupMergerImpl
implements LookupMerger<ActionProvider> {
    private static final Logger LOG = Logger.getLogger(LookupMergerImpl.class.getName());

    public Class<ActionProvider> getMergeableClass() {
        return ActionProvider.class;
    }

    public ActionProvider merge(Lookup lookup) {
        return new ActionProviderImpl(lookup);
    }

    private static class ActionProviderImpl
    implements ActionProvider {
        private final Lookup lkp;

        public ActionProviderImpl(Lookup lkp) {
            this.lkp = lkp;
        }

        private Collection<? extends ActionProvider> delegates() {
            ActionProvider master = null;
            ArrayList<ActionProvider> aps = new ArrayList<ActionProvider>();
            for (ActionProvider ap : this.lkp.lookupAll(ActionProvider.class)) {
                if (ap instanceof Actions) {
                    assert (master == null);
                    master = ap;
                    continue;
                }
                assert (ap != this);
                aps.add(ap);
            }
            assert (master != null);
            aps.add(0, master);
            return aps;
        }

        public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
            boolean supported = false;
            for (ActionProvider actionProvider : this.delegates()) {
                if (!Arrays.asList(actionProvider.getSupportedActions()).contains(command)) continue;
                supported = true;
                boolean enabled = actionProvider.isActionEnabled(command, context);
                LOG.log(Level.FINE, "delegate {0} says enabled={1} for {2} in {3}", new Object[]{actionProvider, enabled, command, context});
                if (!enabled) continue;
                return true;
            }
            if (supported) {
                return false;
            }
            throw new IllegalArgumentException(command);
        }

        public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
            for (ActionProvider actionProvider : this.delegates()) {
                if (!Arrays.asList(actionProvider.getSupportedActions()).contains(command) || !actionProvider.isActionEnabled(command, context)) continue;
                LOG.log(Level.FINE, "delegating {0} on {1} to {2}", new Object[]{command, context, actionProvider});
                actionProvider.invokeAction(command, context);
                return;
            }
            throw new IllegalArgumentException(command);
        }

        public String[] getSupportedActions() {
            HashSet<String> actions = new HashSet<String>();
            Collection<? extends ActionProvider> aps = this.delegates();
            for (ActionProvider actionProvider : aps) {
                actions.addAll(Arrays.asList(actionProvider.getSupportedActions()));
            }
            LOG.log(Level.FINE, "delegates {0} report supported actions {1}", new Object[]{aps, actions});
            return actions.toArray(new String[0]);
        }
    }
}

