/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.util.DocTreeFactory;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.ReferenceParser;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.StringUtils;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Name;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import nbjavac.StringWrapper;

public class DocTreeMaker
implements DocTreeFactory {
    protected static final Context.Key<DocTreeMaker> treeMakerKey = new Context.Key();
    public int pos;
    private final JavacTrees trees;
    private final SentenceBreaker breaker;
    private final ReferenceParser referenceParser;

    public static DocTreeMaker instance(Context context) {
        DocTreeMaker instance = context.get(treeMakerKey);
        if (instance == null) {
            instance = new DocTreeMaker(context);
        }
        return instance;
    }

    protected DocTreeMaker(Context context) {
        context.put(treeMakerKey, this);
        this.pos = -1;
        this.trees = JavacTrees.instance(context);
        this.referenceParser = new ReferenceParser(ParserFactory.instance(context));
        this.breaker = new SentenceBreaker(this);
    }

    @Override
    public DocTreeMaker at(int pos) {
        this.pos = pos;
        return this;
    }

    @Override
    public DCTree.DCAttribute newAttributeTree(Name name, AttributeTree.ValueKind vkind, java.util.List<? extends DocTree> value) {
        DCTree.DCAttribute tree = new DCTree.DCAttribute(name, vkind, DocTreeMaker.cast(value));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCAuthor newAuthorTree(java.util.List<? extends DocTree> name) {
        DCTree.DCAuthor tree = new DCTree.DCAuthor(DocTreeMaker.cast(name));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCLiteral newCodeTree(TextTree text) {
        DCTree.DCLiteral tree = new DCTree.DCLiteral(DocTree.Kind.CODE, (DCTree.DCText)text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCComment newCommentTree(String text) {
        DCTree.DCComment tree = new DCTree.DCComment(text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCDeprecated newDeprecatedTree(java.util.List<? extends DocTree> text) {
        DCTree.DCDeprecated tree = new DCTree.DCDeprecated(DocTreeMaker.cast(text));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCDocComment newDocCommentTree(java.util.List<? extends DocTree> fullBody, java.util.List<? extends DocTree> tags) {
        return this.newDocCommentTree((java.util.List)fullBody, (java.util.List)tags, Collections.emptyList(), Collections.emptyList());
    }

    public DCTree.DCDocComment newDocCommentTree(Tokens.Comment comment, java.util.List<? extends DocTree> fullBody, java.util.List<? extends DocTree> tags, java.util.List<? extends DocTree> preamble, java.util.List<? extends DocTree> postamble) {
        Pair<java.util.List<DCTree>, java.util.List<DCTree>> pair = this.splitBody(fullBody);
        DCTree.DCDocComment tree = new DCTree.DCDocComment(comment, DocTreeMaker.cast(fullBody), (java.util.List)pair.fst, (java.util.List)pair.snd, DocTreeMaker.cast(tags), DocTreeMaker.cast(preamble), DocTreeMaker.cast(postamble));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCDocComment newDocCommentTree(java.util.List<? extends DocTree> fullBody, java.util.List<? extends DocTree> tags, java.util.List<? extends DocTree> preamble, java.util.List<? extends DocTree> postamble) {
        ListBuffer<DCTree> lb = new ListBuffer<DCTree>();
        lb.addAll((Collection<DCTree>)DocTreeMaker.cast(fullBody));
        List<DCTree> fBody = lb.toList();
        Tokens.Comment c = new Tokens.Comment(){

            @Override
            public JCDiagnostic.DiagnosticPosition getPos() {
                return null;
            }

            @Override
            public int getSourcePos(int index) {
                return -1;
            }

            @Override
            public String getText() {
                throw new UnsupportedOperationException(this.getClass() + ".getText");
            }

            @Override
            public Tokens.Comment stripIndent() {
                return this;
            }

            @Override
            public Tokens.Comment.CommentStyle getStyle() {
                throw new UnsupportedOperationException(this.getClass() + ".getStyle");
            }

            @Override
            public boolean isDeprecated() {
                throw new UnsupportedOperationException(this.getClass() + ".isDeprecated");
            }
        };
        Pair<java.util.List<DCTree>, java.util.List<DCTree>> pair = this.splitBody(fullBody);
        return new DCTree.DCDocComment(c, fBody, (java.util.List)pair.fst, (java.util.List)pair.snd, DocTreeMaker.cast(tags), DocTreeMaker.cast(preamble), DocTreeMaker.cast(postamble));
    }

    @Override
    public DCTree.DCDocRoot newDocRootTree() {
        DCTree.DCDocRoot tree = new DCTree.DCDocRoot();
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCDocType newDocTypeTree(String text) {
        DCTree.DCDocType tree = new DCTree.DCDocType(text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCEndElement newEndElementTree(Name name) {
        DCTree.DCEndElement tree = new DCTree.DCEndElement(name);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCEntity newEntityTree(Name name) {
        DCTree.DCEntity tree = new DCTree.DCEntity(name);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCErroneous newErroneousTree(String text, Diagnostic<JavaFileObject> diag) {
        DCTree.DCErroneous tree = new DCTree.DCErroneous(text, (JCDiagnostic)diag);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCEscape newEscapeTree(char ch) {
        DCTree.DCEscape tree = new DCTree.DCEscape(ch);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCThrows newExceptionTree(ReferenceTree name, java.util.List<? extends DocTree> description) {
        DCTree.DCThrows tree = new DCTree.DCThrows(DocTree.Kind.EXCEPTION, (DCTree.DCReference)name, DocTreeMaker.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCHidden newHiddenTree(java.util.List<? extends DocTree> text) {
        DCTree.DCHidden tree = new DCTree.DCHidden(DocTreeMaker.cast(text));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCIdentifier newIdentifierTree(Name name) {
        DCTree.DCIdentifier tree = new DCTree.DCIdentifier(name);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCIndex newIndexTree(DocTree term, java.util.List<? extends DocTree> description) {
        DCTree.DCIndex tree = new DCTree.DCIndex((DCTree)term, DocTreeMaker.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCInheritDoc newInheritDocTree() {
        return this.newInheritDocTree(null);
    }

    public DCTree.DCInheritDoc newInheritDocTree(ReferenceTree supertype) {
        DCTree.DCInheritDoc tree = new DCTree.DCInheritDoc((DCTree.DCReference)supertype);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCLink newLinkTree(ReferenceTree ref, java.util.List<? extends DocTree> label) {
        DCTree.DCLink tree = new DCTree.DCLink(DocTree.Kind.LINK, (DCTree.DCReference)ref, DocTreeMaker.cast(label));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCLink newLinkPlainTree(ReferenceTree ref, java.util.List<? extends DocTree> label) {
        DCTree.DCLink tree = new DCTree.DCLink(DocTree.Kind.LINK_PLAIN, (DCTree.DCReference)ref, DocTreeMaker.cast(label));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCLiteral newLiteralTree(TextTree text) {
        DCTree.DCLiteral tree = new DCTree.DCLiteral(DocTree.Kind.LITERAL, (DCTree.DCText)text);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCRawText newRawTextTree(DocTree.Kind kind, String text) {
        DCTree.DCRawText tree = new DCTree.DCRawText(kind, text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCParam newParamTree(boolean isTypeParameter, IdentifierTree name, java.util.List<? extends DocTree> description) {
        DCTree.DCParam tree = new DCTree.DCParam(isTypeParameter, (DCTree.DCIdentifier)name, DocTreeMaker.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCProvides newProvidesTree(ReferenceTree name, java.util.List<? extends DocTree> description) {
        DCTree.DCProvides tree = new DCTree.DCProvides((DCTree.DCReference)name, DocTreeMaker.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCReference newReferenceTree(String signature) {
        try {
            ReferenceParser.Reference ref = this.referenceParser.parse(signature, ReferenceParser.Mode.MEMBER_OPTIONAL);
            DCTree.DCReference tree = this.newReferenceTree(signature, ref);
            tree.pos = this.pos;
            return tree;
        }
        catch (ReferenceParser.ParseException e) {
            throw new IllegalArgumentException("invalid signature", e);
        }
    }

    public DCTree.DCReference newReferenceTree(String signature, ReferenceParser.Reference ref) {
        DCTree.DCReference tree = new DCTree.DCReference(signature, ref.moduleName, ref.qualExpr, ref.member, ref.paramTypes);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCReturn newReturnTree(java.util.List<? extends DocTree> description) {
        return this.newReturnTree(false, (java.util.List)description);
    }

    @Override
    public DCTree.DCReturn newReturnTree(boolean isInline, java.util.List<? extends DocTree> description) {
        DCTree.DCReturn tree = new DCTree.DCReturn(isInline, DocTreeMaker.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSee newSeeTree(java.util.List<? extends DocTree> reference) {
        DCTree.DCSee tree = new DCTree.DCSee(DocTreeMaker.cast(reference));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSerial newSerialTree(java.util.List<? extends DocTree> description) {
        DCTree.DCSerial tree = new DCTree.DCSerial(DocTreeMaker.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSerialData newSerialDataTree(java.util.List<? extends DocTree> description) {
        DCTree.DCSerialData tree = new DCTree.DCSerialData(DocTreeMaker.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSerialField newSerialFieldTree(IdentifierTree name, ReferenceTree type, java.util.List<? extends DocTree> description) {
        DCTree.DCSerialField tree = new DCTree.DCSerialField((DCTree.DCIdentifier)name, (DCTree.DCReference)type, DocTreeMaker.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSince newSinceTree(java.util.List<? extends DocTree> text) {
        DCTree.DCSince tree = new DCTree.DCSince(DocTreeMaker.cast(text));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSnippet newSnippetTree(java.util.List<? extends DocTree> attributes, TextTree text) {
        DCTree.DCSnippet tree = new DCTree.DCSnippet(DocTreeMaker.cast(attributes), (DCTree.DCText)text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSpec newSpecTree(TextTree url, java.util.List<? extends DocTree> title) {
        DCTree.DCSpec tree = new DCTree.DCSpec((DCTree.DCText)url, DocTreeMaker.cast(title));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCStartElement newStartElementTree(Name name, java.util.List<? extends DocTree> attrs, boolean selfClosing) {
        DCTree.DCStartElement tree = new DCTree.DCStartElement(name, DocTreeMaker.cast(attrs), selfClosing);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSummary newSummaryTree(java.util.List<? extends DocTree> text) {
        DCTree.DCSummary tree = new DCTree.DCSummary(DocTreeMaker.cast(text));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSystemProperty newSystemPropertyTree(Name propertyName) {
        DCTree.DCSystemProperty tree = new DCTree.DCSystemProperty(propertyName);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCText newTextTree(String text) {
        DCTree.DCText tree = new DCTree.DCText(text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCThrows newThrowsTree(ReferenceTree name, java.util.List<? extends DocTree> description) {
        DCTree.DCThrows tree = new DCTree.DCThrows(DocTree.Kind.THROWS, (DCTree.DCReference)name, DocTreeMaker.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCUnknownBlockTag newUnknownBlockTagTree(Name name, java.util.List<? extends DocTree> content) {
        DCTree.DCUnknownBlockTag tree = new DCTree.DCUnknownBlockTag(name, DocTreeMaker.cast(content));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCUnknownInlineTag newUnknownInlineTagTree(Name name, java.util.List<? extends DocTree> content) {
        DCTree.DCUnknownInlineTag tree = new DCTree.DCUnknownInlineTag(name, DocTreeMaker.cast(content));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCUses newUsesTree(ReferenceTree name, java.util.List<? extends DocTree> description) {
        DCTree.DCUses tree = new DCTree.DCUses((DCTree.DCReference)name, DocTreeMaker.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCValue newValueTree(ReferenceTree ref) {
        return this.newValueTree(null, ref);
    }

    @Override
    public DCTree.DCValue newValueTree(TextTree format, ReferenceTree ref) {
        DCTree.DCValue tree = new DCTree.DCValue((DCTree.DCText)format, (DCTree.DCReference)ref);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCVersion newVersionTree(java.util.List<? extends DocTree> text) {
        DCTree.DCVersion tree = new DCTree.DCVersion(DocTreeMaker.cast(text));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public java.util.List<DocTree> getFirstSentence(java.util.List<? extends DocTree> list) {
        Pair<java.util.List<DCTree>, java.util.List<DCTree>> pair = this.splitBody(list);
        return new ArrayList<DocTree>((Collection)pair.fst);
    }

    private static java.util.List<DCTree> cast(java.util.List<? extends DocTree> list) {
        return list;
    }

    Pair<java.util.List<DCTree>, java.util.List<DCTree>> splitBody(java.util.List<? extends DocTree> list) {
        return this.breaker.splitBody(list);
    }

    static class SentenceBreaker {
        final DocTreeMaker m;
        static final Set<String> sentenceBreakTags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("H1", "H2", "H3", "H4", "H5", "H6", "PRE", "P")));
        private static final Pattern INDENT = Pattern.compile(" {4}| {0,3}\t");
        private static final Pattern endPara = Pattern.compile("\n(([ \t]*\n)|( {0,3}[-+*#=_>]))");

        SentenceBreaker(DocTreeMaker m) {
            this.m = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Pair<java.util.List<DCTree>, java.util.List<DCTree>> splitBody(java.util.List<? extends DocTree> list) {
            if (list.isEmpty()) {
                return new Pair<java.util.List<DCTree>, java.util.List<DCTree>>(Collections.unmodifiableList(Arrays.asList(new DCTree[0])), Collections.unmodifiableList(Arrays.asList(new DCTree[0])));
            }
            int savedPos = this.m.pos;
            try {
                ListBuffer<DCTree> fs = new ListBuffer<DCTree>();
                ListBuffer<DCTree> body = new ListBuffer<DCTree>();
                ArrayList alist = new ArrayList(DocTreeMaker.cast(list));
                ListIterator iter = alist.listIterator();
                boolean foundFirstSentence = false;
                while (iter.hasNext() && !foundFirstSentence) {
                    boolean isFirst = !iter.hasPrevious();
                    DCTree dt = (DCTree)iter.next();
                    switch (dt.getKind()) {
                        case RETURN: 
                        case SUMMARY: {
                            fs.add(dt);
                            foundFirstSentence = true;
                            break;
                        }
                        case TEXT: 
                        case MARKDOWN: {
                            DCTree fsPart;
                            DCTree peekedNext = iter.hasNext() ? (DCTree)alist.get(iter.nextIndex()) : null;
                            String content = this.getContent(dt);
                            if (isFirst && dt.getKind() == DocTree.Kind.MARKDOWN && this.isIndented(content)) {
                                body.add(dt);
                                foundFirstSentence = true;
                                break;
                            }
                            int breakOffset = this.getSentenceBreak(dt.getKind(), content, peekedNext);
                            if (breakOffset > 0) {
                                fsPart = this.newNode(dt.getKind(), dt.pos, StringWrapper.stripTrailing(content.substring(0, breakOffset)));
                                fs.add(fsPart);
                                int wsOffset = this.skipWhiteSpace(content, breakOffset);
                                if (wsOffset > 0) {
                                    DCTree bodyPart = this.newNode(dt.getKind(), dt.pos + wsOffset, content.substring(wsOffset));
                                    body.add(bodyPart);
                                }
                                foundFirstSentence = true;
                                break;
                            }
                            if (peekedNext != null && this.isSentenceBreak(peekedNext, false)) {
                                fsPart = this.newNode(dt.getKind(), dt.pos, StringWrapper.stripTrailing(content));
                                fs.add(fsPart);
                                foundFirstSentence = true;
                                break;
                            }
                            fs.add(dt);
                            break;
                        }
                        default: {
                            if (this.isSentenceBreak(dt, isFirst)) {
                                body.add(dt);
                                foundFirstSentence = true;
                                break;
                            }
                            fs.add(dt);
                        }
                    }
                }
                while (iter.hasNext()) {
                    body.add((DCTree)iter.next());
                }
                Pair<java.util.List<DCTree>, java.util.List<DCTree>> pair = new Pair<java.util.List<DCTree>, java.util.List<DCTree>>(fs.toList(), body.toList());
                return pair;
            }
            finally {
                this.m.pos = savedPos;
            }
        }

        private String getContent(DCTree dt) {
            String string;
            switch (dt.getKind()) {
                case TEXT: {
                    string = ((DCTree.DCText)dt).text;
                    break;
                }
                case MARKDOWN: {
                    string = ((DCTree.DCRawText)dt).code;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(dt.getKind().toString());
                }
            }
            return string;
        }

        private boolean isIndented(String s) {
            return INDENT.matcher(s).lookingAt();
        }

        private DCTree newNode(DocTree.Kind kind, int pos, String text) {
            DCTree dCTree;
            switch (kind) {
                case TEXT: {
                    dCTree = this.m.at(pos).newTextTree(text);
                    break;
                }
                case MARKDOWN: {
                    dCTree = this.m.at(pos).newRawTextTree(kind, text);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(kind.toString());
                }
            }
            return dCTree;
        }

        private int getSentenceBreak(DocTree.Kind kind, String s, DCTree nextTree) {
            int sbrk2;
            BreakIterator breakIterator = this.m.trees.getBreakIterator();
            if (breakIterator == null) {
                return this.defaultSentenceBreak(kind, s);
            }
            String s2 = this.normalize(kind, kind == DocTree.Kind.MARKDOWN ? SentenceBreaker.firstParaText(s) : s);
            breakIterator.setText(s2);
            int sbrk = breakIterator.next();
            switch (kind) {
                case MARKDOWN: {
                    int endParaPos = SentenceBreaker.endParaPos(s2);
                    if (endParaPos == -1) break;
                    return Math.min(sbrk, endParaPos);
                }
            }
            if (nextTree == null || kind == DocTree.Kind.MARKDOWN && s2.length() < s.length()) {
                return sbrk;
            }
            if (sbrk < s.length() - 1) {
                return sbrk;
            }
            switch (nextTree.getKind()) {
                case TEXT: 
                case MARKDOWN: {
                    String combined = s2 + this.normalize(nextTree.getKind(), this.getContent(nextTree));
                    breakIterator.setText(combined);
                    sbrk2 = breakIterator.next();
                    if (sbrk >= sbrk2) break;
                    return sbrk;
                }
            }
            if (this.isSentenceBreak(nextTree, false)) {
                return sbrk;
            }
            String combined = s + "Dummy Sentence.";
            breakIterator.setText(combined);
            sbrk2 = breakIterator.next();
            if (sbrk2 <= sbrk) {
                return sbrk2;
            }
            return -1;
        }

        private int defaultSentenceBreak(DocTree.Kind kind, String s) {
            int n;
            String s2 = this.normalize(kind, s);
            int period = -1;
            block12: for (int i = 0; i < s2.length(); ++i) {
                switch (s2.charAt(i)) {
                    case '.': {
                        period = i;
                        continue block12;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (period < 0) continue block12;
                        switch (kind) {
                            case MARKDOWN: {
                                int endParaPos = SentenceBreaker.endParaPos(s2);
                                return endParaPos == -1 || i < endParaPos ? i : endParaPos;
                            }
                            case TEXT: {
                                return i;
                            }
                        }
                        throw new IllegalArgumentException(kind.toString());
                    }
                    default: {
                        period = -1;
                    }
                }
            }
            switch (kind) {
                case MARKDOWN: {
                    n = SentenceBreaker.endParaPos(s2);
                    break;
                }
                case TEXT: {
                    n = -1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(kind.toString());
                }
            }
            return n;
        }

        private static int endParaPos(String s) {
            Matcher m = endPara.matcher(s);
            return m.find() ? m.start() : -1;
        }

        private static String firstParaText(String s) {
            int endParaPos = SentenceBreaker.endParaPos(s);
            return endParaPos == -1 ? s : s.substring(0, endParaPos);
        }

        private boolean isSentenceBreak(DCTree dt, boolean isFirstDocTree) {
            switch (dt.getKind()) {
                case START_ELEMENT: {
                    StartElementTree set = (StartElementTree)((Object)dt);
                    return !isFirstDocTree && dt.pos > 1 && this.isSentenceBreak(set.getName());
                }
                case END_ELEMENT: {
                    EndElementTree eet = (EndElementTree)((Object)dt);
                    return !isFirstDocTree && dt.pos > 1 && this.isSentenceBreak(eet.getName());
                }
            }
            return false;
        }

        private boolean isSentenceBreak(Name tagName) {
            return sentenceBreakTags.contains(StringUtils.toUpperCase(tagName.toString()));
        }

        private int skipWhiteSpace(String s, int start) {
            for (int i = start; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (Character.isWhitespace(c)) continue;
                return i;
            }
            return -1;
        }

        private String normalize(DocTree.Kind kind, String s) {
            String string;
            switch (kind) {
                case TEXT: {
                    string = s;
                    break;
                }
                case MARKDOWN: {
                    string = this.normalizeMarkdown(s);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(kind.toString());
                }
            }
            return string;
        }

        private String normalizeMarkdown(String s) {
            StringBuilder sb = new StringBuilder();
            int slen = s.length();
            int i = 0;
            block7: while (i < slen) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\\': {
                        sb.append(ch);
                        if (++i >= slen) continue block7;
                        sb.append(s.charAt(i));
                        ++i;
                        break;
                    }
                    case '<': {
                        i = this.skip(sb, s, i, ch, '>');
                        break;
                    }
                    case '[': {
                        i = this.skip(sb, s, i, ch, ']');
                        break;
                    }
                    case '(': {
                        i = this.skip(sb, s, i, ch, ')');
                        break;
                    }
                    case '`': {
                        int start = i++;
                        while (i < slen && s.charAt(i) == '`') {
                            ++i;
                        }
                        String prefix = s.substring(start, i);
                        sb.append(prefix);
                        int j = s.indexOf(prefix, i);
                        if (j <= i) continue block7;
                        sb.append(s.substring(i, j).replace('.', '-'));
                        sb.append(prefix);
                        i = j + prefix.length();
                        break;
                    }
                    default: {
                        sb.append(ch);
                        ++i;
                    }
                }
            }
            return sb.toString();
        }

        private int skip(StringBuilder sb, String s, int i, char ch, char term) {
            sb.append(ch);
            int j = s.indexOf(term, ++i);
            if (j != -1) {
                sb.append(s.substring(i, j).replace('.', '-'));
                return j;
            }
            return i;
        }
    }
}

