/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import nbjavac.VMWrapper;

public class DeferredLintHandler {
    protected static final Context.Key<DeferredLintHandler> deferredLintHandlerKey = new Context.Key();
    private final HashMap<JCTree, ArrayList<LintLogger>> deferralMap = new HashMap();
    private final ArrayDeque<Consumer<LintLogger>> reporterStack = new ArrayDeque();

    public static DeferredLintHandler instance(Context context) {
        DeferredLintHandler instance = context.get(deferredLintHandlerKey);
        if (instance == null) {
            instance = new DeferredLintHandler(context);
        }
        return instance;
    }

    protected DeferredLintHandler(Context context) {
        context.put(deferredLintHandlerKey, this);
        Lint rootLint = Lint.instance(context);
        this.pushImmediate(rootLint);
    }

    public void push(JCTree decl) {
        Assert.check(decl.getTag() == JCTree.Tag.MODULEDEF || decl.getTag() == JCTree.Tag.PACKAGEDEF || decl.getTag() == JCTree.Tag.CLASSDEF || decl.getTag() == JCTree.Tag.METHODDEF || decl.getTag() == JCTree.Tag.VARDEF);
        this.reporterStack.push(logger -> this.deferralMap.computeIfAbsent(decl, s -> new ArrayList()).add(logger));
    }

    public void pushImmediate(Lint lint) {
        this.reporterStack.push(logger -> logger.report(lint));
    }

    public void pop() {
        Assert.check(this.reporterStack.size() > 1);
        this.reporterStack.pop();
    }

    public void report(LintLogger logger) {
        Assert.check(!this.reporterStack.isEmpty());
        this.reporterStack.peek().accept(logger);
    }

    public void flush(JCTree decl, Lint lint) {
        VMWrapper.optional2Stream(Optional.of(decl).map(this.deferralMap::remove)).flatMap(Collection::stream).forEach(logger -> logger.report(lint));
    }

    public static interface LintLogger {
        public void report(Lint var1);
    }
}

