/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output.text;

import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.libreoffice.report.pentaho.styles.LengthCalculator;

public class PageContext {
    public static final int KEEP_TOGETHER_GROUP = 1;
    public static final int KEEP_TOGETHER_FIRST_DETAIL = 2;
    private PageContext parent;
    private String header;
    private CSSNumericValue headerHeight;
    private String footer;
    private CSSNumericValue footerHeight;
    private int keepTogether;
    private Integer columnCount = null;
    private boolean sectionOpen;

    public PageContext() {
        this(null);
    }

    public PageContext(PageContext pageContext) {
        this.parent = pageContext;
        if (pageContext != null) {
            this.keepTogether = pageContext.getKeepTogether();
        }
    }

    public int getActiveColumns() {
        for (PageContext pageContext = this; pageContext != null; pageContext = pageContext.getParent()) {
            if (this.columnCount == null) continue;
            return this.columnCount;
        }
        return 1;
    }

    public void setColumnCount(Integer n) {
        this.columnCount = n;
    }

    public Integer getColumnCount() {
        return this.columnCount;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String string, CSSNumericValue cSSNumericValue) {
        this.header = string;
        this.headerHeight = cSSNumericValue;
    }

    public String getFooter() {
        return this.footer;
    }

    private CSSNumericValue getHeaderHeight() {
        return this.headerHeight;
    }

    private CSSNumericValue getFooterHeight() {
        return this.footerHeight;
    }

    public void setFooter(String string, CSSNumericValue cSSNumericValue) {
        this.footer = string;
        this.footerHeight = cSSNumericValue;
    }

    public int getKeepTogether() {
        return this.keepTogether;
    }

    public void setKeepTogether(int n) {
        this.keepTogether = n;
    }

    public PageContext getParent() {
        return this.parent;
    }

    public CSSNumericValue getAllFooterSize() {
        if (this.parent == null) {
            return this.footerHeight;
        }
        LengthCalculator lengthCalculator = new LengthCalculator();
        for (PageContext pageContext = this; pageContext != null; pageContext = pageContext.getParent()) {
            lengthCalculator.add(pageContext.getFooterHeight());
        }
        return lengthCalculator.getResult();
    }

    public CSSNumericValue getAllHeaderSize() {
        if (this.parent == null) {
            return this.headerHeight;
        }
        LengthCalculator lengthCalculator = new LengthCalculator();
        for (PageContext pageContext = this; pageContext != null; pageContext = pageContext.getParent()) {
            lengthCalculator.add(pageContext.getHeaderHeight());
        }
        return lengthCalculator.getResult();
    }

    public String getPageFooterContent() {
        if (this.parent == null) {
            return this.getFooter();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (PageContext pageContext = this; pageContext != null; pageContext = pageContext.getParent()) {
            String string = pageContext.getFooter();
            if (string == null) continue;
            stringBuffer.append(string);
        }
        if (stringBuffer.length() != 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public String getPageHeaderContent() {
        if (this.parent == null) {
            return this.getHeader();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getPageHeaderContent());
        stringBuffer.append(this.getHeader());
        if (stringBuffer.length() != 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public boolean isSectionOpen() {
        return this.sectionOpen;
    }

    public void setSectionOpen(boolean bl) {
        this.sectionOpen = bl;
    }
}

