/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.logical;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class XorFunction
implements Function {
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final long serialVersionUID = 1593151240024848931L;

    @Override
    public String getCanonicalName() {
        return "XOR";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() < 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        int count = 0;
        int parameterCount = parameters.getParameterCount();
        for (int i = 0; i < parameterCount; ++i) {
            Type conditionType = parameters.getType(i);
            Object conditionValue = parameters.getValue(i);
            Boolean condition = context.getTypeRegistry().convertToLogical(conditionType, conditionValue);
            if (condition == null) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            if (!Boolean.TRUE.equals(condition)) continue;
            ++count;
        }
        if (count % 2 == 1) {
            return RETURN_TRUE;
        }
        return RETURN_FALSE;
    }
}

