/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.RemoteCache;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.SingleUseObjectProviderFactory;
import org.keycloak.models.session.RevokedToken;
import org.keycloak.models.session.RevokedTokenPersisterProvider;
import org.keycloak.models.sessions.infinispan.entities.SingleUseObjectValueEntity;
import org.keycloak.models.sessions.infinispan.remote.RemoteInfinispanSingleUseObjectProvider;
import org.keycloak.models.sessions.infinispan.remote.transaction.SingleUseObjectTransaction;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.provider.ServerInfoAwareProviderFactory;
import org.keycloak.storage.datastore.DefaultDatastoreProviderFactory;

public class RemoteInfinispanSingleUseObjectProviderFactory
implements SingleUseObjectProviderFactory<RemoteInfinispanSingleUseObjectProvider>,
EnvironmentDependentProviderFactory,
ProviderEventListener,
ServerInfoAwareProviderFactory {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final RemoteInfinispanSingleUseObjectProvider.RevokeTokenConsumer VOLATILE_REVOKE_TOKEN = (token, lifespanSeconds) -> {};
    private static final int REVOKED_TOKENS_IMPORT_CONCURRENCY = 16;
    private volatile RemoteCache<String, SingleUseObjectValueEntity> cache;
    private volatile boolean persistRevokedTokens;

    public RemoteInfinispanSingleUseObjectProvider create(KeycloakSession session) {
        assert (this.cache != null);
        return new RemoteInfinispanSingleUseObjectProvider(this.createAndEnlistTransaction(session), this.createRevokeTokenConsumer(session));
    }

    public void init(Config.Scope config) {
        this.persistRevokedTokens = config.getBoolean("persistRevokedTokens", Boolean.valueOf(true));
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.cache = InfinispanConnectionProvider.getRemoteCache(factory, "actionTokens");
        factory.register((ProviderEventListener)this);
        logger.debug((Object)"Provided initialized.");
    }

    public void close() {
    }

    public String getId() {
        return "remote";
    }

    public int order() {
        return 1;
    }

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isRemoteInfinispan();
    }

    public Map<String, String> getOperationalInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("persistRevokedTokens", Boolean.toString(this.persistRevokedTokens));
        return info;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        builder.property().name("persistRevokedTokens").type("boolean").helpText("If revoked tokens are stored persistently across restarts").defaultValue((Object)true).add();
        return builder.build();
    }

    public void onEvent(ProviderEvent event) {
        if (!(event instanceof PostMigrationEvent)) {
            return;
        }
        PostMigrationEvent pme = (PostMigrationEvent)event;
        if (!this.persistRevokedTokens) {
            return;
        }
        KeycloakSessionFactory sessionFactory = pme.getFactory();
        DefaultDatastoreProviderFactory.setupClearExpiredRevokedTokensScheduledTask((KeycloakSessionFactory)sessionFactory);
        try (KeycloakSession session = sessionFactory.create();){
            this.preloadRevokedTokens(session);
        }
    }

    private SingleUseObjectTransaction createAndEnlistTransaction(KeycloakSession session) {
        SingleUseObjectTransaction tx = new SingleUseObjectTransaction(this.cache);
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)tx);
        return tx;
    }

    private RevokedTokenPersisterProvider getRevokedTokenPersisterProvider(KeycloakSession session) {
        return (RevokedTokenPersisterProvider)session.getProvider(RevokedTokenPersisterProvider.class);
    }

    private RemoteInfinispanSingleUseObjectProvider.RevokeTokenConsumer createRevokeTokenConsumer(KeycloakSession session) {
        return this.persistRevokedTokens ? (arg_0, arg_1) -> ((RevokedTokenPersisterProvider)this.getRevokedTokenPersisterProvider(session)).revokeToken(arg_0, arg_1) : VOLATILE_REVOKE_TOKEN;
    }

    private void preloadRevokedTokens(KeycloakSession session) {
        RevokedTokenPersisterProvider provider = this.getRevokedTokenPersisterProvider(session);
        if (this.cache.get((Object)"loaded.revoked") == null) {
            logger.debug((Object)"Preloading revoked tokens from database.");
            int currentTime = Time.currentTime();
            Flowable.fromStream((Stream)provider.getAllRevokedTokens()).filter(revokedToken -> revokedToken.expiry() - (long)currentTime > 0L).flatMapCompletable(token -> this.preloadToken((RevokedToken)token, currentTime), false, 16).blockingAwait();
            this.cache.put((Object)"loaded.revoked", (Object)RemoteInfinispanSingleUseObjectProvider.REVOKED_TOKEN_VALUE);
            logger.debug((Object)"Preload completed.");
        }
    }

    private Completable preloadToken(RevokedToken token, long currentTime) {
        long lifespan = token.expiry() - currentTime;
        return Completable.fromCompletionStage((CompletionStage)this.cache.putIfAbsentAsync((Object)(token.tokenId() + ".revoked"), (Object)RemoteInfinispanSingleUseObjectProvider.REVOKED_TOKEN_VALUE, lifespan, TimeUnit.SECONDS));
    }
}

