/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.HistogramMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/videobridge/stats/PrometheusPacketDelayStats;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "histogram", "Lorg/jitsi/metrics/HistogramMetric;", "numPacketsWithoutTimestamps", "Lorg/jitsi/metrics/CounterMetric;", "addUnknown", "", "addDelay", "delayMs", "", "jitsi-videobridge"})
public final class PrometheusPacketDelayStats {
    @NotNull
    private final HistogramMetric histogram;
    @NotNull
    private final CounterMetric numPacketsWithoutTimestamps;

    public PrometheusPacketDelayStats(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        double[] dArray = new double[]{0.0, 5.0, 50.0, 500.0};
        this.histogram = VideobridgeMetricsContainer.Companion.getInstance().registerHistogram(name, "Packet delay stats for " + name, dArray);
        this.numPacketsWithoutTimestamps = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), name + "_unknown_delay", "Number of packets without an unknown delay (" + name + ")", 0L, null, 12, null);
    }

    public final void addUnknown() {
        CounterMetric.inc$default(this.numPacketsWithoutTimestamps, null, 1, null);
    }

    public final void addDelay(long delayMs) {
        this.histogram.getHistogram().observe(delayMs);
    }
}

