/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.ServerLogger;
import gov.nist.core.StackLogger;
import gov.nist.core.ThreadAuditor;
import gov.nist.core.net.AddressResolver;
import gov.nist.core.net.DefaultNetworkLayer;
import gov.nist.core.net.NetworkLayer;
import gov.nist.core.net.SecurityManagerProvider;
import gov.nist.javax.sip.DefaultAddressResolver;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.LogRecordFactory;
import gov.nist.javax.sip.ReleaseReferencesStrategy;
import gov.nist.javax.sip.SipListenerExt;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.extensions.JoinHeader;
import gov.nist.javax.sip.header.extensions.ReplacesHeader;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.MessageParserFactory;
import gov.nist.javax.sip.stack.ClientAuthType;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageProcessor;
import gov.nist.javax.sip.stack.DefaultRouter;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.MessageProcessorFactory;
import gov.nist.javax.sip.stack.NioMessageProcessorFactory;
import gov.nist.javax.sip.stack.NioTcpMessageChannel;
import gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import gov.nist.javax.sip.stack.NioTlsMessageChannel;
import gov.nist.javax.sip.stack.NioTlsMessageProcessor;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPClientTransactionImpl;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPDialogErrorEvent;
import gov.nist.javax.sip.stack.SIPDialogEventListener;
import gov.nist.javax.sip.stack.SIPEventInterceptor;
import gov.nist.javax.sip.stack.SIPMessageValve;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPServerTransactionImpl;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.SocketTimeoutAuditor;
import gov.nist.javax.sip.stack.StackMessageFactory;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageProcessor;
import gov.nist.javax.sip.stack.timers.SipTimer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Hop;
import javax.sip.address.Router;
import javax.sip.header.CallIdHeader;
import javax.sip.message.Request;

public abstract class SIPTransactionStack
implements SIPTransactionEventListener,
SIPDialogEventListener {
    private static StackLogger logger = CommonLogger.getLogger(SIPTransactionStack.class);
    public static final int BASE_TIMER_INTERVAL = 500;
    private static int connectionLingerTimer = 8;
    protected int earlyDialogTimeout = 180;
    protected ConcurrentHashMap<String, SIPServerTransaction> retransmissionAlertTransactions;
    protected ConcurrentHashMap<String, SIPDialog> earlyDialogTable;
    protected ConcurrentHashMap<String, SIPDialog> dialogTable;
    protected ConcurrentHashMap<String, SIPDialog> serverDialogMergeTestTable;
    protected static final Set<String> dialogCreatingMethods = new HashSet<String>();
    private SipTimer timer;
    private ConcurrentHashMap<String, SIPServerTransaction> pendingTransactions;
    protected ConcurrentHashMap<String, SIPClientTransaction> clientTransactionTable;
    protected boolean unlimitedServerTransactionTableSize = true;
    protected boolean unlimitedClientTransactionTableSize = true;
    protected int serverTransactionTableHighwaterMark = 5000;
    protected int serverTransactionTableLowaterMark = 4000;
    protected int clientTransactionTableHiwaterMark = 1000;
    protected int clientTransactionTableLowaterMark = 800;
    private AtomicInteger activeClientTransactionCount = new AtomicInteger(0);
    protected ConcurrentHashMap<String, SIPServerTransaction> serverTransactionTable;
    private ConcurrentHashMap<String, SIPServerTransaction> mergeTable;
    private ConcurrentHashMap<String, SIPServerTransaction> terminatedServerTransactionsPendingAck;
    private ConcurrentHashMap<String, SIPClientTransaction> forkedClientTransactionTable;
    protected boolean deliverRetransmittedAckToListener = false;
    protected ServerLogger serverLogger;
    boolean udpFlag;
    protected DefaultRouter defaultRouter;
    protected boolean needsLogging;
    private boolean non2XXAckPassedToListener;
    protected IOHandler ioHandler;
    protected boolean toExit = false;
    protected String stackName;
    protected String stackAddress;
    protected InetAddress stackInetAddress;
    protected StackMessageFactory sipMessageFactory;
    protected Router router;
    protected int threadPoolSize = -1;
    protected int maxConnections = -1;
    protected boolean cacheServerConnections = true;
    protected boolean cacheClientConnections = true;
    protected boolean useRouterForAll;
    protected int maxContentLength;
    protected int maxMessageSize;
    private Collection<MessageProcessor> messageProcessors;
    protected int readTimeout = -1;
    protected NetworkLayer networkLayer;
    protected String outboundProxy;
    protected String routerPath;
    protected boolean isAutomaticDialogSupportEnabled;
    protected HashSet<String> forkedEvents;
    protected boolean generateTimeStampHeader;
    protected AddressResolver addressResolver;
    protected int maxListenerResponseTime = -1;
    protected int maxTxLifetimeInvite;
    protected int maxTxLifetimeNonInvite;
    protected boolean rfc2543Supported = true;
    protected ThreadAuditor threadAuditor = null;
    protected LogRecordFactory logRecordFactory;
    protected boolean cancelClientTransactionChecked = true;
    protected boolean remoteTagReassignmentAllowed = true;
    protected boolean logStackTraceOnMessageSend = true;
    protected int receiveUdpBufferSize;
    protected int sendUdpBufferSize;
    private int stackCongestionControlTimeout = 0;
    protected boolean isBackToBackUserAgent = false;
    protected boolean checkBranchId;
    protected boolean isAutomaticDialogErrorHandlingEnabled = true;
    protected boolean isDialogTerminatedEventDeliveredForNullDialog = false;
    protected int maxForkTime = 0;
    private boolean deliverUnsolicitedNotify = false;
    private boolean deliverTerminatedEventForAck = false;
    protected boolean patchWebSocketHeaders = false;
    protected boolean patchRport = false;
    protected ClientAuthType clientAuth = ClientAuthType.Default;
    private int tcpPostParsingThreadPoolSize = 0;
    protected long minKeepAliveInterval = -1L;
    protected int dialogTimeoutFactor = 64;
    public MessageParserFactory messageParserFactory;
    public MessageProcessorFactory messageProcessorFactory;
    public long nioSocketMaxIdleTime;
    private ReleaseReferencesStrategy releaseReferencesStrategy = ReleaseReferencesStrategy.None;
    public SIPMessageValve sipMessageValve;
    public SIPEventInterceptor sipEventInterceptor;
    protected static Executor selfRoutingThreadpoolExecutor;
    private int threadPriority = 10;
    protected SecurityManagerProvider securityManagerProvider;
    protected int reliableConnectionKeepAliveTimeout = -1;
    private long sslHandshakeTimeout = -1L;
    private boolean sslRenegotiationEnabled = false;
    protected SocketTimeoutAuditor socketTimeoutAuditor = null;
    private ExecutorService reinviteExecutor = Executors.newCachedThreadPool(new ThreadFactory(){
        private int threadCount = 0;

        @Override
        public Thread newThread(Runnable pRunnable) {
            return new Thread(pRunnable, String.format("%s-%d", "ReInviteSender", this.threadCount++));
        }
    });

    public Executor getSelfRoutingThreadpoolExecutor() {
        if (selfRoutingThreadpoolExecutor == null) {
            selfRoutingThreadpoolExecutor = this.threadPoolSize <= 0 ? new SameThreadExecutor() : Executors.newFixedThreadPool(this.threadPoolSize, new ThreadFactory(){
                private int threadCount = 0;

                @Override
                public Thread newThread(Runnable pRunnable) {
                    Thread thread2 = new Thread(pRunnable, String.format("%s-%d", "SelfRoutingThread", this.threadCount++));
                    thread2.setPriority(SIPTransactionStack.this.threadPriority);
                    return thread2;
                }
            });
        }
        return selfRoutingThreadpoolExecutor;
    }

    protected SIPTransactionStack() {
        this.forkedEvents = new HashSet();
        this.messageProcessors = new CopyOnWriteArrayList<MessageProcessor>();
        this.ioHandler = new IOHandler(this);
        this.addressResolver = new DefaultAddressResolver();
        this.dialogTable = new ConcurrentHashMap();
        this.earlyDialogTable = new ConcurrentHashMap();
        this.serverDialogMergeTestTable = new ConcurrentHashMap();
        this.clientTransactionTable = new ConcurrentHashMap();
        this.serverTransactionTable = new ConcurrentHashMap();
        this.terminatedServerTransactionsPendingAck = new ConcurrentHashMap();
        this.mergeTable = new ConcurrentHashMap();
        this.retransmissionAlertTransactions = new ConcurrentHashMap();
        this.pendingTransactions = new ConcurrentHashMap();
        this.forkedClientTransactionTable = new ConcurrentHashMap();
    }

    protected void reInit() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Re-initializing !");
        }
        this.messageProcessors = new CopyOnWriteArrayList<MessageProcessor>();
        this.ioHandler = new IOHandler(this);
        this.pendingTransactions = new ConcurrentHashMap();
        this.clientTransactionTable = new ConcurrentHashMap();
        this.serverTransactionTable = new ConcurrentHashMap();
        this.retransmissionAlertTransactions = new ConcurrentHashMap();
        this.mergeTable = new ConcurrentHashMap();
        this.dialogTable = new ConcurrentHashMap();
        this.earlyDialogTable = new ConcurrentHashMap();
        this.serverDialogMergeTestTable = new ConcurrentHashMap();
        this.terminatedServerTransactionsPendingAck = new ConcurrentHashMap();
        this.forkedClientTransactionTable = new ConcurrentHashMap();
        this.activeClientTransactionCount = new AtomicInteger(0);
    }

    public SocketAddress getLocalAddressForTcpDst(InetAddress dst, int dstPort, InetAddress localAddress, int localPort) throws IOException {
        if (this.getMessageProcessorFactory() instanceof NioMessageProcessorFactory) {
            MessageProcessor[] processors;
            for (MessageProcessor processor : processors = this.getMessageProcessors()) {
                if (!"TCP".equals(processor.getTransport())) continue;
                NioTcpMessageChannel msgChannel = (NioTcpMessageChannel)processor.createMessageChannel(dst, dstPort);
                return msgChannel.socketChannel.socket().getLocalSocketAddress();
            }
            return null;
        }
        return this.ioHandler.getLocalAddressForTcpDst(dst, dstPort, localAddress, localPort);
    }

    public SocketAddress getLocalAddressForTlsDst(InetAddress dst, int dstPort, InetAddress localAddress) throws IOException {
        MessageProcessor[] processors;
        for (MessageProcessor processor : processors = this.getMessageProcessors()) {
            if (processor instanceof TLSMessageProcessor) {
                TLSMessageChannel msgChannel = (TLSMessageChannel)processor.createMessageChannel(dst, dstPort);
                return this.ioHandler.getLocalAddressForTlsDst(dst, dstPort, localAddress, msgChannel);
            }
            if (!(processor instanceof NioTlsMessageProcessor)) continue;
            NioTlsMessageChannel msgChannel = (NioTlsMessageChannel)processor.createMessageChannel(dst, dstPort);
            return msgChannel.socketChannel.socket().getLocalSocketAddress();
        }
        return null;
    }

    public void disableLogging() {
        logger.disableLogging();
    }

    public void enableLogging() {
        logger.enableLogging();
    }

    public void printDialogTable() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("dialog table  = " + this.dialogTable);
        }
    }

    public SIPServerTransaction getRetransmissionAlertTransaction(String dialogId) {
        return this.retransmissionAlertTransactions.get(dialogId);
    }

    public static boolean isDialogCreated(String method) {
        return dialogCreatingMethods.contains(method);
    }

    public void addExtensionMethod(String extensionMethod) {
        if (extensionMethod.equals("NOTIFY")) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("NOTIFY Supported Natively");
            }
        } else {
            dialogCreatingMethods.add(Utils.toUpperCase(extensionMethod.trim()));
        }
    }

    public SIPDialog putDialog(SIPDialog dialog) {
        String dialogId = dialog.getDialogId();
        if (this.dialogTable.containsKey(dialogId)) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("putDialog: dialog already exists" + dialogId + " in table = " + this.dialogTable.get(dialogId));
            }
            return this.dialogTable.get(dialogId);
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("putDialog dialogId=" + dialogId + " dialog = " + dialog);
        }
        dialog.setStack(this);
        if (logger.isLoggingEnabled(32)) {
            logger.logStackTrace();
        }
        this.dialogTable.put(dialogId, dialog);
        this.putMergeDialog(dialog);
        return dialog;
    }

    public SIPDialog createDialog(SIPTransaction transaction) {
        SIPDialog retval = null;
        if (transaction instanceof SIPClientTransaction) {
            String dialogId = ((SIPRequest)transaction.getRequest()).getDialogId(false);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("createDialog dialogId=" + dialogId);
            }
            if (this.earlyDialogTable.get(dialogId) != null) {
                SIPDialog dialog = this.earlyDialogTable.get(dialogId);
                if (dialog.getState() == null || dialog.getState() == DialogState.EARLY) {
                    retval = dialog;
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("createDialog early Dialog found : earlyDialogId=" + dialogId + " earlyDialog= " + dialog);
                    }
                } else {
                    retval = new SIPDialog(transaction);
                    this.earlyDialogTable.put(dialogId, retval);
                }
            } else {
                retval = new SIPDialog(transaction);
                this.earlyDialogTable.put(dialogId, retval);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("createDialog early Dialog not found : earlyDialogId=" + dialogId + " created one " + retval);
                }
            }
        } else {
            retval = new SIPDialog(transaction);
        }
        return retval;
    }

    public SIPDialog createDialog(SIPClientTransaction transaction, SIPResponse sipResponse) {
        String originalDialogId = ((SIPRequest)transaction.getRequest()).getDialogId(false);
        String earlyDialogId = sipResponse.getDialogId(false);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("createDialog originalDialogId=" + originalDialogId);
            logger.logDebug("createDialog earlyDialogId=" + earlyDialogId);
            logger.logDebug("createDialog default Dialog=" + transaction.getDefaultDialog());
            if (transaction.getDefaultDialog() != null) {
                logger.logDebug("createDialog default Dialog Id=" + transaction.getDefaultDialog().getDialogId());
            }
        }
        SIPDialog retval = null;
        SIPDialog earlyDialog = this.earlyDialogTable.get(originalDialogId);
        if (earlyDialog != null && transaction != null && (transaction.getDefaultDialog() == null || transaction.getDefaultDialog().getDialogId().equals(originalDialogId))) {
            retval = earlyDialog;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("createDialog early Dialog found : earlyDialogId=" + originalDialogId + " earlyDialog= " + retval);
            }
            if (sipResponse.isFinalResponse()) {
                this.earlyDialogTable.remove(originalDialogId);
            }
        } else {
            retval = new SIPDialog(transaction, sipResponse);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("createDialog early Dialog not found : earlyDialogId=" + earlyDialogId + " created one " + retval);
            }
        }
        return retval;
    }

    public SIPDialog createDialog(SipProviderImpl sipProvider, SIPResponse sipResponse) {
        return new SIPDialog(sipProvider, sipResponse);
    }

    public SIPDialog createDialog(SIPClientTransaction subscribeTx, SIPTransaction notifyST) {
        return new SIPDialog(subscribeTx, notifyST);
    }

    public void removeDialog(SIPDialog dialog) {
        String id = dialog.getDialogId();
        String earlyId = dialog.getEarlyDialogId();
        if (earlyId != null) {
            this.earlyDialogTable.remove(earlyId);
            this.dialogTable.remove(earlyId);
        }
        this.removeMergeDialog(dialog.getMergeId());
        if (id != null) {
            SIPDialog old = this.dialogTable.get(id);
            if (old == dialog) {
                this.dialogTable.remove(id);
            }
            if (!dialog.testAndSetIsDialogTerminatedEventDelivered()) {
                DialogTerminatedEvent event = new DialogTerminatedEvent((Object)dialog.getSipProvider(), (Dialog)dialog);
                dialog.getSipProvider().handleEvent((EventObject)event, null);
            }
        } else if (this.isDialogTerminatedEventDeliveredForNullDialog && !dialog.testAndSetIsDialogTerminatedEventDelivered()) {
            DialogTerminatedEvent event = new DialogTerminatedEvent((Object)dialog.getSipProvider(), (Dialog)dialog);
            dialog.getSipProvider().handleEvent((EventObject)event, null);
        }
    }

    public SIPDialog getEarlyDialog(String dialogId) {
        SIPDialog sipDialog = this.earlyDialogTable.get(dialogId);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("getEarlyDialog(" + dialogId + ") : returning " + sipDialog);
        }
        return sipDialog;
    }

    protected void removeMergeDialog(String mergeId) {
        if (mergeId != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Tyring to remove Dialog from serverDialogMerge table with Merge Dialog Id " + mergeId);
            }
            SIPDialog sipDialog = this.serverDialogMergeTestTable.remove(mergeId);
            if (logger.isLoggingEnabled(32) && sipDialog != null) {
                logger.logDebug("removed Dialog " + sipDialog + " from serverDialogMerge table with Merge Dialog Id " + mergeId);
            }
        }
    }

    protected void putMergeDialog(SIPDialog sipDialog) {
        String mergeId;
        if (sipDialog != null && (mergeId = sipDialog.getMergeId()) != null) {
            this.serverDialogMergeTestTable.put(mergeId, sipDialog);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("put Dialog " + sipDialog + " in serverDialogMerge table with Merge Dialog Id " + mergeId);
            }
        }
    }

    public SIPDialog getDialog(String dialogId) {
        SIPDialog sipDialog = this.dialogTable.get(dialogId);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("getDialog(" + dialogId + ") : returning " + sipDialog);
        }
        return sipDialog;
    }

    public void removeDialog(String dialogId) {
        if (logger.isLoggingEnabled()) {
            logger.logWarning("Silently removing dialog from table");
        }
        this.dialogTable.remove(dialogId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SIPClientTransaction findSubscribeTransaction(SIPRequest notifyMessage, ListeningPointImpl listeningPoint) {
        retval = null;
        try {
            it = this.clientTransactionTable.values().iterator();
            if (SIPTransactionStack.logger.isLoggingEnabled(32)) {
                SIPTransactionStack.logger.logDebug("ct table size = " + this.clientTransactionTable.size());
            }
            if ((thisToTag = notifyMessage.getTo().getTag()) == null) {
                var6_6 = retval;
                if (SIPTransactionStack.logger.isLoggingEnabled(32)) {
                    SIPTransactionStack.logger.logDebug("findSubscribeTransaction : returning " + retval);
                }
                return var6_6;
            }
        }
        catch (Throwable var11_13) {
            if (SIPTransactionStack.logger.isLoggingEnabled(32)) {
                SIPTransactionStack.logger.logDebug("findSubscribeTransaction : returning " + retval);
            }
            throw var11_13;
        }
        {
            eventHdr = (Event)notifyMessage.getHeader("Event");
            if (eventHdr != null) ** GOTO lbl-1000
            if (SIPTransactionStack.logger.isLoggingEnabled(32)) {
                SIPTransactionStack.logger.logDebug("event Header is null -- returning null");
            }
            var7_8 = retval;
            if (SIPTransactionStack.logger.isLoggingEnabled(32)) {
                SIPTransactionStack.logger.logDebug("findSubscribeTransaction : returning " + retval);
            }
            return var7_8;
        }
lbl-1000:
        // 4 sources

        {
            while (it.hasNext()) {
                ct = it.next();
                if (!ct.getMethod().equals("SUBSCRIBE")) continue;
                fromTag = ct.getOriginalRequestFromTag();
                hisEvent = ct.getOriginalRequestEvent();
                if (hisEvent == null) continue;
                if (SIPTransactionStack.logger.isLoggingEnabled(32)) {
                    SIPTransactionStack.logger.logDebug("ct.fromTag = " + fromTag);
                    SIPTransactionStack.logger.logDebug("thisToTag = " + thisToTag);
                    SIPTransactionStack.logger.logDebug("hisEvent = " + hisEvent);
                    SIPTransactionStack.logger.logDebug("eventHdr " + eventHdr);
                }
                if (!fromTag.equalsIgnoreCase(thisToTag) || hisEvent == null || !eventHdr.match(hisEvent) || !notifyMessage.getCallId().getCallId().equalsIgnoreCase(ct.getOriginalRequestCallId())) continue;
                if (!this.isDeliverUnsolicitedNotify()) {
                    ct.acquireSem();
                }
                retval = ct;
                var10_12 = ct;
                if (SIPTransactionStack.logger.isLoggingEnabled(32)) {
                    SIPTransactionStack.logger.logDebug("findSubscribeTransaction : returning " + retval);
                }
                return var10_12;
            }
        }
        {
            var7_9 = retval;
            if (SIPTransactionStack.logger.isLoggingEnabled(32)) {
                SIPTransactionStack.logger.logDebug("findSubscribeTransaction : returning " + retval);
            }
            return var7_9;
        }
    }

    public void addTransactionPendingAck(SIPServerTransaction serverTransaction) {
        String branchId = ((SIPRequest)serverTransaction.getRequest()).getTopmostVia().getBranch();
        if (branchId != null) {
            this.terminatedServerTransactionsPendingAck.put(branchId, serverTransaction);
        }
    }

    public SIPServerTransaction findTransactionPendingAck(SIPRequest ackMessage) {
        return this.terminatedServerTransactionsPendingAck.get(ackMessage.getTopmostVia().getBranch());
    }

    public boolean removeTransactionPendingAck(SIPServerTransaction serverTransaction) {
        String branchId = serverTransaction.getBranchId();
        if (branchId != null && this.terminatedServerTransactionsPendingAck.containsKey(branchId)) {
            this.terminatedServerTransactionsPendingAck.remove(branchId);
            return true;
        }
        return false;
    }

    public boolean isTransactionPendingAck(SIPServerTransaction serverTransaction) {
        String branchId = ((SIPRequest)serverTransaction.getRequest()).getTopmostVia().getBranch();
        return this.terminatedServerTransactionsPendingAck.contains(branchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SIPTransaction findTransaction(SIPMessage sipMessage, boolean isServer) {
        block13: {
            retval = null;
            try {
                if (isServer) {
                    via = sipMessage.getTopmostVia();
                    if (via.getBranch() != null) {
                        key = sipMessage.getTransactionId();
                        retval = this.serverTransactionTable.get(key);
                        if (SIPTransactionStack.logger.isLoggingEnabled(32)) {
                            SIPTransactionStack.logger.logDebug("serverTx: looking for key " + key + " existing=" + this.serverTransactionTable);
                        }
                        if (key.startsWith("z9hg4bk")) {
                            var6_8 = retval;
                            if (SIPTransactionStack.logger.isLoggingEnabled(32) == false) return var6_8;
                            SIPTransactionStack.logger.logDebug("findTransaction: returning  : " + retval);
                            return var6_8;
                        }
                    }
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var8_14) {
                if (SIPTransactionStack.logger.isLoggingEnabled(32) == false) throw var8_14;
                SIPTransactionStack.logger.logDebug("findTransaction: returning  : " + retval);
                throw var8_14;
            }
            {
                for (SIPServerTransaction sipServerTransaction : this.serverTransactionTable.values()) {
                    if (!sipServerTransaction.isMessagePartOfTransaction(sipMessage)) continue;
                    var7_12 = retval = sipServerTransaction;
                    if (SIPTransactionStack.logger.isLoggingEnabled(32) == false) return var7_12;
                    SIPTransactionStack.logger.logDebug("findTransaction: returning  : " + retval);
                    return var7_12;
                }
                break block13;
            }
lbl-1000:
            // 1 sources

            {
                via = sipMessage.getTopmostVia();
                if (via.getBranch() == null) ** GOTO lbl-1000
                key = sipMessage.getTransactionId();
                if (SIPTransactionStack.logger.isLoggingEnabled(32)) {
                    SIPTransactionStack.logger.logDebug("clientTx: looking for key " + key);
                }
                retval = this.clientTransactionTable.get(key);
                if (!key.startsWith("z9hg4bk")) ** GOTO lbl-1000
                sipServerTransaction = retval;
                if (SIPTransactionStack.logger.isLoggingEnabled(32) == false) return sipServerTransaction;
                SIPTransactionStack.logger.logDebug("findTransaction: returning  : " + retval);
                return sipServerTransaction;
            }
lbl-1000:
            // 3 sources

            {
                for (SIPClientTransaction clientTransaction : this.clientTransactionTable.values()) {
                    if (!clientTransaction.isMessagePartOfTransaction(sipMessage)) continue;
                    var7_13 = retval = clientTransaction;
                    if (SIPTransactionStack.logger.isLoggingEnabled(32) == false) return var7_13;
                    SIPTransactionStack.logger.logDebug("findTransaction: returning  : " + retval);
                    return var7_13;
                }
            }
        }
        if (SIPTransactionStack.logger.isLoggingEnabled(32) == false) return retval;
        SIPTransactionStack.logger.logDebug("findTransaction: returning  : " + retval);
        return retval;
    }

    public SIPTransaction findTransaction(String transactionId, boolean isServer) {
        if (isServer) {
            return this.serverTransactionTable.get(transactionId);
        }
        return this.clientTransactionTable.get(transactionId);
    }

    public SIPTransaction findCancelTransaction(SIPRequest cancelRequest, boolean isServer) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("findCancelTransaction request= \n" + cancelRequest + "\nfindCancelRequest isServer=" + isServer);
        }
        if (isServer) {
            for (SIPTransaction sIPTransaction : this.serverTransactionTable.values()) {
                SIPServerTransaction sipServerTransaction = (SIPServerTransaction)sIPTransaction;
                if (!sipServerTransaction.doesCancelMatchTransaction(cancelRequest)) continue;
                return sipServerTransaction;
            }
        } else {
            for (SIPTransaction sIPTransaction : this.clientTransactionTable.values()) {
                SIPClientTransaction sipClientTransaction = (SIPClientTransaction)sIPTransaction;
                if (!sipClientTransaction.doesCancelMatchTransaction(cancelRequest)) continue;
                return sipClientTransaction;
            }
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Could not find transaction for cancel request");
        }
        return null;
    }

    protected SIPTransactionStack(StackMessageFactory messageFactory) {
        this();
        this.sipMessageFactory = messageFactory;
    }

    public SIPServerTransaction findPendingTransaction(String transactionId) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("looking for pending tx for :" + transactionId);
        }
        return this.pendingTransactions.get(transactionId);
    }

    public boolean findMergedTransaction(SIPRequest sipRequest) {
        if (!sipRequest.getMethod().equals("INVITE")) {
            return false;
        }
        String mergeId = sipRequest.getMergeId();
        if (mergeId != null) {
            SIPServerTransaction mergedTransaction = this.mergeTable.get(mergeId);
            if (mergedTransaction != null && !mergedTransaction.isMessagePartOfTransaction(sipRequest)) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Mathcing merged transaction for merge id " + mergeId + " with " + mergedTransaction);
                }
                return true;
            }
            SIPDialog serverDialog = this.serverDialogMergeTestTable.get(mergeId);
            if (serverDialog != null && serverDialog.firstTransactionIsServerTransaction && serverDialog.getState() == DialogState.CONFIRMED) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Mathcing merged dialog for merge id " + mergeId + " with " + serverDialog);
                }
                return true;
            }
        }
        return false;
    }

    public void removePendingTransaction(SIPServerTransaction tr) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("removePendingTx: " + tr.getTransactionId());
        }
        this.pendingTransactions.remove(tr.getTransactionId());
    }

    public void removeFromMergeTable(SIPServerTransaction tr) {
        String key;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Removing tx from merge table ");
        }
        if ((key = tr.getMergeId()) != null) {
            this.mergeTable.remove(key);
        }
    }

    public void putInMergeTable(SIPServerTransaction sipTransaction, SIPRequest sipRequest) {
        String mergeKey = sipRequest.getMergeId();
        if (mergeKey != null) {
            this.mergeTable.put(mergeKey, sipTransaction);
        }
    }

    public void mapTransaction(SIPServerTransaction transaction) {
        if (transaction.isTransactionMapped()) {
            return;
        }
        this.addTransactionHash(transaction);
        transaction.setTransactionMapped(true);
    }

    public ServerRequestInterface newSIPServerRequest(SIPRequest requestReceived, MessageChannel requestMessageChannel) {
        SIPServerTransaction currentTransaction;
        String key = requestReceived.getTransactionId();
        requestReceived.setMessageChannel(requestMessageChannel);
        if (this.sipMessageValve != null) {
            try {
                if (!this.sipMessageValve.processRequest(requestReceived, requestMessageChannel)) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Request dropped by the SIP message valve. Request = " + requestReceived);
                    }
                    return null;
                }
            }
            catch (Exception e) {
                if (logger.isLoggingEnabled(4)) {
                    logger.logError("An issue happening the valve on request " + requestReceived + " thus the message will not be processed further", e);
                }
                return null;
            }
        }
        if ((currentTransaction = (SIPServerTransaction)this.findTransaction(key, true)) == null || !currentTransaction.isMessagePartOfTransaction(requestReceived)) {
            currentTransaction = null;
            if (!key.toLowerCase().startsWith("z9hg4bk")) {
                Iterator<SIPServerTransaction> transactionIterator = this.serverTransactionTable.values().iterator();
                while (transactionIterator.hasNext() && currentTransaction == null) {
                    SIPServerTransaction nextTransaction = transactionIterator.next();
                    if (!nextTransaction.isMessagePartOfTransaction(requestReceived)) continue;
                    currentTransaction = nextTransaction;
                }
            }
            if (currentTransaction == null) {
                currentTransaction = this.findPendingTransaction(key);
                if (currentTransaction != null) {
                    requestReceived.setTransaction(currentTransaction);
                    if (currentTransaction.acquireSem()) {
                        return currentTransaction;
                    }
                    return null;
                }
                currentTransaction = this.createServerTransaction(requestMessageChannel);
                if (currentTransaction != null) {
                    currentTransaction.setOriginalRequest(requestReceived);
                    requestReceived.setTransaction(currentTransaction);
                }
            }
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("newSIPServerRequest( " + requestReceived.getMethod() + ":" + requestReceived.getTopmostVia().getBranch() + "):" + currentTransaction);
        }
        if (currentTransaction != null) {
            currentTransaction.setRequestInterface(this.sipMessageFactory.newSIPServerRequest(requestReceived, currentTransaction));
        }
        if (currentTransaction != null && currentTransaction.acquireSem()) {
            return currentTransaction;
        }
        if (currentTransaction != null) {
            block20: {
                try {
                    if (currentTransaction.isMessagePartOfTransaction(requestReceived) && currentTransaction.getMethod().equals(requestReceived.getMethod())) {
                        SIPResponse trying = requestReceived.createResponse(100);
                        trying.removeContent();
                        currentTransaction.getMessageChannel().sendMessage(trying);
                    }
                }
                catch (Exception ex) {
                    if (!logger.isLoggingEnabled()) break block20;
                    logger.logError("Exception occured sending TRYING");
                }
            }
            return null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerResponseInterface newSIPServerResponse(SIPResponse responseReceived, MessageChannel responseMessageChannel) {
        boolean acquired;
        SIPClientTransaction currentTransaction;
        block17: {
            String key;
            if (this.sipMessageValve != null) {
                try {
                    if (!this.sipMessageValve.processResponse(responseReceived, responseMessageChannel)) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Response dropped by the SIP message valve. Response = " + responseReceived);
                        }
                        return null;
                    }
                }
                catch (Exception e) {
                    if (logger.isLoggingEnabled(4)) {
                        logger.logError("An issue happening the valve on response " + responseReceived + " thus the message will not be processed further", e);
                    }
                    return null;
                }
            }
            if ((currentTransaction = (SIPClientTransaction)this.findTransaction(key = responseReceived.getTransactionId(), false)) == null || !currentTransaction.isMessagePartOfTransaction(responseReceived) && !key.startsWith("z9hg4bk")) {
                Iterator<SIPClientTransaction> transactionIterator = this.clientTransactionTable.values().iterator();
                currentTransaction = null;
                while (transactionIterator.hasNext() && currentTransaction == null) {
                    SIPClientTransaction nextTransaction = transactionIterator.next();
                    if (!nextTransaction.isMessagePartOfTransaction(responseReceived)) continue;
                    currentTransaction = nextTransaction;
                }
                if (currentTransaction == null) {
                    if (logger.isLoggingEnabled(16)) {
                        responseMessageChannel.logResponse(responseReceived, System.currentTimeMillis(), "before processing");
                    }
                    return this.sipMessageFactory.newSIPServerResponse(responseReceived, responseMessageChannel);
                }
            }
            acquired = currentTransaction.acquireSem();
            if (logger.isLoggingEnabled(16)) {
                currentTransaction.getMessageChannel().logResponse(responseReceived, System.currentTimeMillis(), "before processing");
            }
            if (acquired) {
                ServerResponseInterface sri = this.sipMessageFactory.newSIPServerResponse(responseReceived, currentTransaction.getMessageChannel());
                if (sri != null) {
                    currentTransaction.setResponseInterface(sri);
                    break block17;
                } else {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("returning null - serverResponseInterface is null!");
                    }
                    currentTransaction.releaseSem();
                    return null;
                }
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Could not aquire semaphore !!");
            }
        }
        if (acquired) {
            return currentTransaction;
        }
        return null;
    }

    public MessageChannel createMessageChannel(SIPRequest request, MessageProcessor mp, Hop nextHop) throws IOException {
        Host targetHost = new Host();
        targetHost.setHostname(nextHop.getHost());
        HostPort targetHostPort = new HostPort();
        targetHostPort.setHost(targetHost);
        targetHostPort.setPort(nextHop.getPort());
        MessageChannel returnChannel = mp.createMessageChannel(targetHostPort);
        return returnChannel;
    }

    public SIPClientTransaction createClientTransaction(SIPRequest sipRequest, MessageChannel encapsulatedMessageChannel) {
        SIPClientTransactionImpl ct = new SIPClientTransactionImpl(this, encapsulatedMessageChannel);
        ct.setOriginalRequest(sipRequest);
        return ct;
    }

    public SIPServerTransaction createServerTransaction(MessageChannel encapsulatedMessageChannel) {
        boolean decision;
        if (this.unlimitedServerTransactionTableSize) {
            return new SIPServerTransactionImpl(this, encapsulatedMessageChannel);
        }
        float threshold = (float)(this.serverTransactionTable.size() - this.serverTransactionTableLowaterMark) / (float)(this.serverTransactionTableHighwaterMark - this.serverTransactionTableLowaterMark);
        boolean bl = decision = Math.random() > 1.0 - (double)threshold;
        if (decision) {
            return null;
        }
        return new SIPServerTransactionImpl(this, encapsulatedMessageChannel);
    }

    public int getClientTransactionTableSize() {
        return this.clientTransactionTable.size();
    }

    public int getServerTransactionTableSize() {
        return this.serverTransactionTable.size();
    }

    public void addTransaction(SIPClientTransaction clientTransaction) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("added transaction " + clientTransaction);
        }
        this.addTransactionHash(clientTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeTransaction(SIPTransaction sipTransaction) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("removeTransaction: Removing Transaction = " + sipTransaction.getTransactionId() + " transaction = " + sipTransaction);
        }
        SIPTransaction removed = null;
        try {
            if (sipTransaction instanceof SIPServerTransaction) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logStackTrace();
                }
                String key = sipTransaction.getTransactionId();
                removed = this.serverTransactionTable.remove(key);
                String method = sipTransaction.getMethod();
                this.removePendingTransaction((SIPServerTransaction)sipTransaction);
                this.removeTransactionPendingAck((SIPServerTransaction)sipTransaction);
                if (method.equalsIgnoreCase("INVITE")) {
                    this.removeFromMergeTable((SIPServerTransaction)sipTransaction);
                }
                SipProviderImpl sipProvider = sipTransaction.getSipProvider();
                if (removed != null && sipTransaction.testAndSetTransactionTerminatedEvent()) {
                    TransactionTerminatedEvent event = new TransactionTerminatedEvent((Object)sipProvider, (ServerTransaction)sipTransaction);
                    sipProvider.handleEvent((EventObject)event, sipTransaction);
                }
            } else {
                SIPTransaction clientTx;
                String forkId;
                String key = sipTransaction.getTransactionId();
                removed = this.clientTransactionTable.remove(key);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("REMOVED client tx " + removed + " KEY = " + key);
                }
                if (removed != null && (forkId = (clientTx = removed).getForkId()) != null && clientTx.isInviteTransaction() && this.maxForkTime != 0) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Scheduling to remove forked client transaction : forkId = " + forkId + " in " + this.maxForkTime + " seconds");
                    }
                    this.timer.schedule(new RemoveForkedTransactionTimerTask(forkId), this.maxForkTime * 1000);
                    clientTx.stopExpiresTimer();
                }
                if (removed != null && sipTransaction.testAndSetTransactionTerminatedEvent()) {
                    SipProviderImpl sipProvider = sipTransaction.getSipProvider();
                    TransactionTerminatedEvent event = new TransactionTerminatedEvent((Object)sipProvider, (ClientTransaction)sipTransaction);
                    sipProvider.handleEvent((EventObject)event, sipTransaction);
                }
            }
            if (removed != null) {
                ((SIPTransaction)removed).cancelMaxTxLifeTimeTimer();
            }
            if (!logger.isLoggingEnabled(32)) return;
        }
        catch (Throwable throwable) {
            if (removed != null) {
                ((SIPTransaction)removed).cancelMaxTxLifeTimeTimer();
            }
            if (!logger.isLoggingEnabled(32)) throw throwable;
            logger.logDebug(String.format("removeTransaction: Table size :  clientTransactionTable %d  serverTransactionTable %d  mergetTable %d  terminatedServerTransactionsPendingAck %d   forkedClientTransactionTable %d  pendingTransactions %d ", this.clientTransactionTable.size(), this.serverTransactionTable.size(), this.mergeTable.size(), this.terminatedServerTransactionsPendingAck.size(), this.forkedClientTransactionTable.size(), this.pendingTransactions.size()));
            throw throwable;
        }
        logger.logDebug(String.format("removeTransaction: Table size :  clientTransactionTable %d  serverTransactionTable %d  mergetTable %d  terminatedServerTransactionsPendingAck %d   forkedClientTransactionTable %d  pendingTransactions %d ", this.clientTransactionTable.size(), this.serverTransactionTable.size(), this.mergeTable.size(), this.terminatedServerTransactionsPendingAck.size(), this.forkedClientTransactionTable.size(), this.pendingTransactions.size()));
    }

    public void addTransaction(SIPServerTransaction serverTransaction) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("added transaction " + serverTransaction);
        }
        serverTransaction.map();
        this.addTransactionHash(serverTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTransactionHash(SIPTransaction sipTransaction) {
        SIPRequest sipRequest = sipTransaction.getOriginalRequest();
        SIPTransaction existingTx = null;
        if (sipTransaction instanceof SIPClientTransaction) {
            if (!this.unlimitedClientTransactionTableSize) {
                if (this.activeClientTransactionCount.get() > this.clientTransactionTableHiwaterMark) {
                    try {
                        ConcurrentHashMap<String, SIPClientTransaction> concurrentHashMap = this.clientTransactionTable;
                        synchronized (concurrentHashMap) {
                            this.clientTransactionTable.wait();
                            this.activeClientTransactionCount.incrementAndGet();
                        }
                    }
                    catch (Exception ex) {
                        if (logger.isLoggingEnabled()) {
                            logger.logError("Exception occured while waiting for room", ex);
                        }
                    }
                }
            } else {
                this.activeClientTransactionCount.incrementAndGet();
            }
            String key = sipRequest.getTransactionId();
            existingTx = this.clientTransactionTable.putIfAbsent(key, (SIPClientTransaction)sipTransaction);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(" putTransactionHash :  key = " + key);
            }
        } else {
            String key = sipRequest.getTransactionId();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug(" putTransactionHash :  key = " + key);
            }
            existingTx = this.serverTransactionTable.putIfAbsent(key, (SIPServerTransaction)sipTransaction);
        }
        if (existingTx == null) {
            sipTransaction.scheduleMaxTxLifeTimeTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementActiveClientTransactionCount() {
        if (this.activeClientTransactionCount.decrementAndGet() <= this.clientTransactionTableLowaterMark && !this.unlimitedClientTransactionTableSize) {
            ConcurrentHashMap<String, SIPClientTransaction> concurrentHashMap = this.clientTransactionTable;
            synchronized (concurrentHashMap) {
                this.clientTransactionTable.notify();
            }
        }
    }

    protected void removeTransactionHash(SIPTransaction sipTransaction) {
        SIPRequest sipRequest = sipTransaction.getOriginalRequest();
        if (sipRequest == null) {
            return;
        }
        SIPTransaction removed = null;
        if (sipTransaction instanceof SIPClientTransaction) {
            String key = sipTransaction.getTransactionId();
            if (logger.isLoggingEnabled(32)) {
                logger.logStackTrace();
                logger.logDebug("removing client Tx : " + key);
            }
            removed = this.clientTransactionTable.remove(key);
        } else if (sipTransaction instanceof SIPServerTransaction) {
            String key = sipTransaction.getTransactionId();
            removed = this.serverTransactionTable.remove(key);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("removing server Tx : " + key);
            }
        }
        if (removed != null) {
            ((SIPTransaction)removed).cancelMaxTxLifeTimeTimer();
        }
    }

    @Override
    public synchronized void transactionErrorEvent(SIPTransactionErrorEvent transactionErrorEvent) {
        SIPTransaction transaction = (SIPTransaction)transactionErrorEvent.getSource();
        if (transactionErrorEvent.getErrorID() == 2) {
            transaction.setState(5);
            if (transaction instanceof SIPServerTransaction) {
                ((SIPServerTransaction)transaction).setCollectionTime(0);
            }
            transaction.disableTimeoutTimer();
            transaction.disableRetransmissionTimer();
        }
    }

    @Override
    public synchronized void dialogErrorEvent(SIPDialogErrorEvent dialogErrorEvent) {
        SIPDialog sipDialog = (SIPDialog)dialogErrorEvent.getSource();
        SipListener sipListener = ((SipStackImpl)this).getSipListener();
        if (sipDialog != null && !(sipListener instanceof SipListenerExt)) {
            sipDialog.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStack() {
        this.toExit = true;
        this.pendingTransactions.clear();
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this.clientTransactionTable;
        synchronized (object) {
            this.clientTransactionTable.notifyAll();
        }
        if (selfRoutingThreadpoolExecutor != null && selfRoutingThreadpoolExecutor instanceof ExecutorService) {
            ((ExecutorService)selfRoutingThreadpoolExecutor).shutdown();
        }
        selfRoutingThreadpoolExecutor = null;
        MessageProcessor[] processorList = this.getMessageProcessors();
        for (int processorIndex = 0; processorIndex < processorList.length; ++processorIndex) {
            this.removeMessageProcessor(processorList[processorIndex]);
        }
        this.closeAllSockets();
        if (this.timer != null) {
            this.timer.stop();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.clientTransactionTable.clear();
        this.serverTransactionTable.clear();
        this.dialogTable.clear();
        this.serverLogger.closeLogFile();
    }

    public void closeAllSockets() {
        this.ioHandler.closeAll();
        for (MessageProcessor p : this.messageProcessors) {
            if (!(p instanceof NioTcpMessageProcessor)) continue;
            NioTcpMessageProcessor niop = (NioTcpMessageProcessor)p;
            niop.nioHandler.closeAll();
        }
    }

    public void putPendingTransaction(SIPServerTransaction tr) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("putPendingTransaction: " + tr);
        }
        this.pendingTransactions.put(tr.getTransactionId(), tr);
    }

    public NetworkLayer getNetworkLayer() {
        if (this.networkLayer == null) {
            return DefaultNetworkLayer.SINGLETON;
        }
        return this.networkLayer;
    }

    @Deprecated
    public boolean isLoggingEnabled() {
        return logger == null ? false : logger.isLoggingEnabled();
    }

    @Deprecated
    public boolean isLoggingEnabled(int level) {
        return logger == null ? false : logger.isLoggingEnabled(level);
    }

    @Deprecated
    public StackLogger getStackLogger() {
        return logger;
    }

    public ServerLogger getServerLogger() {
        return this.serverLogger;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setSingleThreaded() {
        this.threadPoolSize = 1;
    }

    public int getTcpPostParsingThreadPoolSize() {
        return this.tcpPostParsingThreadPoolSize;
    }

    public void setTcpPostParsingThreadPoolSize(int tcpPostParsingThreadPoolSize) {
        this.tcpPostParsingThreadPoolSize = tcpPostParsingThreadPoolSize;
    }

    public void setThreadPoolSize(int size) {
        this.threadPoolSize = size;
    }

    public void setMaxConnections(int nconnections) {
        this.maxConnections = nconnections;
    }

    public Hop getNextHop(SIPRequest sipRequest) throws SipException {
        if (this.useRouterForAll) {
            if (this.router != null) {
                return this.router.getNextHop((Request)sipRequest);
            }
            return null;
        }
        if (sipRequest.getRequestURI().isSipURI() || sipRequest.getRouteHeaders() != null) {
            return this.defaultRouter.getNextHop(sipRequest);
        }
        if (this.router != null) {
            return this.router.getNextHop((Request)sipRequest);
        }
        return null;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    protected void setHostAddress(String stackAddress) throws UnknownHostException {
        this.stackAddress = stackAddress.indexOf(58) != stackAddress.lastIndexOf(58) && stackAddress.trim().charAt(0) != '[' ? '[' + stackAddress + ']' : stackAddress;
        this.stackInetAddress = InetAddress.getByName(stackAddress);
    }

    public String getHostAddress() {
        return this.stackAddress;
    }

    protected void setRouter(Router router) {
        this.router = router;
    }

    public Router getRouter(SIPRequest request) {
        if (request.getRequestLine() == null) {
            return this.defaultRouter;
        }
        if (this.useRouterForAll) {
            return this.router;
        }
        if (request.getRequestURI().getScheme().equals("sip") || request.getRequestURI().getScheme().equals("sips")) {
            return this.defaultRouter;
        }
        if (this.router != null) {
            return this.router;
        }
        return this.defaultRouter;
    }

    public Router getRouter() {
        return this.router;
    }

    public boolean isAlive() {
        return !this.toExit;
    }

    protected void addMessageProcessor(MessageProcessor newMessageProcessor) throws IOException {
        this.messageProcessors.add(newMessageProcessor);
    }

    protected void removeMessageProcessor(MessageProcessor oldMessageProcessor) {
        if (this.messageProcessors.remove(oldMessageProcessor)) {
            oldMessageProcessor.stop();
        }
    }

    protected MessageProcessor[] getMessageProcessors() {
        return this.messageProcessors.toArray(new MessageProcessor[0]);
    }

    protected MessageProcessor createMessageProcessor(InetAddress ipAddress, int port2, String transport) throws IOException {
        MessageProcessor newMessageProcessor = this.messageProcessorFactory.createMessageProcessor(this, ipAddress, port2, transport);
        this.addMessageProcessor(newMessageProcessor);
        return newMessageProcessor;
    }

    protected void setMessageFactory(StackMessageFactory messageFactory) {
        this.sipMessageFactory = messageFactory;
    }

    public MessageChannel createRawMessageChannel(String sourceIpAddress, int sourcePort, Hop nextHop) throws UnknownHostException {
        MessageProcessor nextProcessor;
        Host targetHost = new Host();
        targetHost.setHostname(nextHop.getHost());
        HostPort targetHostPort = new HostPort();
        targetHostPort.setHost(targetHost);
        targetHostPort.setPort(nextHop.getPort());
        MessageChannel newChannel = null;
        Iterator<MessageProcessor> processorIterator = this.messageProcessors.iterator();
        while (processorIterator.hasNext() && newChannel == null) {
            nextProcessor = processorIterator.next();
            if (!nextHop.getTransport().equalsIgnoreCase(nextProcessor.getTransport()) || !sourceIpAddress.equals(nextProcessor.getIpAddress().getHostAddress()) || sourcePort != nextProcessor.getPort()) continue;
            try {
                newChannel = nextProcessor.createMessageChannel(targetHostPort);
            }
            catch (UnknownHostException ex) {
                if (logger.isLoggingEnabled()) {
                    logger.logException(ex);
                }
                throw ex;
            }
            catch (IOException e) {
                if (!logger.isLoggingEnabled()) continue;
                logger.logException(e);
            }
        }
        if (newChannel == null && logger.isLoggingEnabled(32)) {
            logger.logDebug("newChanne is null, messageProcessors.size = " + this.messageProcessors.size());
            processorIterator = this.messageProcessors.iterator();
            while (processorIterator.hasNext() && newChannel == null) {
                nextProcessor = processorIterator.next();
                logger.logDebug("nextProcessor:" + nextProcessor + "| transport = " + nextProcessor.getTransport() + " ipAddress=" + nextProcessor.getIpAddress() + " port=" + nextProcessor.getPort());
            }
            logger.logDebug("More info on newChannel=null");
            logger.logDebug("nextHop=" + nextHop + " sourceIp=" + sourceIpAddress + " sourcePort=" + sourcePort + " targetHostPort=" + targetHostPort);
        }
        return newChannel;
    }

    public boolean isEventForked(String ename) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("isEventForked: " + ename + " returning " + this.forkedEvents.contains(ename));
        }
        return this.forkedEvents.contains(ename);
    }

    public AddressResolver getAddressResolver() {
        return this.addressResolver;
    }

    public void setAddressResolver(AddressResolver addressResolver) {
        this.addressResolver = addressResolver;
    }

    public void setLogRecordFactory(LogRecordFactory logRecordFactory) {
        this.logRecordFactory = logRecordFactory;
    }

    public ThreadAuditor getThreadAuditor() {
        return this.threadAuditor;
    }

    public String auditStack(Set activeCallIDs, long leakedDialogTimer, long leakedTransactionTimer) {
        String auditReport = null;
        String leakedDialogs = this.auditDialogs(activeCallIDs, leakedDialogTimer);
        String leakedServerTransactions = this.auditTransactions(this.serverTransactionTable, leakedTransactionTimer);
        String leakedClientTransactions = this.auditTransactions(this.clientTransactionTable, leakedTransactionTimer);
        if (leakedDialogs != null || leakedServerTransactions != null || leakedClientTransactions != null) {
            auditReport = "SIP Stack Audit:\n" + (leakedDialogs != null ? leakedDialogs : "") + (leakedServerTransactions != null ? leakedServerTransactions : "") + (leakedClientTransactions != null ? leakedClientTransactions : "");
        }
        return auditReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String auditDialogs(Set activeCallIDs, long leakedDialogTimer) {
        LinkedList<SIPDialog> dialogs;
        String auditReport = "  Leaked dialogs:\n";
        int leakedDialogs = 0;
        long currentTime = System.currentTimeMillis();
        ConcurrentHashMap<String, SIPDialog> concurrentHashMap = this.dialogTable;
        synchronized (concurrentHashMap) {
            dialogs = new LinkedList<SIPDialog>(this.dialogTable.values());
        }
        for (SIPDialog itDialog : dialogs) {
            String callID;
            CallIdHeader callIdHeader = itDialog != null ? itDialog.getCallId() : null;
            String string = callID = callIdHeader != null ? callIdHeader.getCallId() : null;
            if (itDialog == null || callID == null || activeCallIDs.contains(callID)) continue;
            if (itDialog.auditTag == 0L) {
                itDialog.auditTag = currentTime;
                continue;
            }
            if (currentTime - itDialog.auditTag < leakedDialogTimer) continue;
            ++leakedDialogs;
            DialogState dialogState = itDialog.getState();
            String dialogReport = "dialog id: " + itDialog.getDialogId() + ", dialog state: " + (dialogState != null ? dialogState.toString() : "null");
            auditReport = auditReport + "    " + dialogReport + "\n";
            itDialog.setState(3);
            if (!logger.isLoggingEnabled(32)) continue;
            logger.logDebug("auditDialogs: leaked " + dialogReport);
        }
        auditReport = leakedDialogs > 0 ? auditReport + "    Total: " + Integer.toString(leakedDialogs) + " leaked dialogs detected and removed.\n" : null;
        return auditReport;
    }

    private String auditTransactions(ConcurrentHashMap transactionsMap, long a_nLeakedTransactionTimer) {
        String auditReport = "  Leaked transactions:\n";
        int leakedTransactions = 0;
        long currentTime = System.currentTimeMillis();
        LinkedList transactionsList = new LinkedList(transactionsMap.values());
        for (SIPTransaction sipTransaction : transactionsList) {
            if (sipTransaction == null) continue;
            if (sipTransaction.getAuditTag() == 0L) {
                sipTransaction.setAuditTag(currentTime);
                continue;
            }
            if (currentTime - sipTransaction.getAuditTag() < a_nLeakedTransactionTimer) continue;
            ++leakedTransactions;
            TransactionState transactionState = sipTransaction.getState();
            SIPRequest origRequest = sipTransaction.getOriginalRequest();
            String origRequestMethod = origRequest != null ? origRequest.getMethod() : null;
            String transactionReport = sipTransaction.getClass().getName() + ", state: " + (transactionState != null ? transactionState.toString() : "null") + ", OR: " + (origRequestMethod != null ? origRequestMethod : "null");
            auditReport = auditReport + "    " + transactionReport + "\n";
            this.removeTransaction(sipTransaction);
            if (!logger.isLoggingEnabled(32)) continue;
            logger.logDebug("auditTransactions: leaked " + transactionReport);
        }
        auditReport = leakedTransactions > 0 ? auditReport + "    Total: " + Integer.toString(leakedTransactions) + " leaked transactions detected and removed.\n" : null;
        return auditReport;
    }

    public void setNon2XXAckPassedToListener(boolean passToListener) {
        this.non2XXAckPassedToListener = passToListener;
    }

    public boolean isNon2XXAckPassedToListener() {
        return this.non2XXAckPassedToListener;
    }

    public int getActiveClientTransactionCount() {
        return this.activeClientTransactionCount.get();
    }

    public boolean isRfc2543Supported() {
        return this.rfc2543Supported;
    }

    public boolean isCancelClientTransactionChecked() {
        return this.cancelClientTransactionChecked;
    }

    public boolean isRemoteTagReassignmentAllowed() {
        return this.remoteTagReassignmentAllowed;
    }

    public Collection<Dialog> getDialogs() {
        HashSet<Dialog> dialogs = new HashSet<Dialog>();
        dialogs.addAll(this.dialogTable.values());
        dialogs.addAll(this.earlyDialogTable.values());
        return dialogs;
    }

    public Collection<Dialog> getDialogs(DialogState state) {
        HashSet<Dialog> matchingDialogs = new HashSet<Dialog>();
        if (DialogState.EARLY.equals((Object)state)) {
            matchingDialogs.addAll(this.earlyDialogTable.values());
        } else {
            Collection<SIPDialog> dialogs = this.dialogTable.values();
            for (SIPDialog dialog : dialogs) {
                if (dialog.getState() == null || !dialog.getState().equals((Object)state)) continue;
                matchingDialogs.add(dialog);
            }
        }
        return matchingDialogs;
    }

    public Dialog getReplacesDialog(ReplacesHeader replacesHeader) {
        Dialog replacesDialog;
        String cid = replacesHeader.getCallId();
        String fromTag = replacesHeader.getFromTag();
        String toTag = replacesHeader.getToTag();
        for (SIPDialog dialog : this.dialogTable.values()) {
            if (!dialog.getCallId().getCallId().equals(cid) || !fromTag.equalsIgnoreCase(dialog.lastResponseFromTag) || !toTag.equalsIgnoreCase(dialog.lastResponseToTag)) continue;
            return dialog;
        }
        StringBuilder dialogId = new StringBuilder(cid);
        if (toTag != null) {
            dialogId.append(":");
            dialogId.append(toTag);
        }
        if (fromTag != null) {
            dialogId.append(":");
            dialogId.append(fromTag);
        }
        String did = dialogId.toString().toLowerCase();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Looking for dialog " + did);
        }
        if ((replacesDialog = (Dialog)this.dialogTable.get(did)) == null) {
            for (SIPClientTransaction ctx : this.clientTransactionTable.values()) {
                if (ctx.getDialog(did) == null) continue;
                replacesDialog = ctx.getDialog(did);
                break;
            }
        }
        return replacesDialog;
    }

    public Dialog getJoinDialog(JoinHeader joinHeader) {
        String cid = joinHeader.getCallId();
        String fromTag = joinHeader.getFromTag();
        String toTag = joinHeader.getToTag();
        StringBuilder retval = new StringBuilder(cid);
        if (toTag != null) {
            retval.append(":");
            retval.append(toTag);
        }
        if (fromTag != null) {
            retval.append(":");
            retval.append(fromTag);
        }
        return this.dialogTable.get(retval.toString().toLowerCase());
    }

    public void setTimer(SipTimer timer) {
        this.timer = timer;
    }

    public SipTimer getTimer() throws IllegalStateException {
        return this.timer;
    }

    public int getReceiveUdpBufferSize() {
        return this.receiveUdpBufferSize;
    }

    public void setReceiveUdpBufferSize(int receiveUdpBufferSize) {
        this.receiveUdpBufferSize = receiveUdpBufferSize;
    }

    public int getSendUdpBufferSize() {
        return this.sendUdpBufferSize;
    }

    public void setSendUdpBufferSize(int sendUdpBufferSize) {
        this.sendUdpBufferSize = sendUdpBufferSize;
    }

    public boolean checkBranchId() {
        return this.checkBranchId;
    }

    public void setLogStackTraceOnMessageSend(boolean logStackTraceOnMessageSend) {
        this.logStackTraceOnMessageSend = logStackTraceOnMessageSend;
    }

    public boolean isLogStackTraceOnMessageSend() {
        return this.logStackTraceOnMessageSend;
    }

    public void setDeliverDialogTerminatedEventForNullDialog() {
        this.isDialogTerminatedEventDeliveredForNullDialog = true;
    }

    public void addForkedClientTransaction(SIPClientTransaction clientTransaction) {
        String forkId = ((SIPRequest)clientTransaction.getRequest()).getForkId();
        clientTransaction.setForkId(forkId);
        if (logger.isLoggingEnabled(32)) {
            logger.logStackTrace();
            logger.logDebug("Adding forked client transaction : " + clientTransaction + " branch=" + clientTransaction.getBranch() + " forkId = " + forkId + "  sipDialog = " + clientTransaction.getDefaultDialog() + " sipDialogId= " + clientTransaction.getDefaultDialog().getDialogId());
        }
        this.forkedClientTransactionTable.put(forkId, clientTransaction);
    }

    public SIPClientTransaction getForkedTransaction(String transactionId) {
        return this.forkedClientTransactionTable.get(transactionId);
    }

    public void setDeliverUnsolicitedNotify(boolean deliverUnsolicitedNotify) {
        this.deliverUnsolicitedNotify = deliverUnsolicitedNotify;
    }

    public boolean isDeliverUnsolicitedNotify() {
        return this.deliverUnsolicitedNotify;
    }

    public void setDeliverTerminatedEventForAck(boolean deliverTerminatedEventForAck) {
        this.deliverTerminatedEventForAck = deliverTerminatedEventForAck;
    }

    public boolean isDeliverTerminatedEventForAck() {
        return this.deliverTerminatedEventForAck;
    }

    public long getMinKeepAliveInterval() {
        return this.minKeepAliveInterval;
    }

    public void setPatchWebSocketHeaders(Boolean patchWebSocketHeaders) {
        this.patchWebSocketHeaders = patchWebSocketHeaders;
    }

    public boolean isPatchWebSocketHeaders() {
        return this.patchWebSocketHeaders;
    }

    public void setPatchRport(Boolean patchRport) {
        this.patchRport = patchRport;
    }

    public boolean isPatchRport() {
        return this.patchRport;
    }

    public void setMaxForkTime(int maxForkTime) {
        this.maxForkTime = maxForkTime;
    }

    public int getMaxForkTime() {
        return this.maxForkTime;
    }

    public boolean isDeliverRetransmittedAckToListener() {
        return this.deliverRetransmittedAckToListener;
    }

    public int getAckTimeoutFactor() {
        if (this.getSipListener() != null && this.getSipListener() instanceof SipListenerExt) {
            return this.dialogTimeoutFactor;
        }
        return 64;
    }

    public abstract SipListener getSipListener();

    public ExecutorService getReinviteExecutor() {
        return this.reinviteExecutor;
    }

    public void setMessageParserFactory(MessageParserFactory messageParserFactory) {
        this.messageParserFactory = messageParserFactory;
    }

    public MessageParserFactory getMessageParserFactory() {
        return this.messageParserFactory;
    }

    public void setMessageProcessorFactory(MessageProcessorFactory messageProcessorFactory) {
        this.messageProcessorFactory = messageProcessorFactory;
    }

    public MessageProcessorFactory getMessageProcessorFactory() {
        return this.messageProcessorFactory;
    }

    public void setAggressiveCleanup(boolean aggressiveCleanup) {
        this.releaseReferencesStrategy = aggressiveCleanup ? ReleaseReferencesStrategy.Normal : ReleaseReferencesStrategy.None;
    }

    public boolean isAggressiveCleanup() {
        return this.releaseReferencesStrategy != ReleaseReferencesStrategy.None;
    }

    public int getEarlyDialogTimeout() {
        return this.earlyDialogTimeout;
    }

    public void setClientAuth(ClientAuthType clientAuth) {
        this.clientAuth = clientAuth;
    }

    public ClientAuthType getClientAuth() {
        return this.clientAuth;
    }

    public void setThreadPriority(int threadPriority) {
        if (threadPriority < 1) {
            throw new IllegalArgumentException("The Stack Thread Priority shouldn't be lower than Thread.MIN_PRIORITY");
        }
        if (threadPriority > 10) {
            throw new IllegalArgumentException("The Stack Thread Priority shouldn't be higher than Thread.MAX_PRIORITY");
        }
        if (logger.isLoggingEnabled(16)) {
            logger.logInfo("Setting Stack Thread priority to " + threadPriority);
        }
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public int getReliableConnectionKeepAliveTimeout() {
        return this.reliableConnectionKeepAliveTimeout;
    }

    public void setReliableConnectionKeepAliveTimeout(int reliableConnectionKeepAliveTimeout) {
        if (reliableConnectionKeepAliveTimeout == 0) {
            if (logger.isLoggingEnabled(16)) {
                logger.logInfo("Default value (840000 ms) will be used for reliableConnectionKeepAliveTimeout stack property");
            }
            reliableConnectionKeepAliveTimeout = 840000;
        }
        if (logger.isLoggingEnabled(16)) {
            logger.logInfo("value " + reliableConnectionKeepAliveTimeout + " will be used for reliableConnectionKeepAliveTimeout stack property");
        }
        this.reliableConnectionKeepAliveTimeout = reliableConnectionKeepAliveTimeout;
    }

    private MessageProcessor findMessageProcessor(String myAddress, int myPort, String transport) {
        for (MessageProcessor processor : this.getMessageProcessors()) {
            if (!processor.getTransport().equalsIgnoreCase(transport) || !processor.getSavedIpAddress().equals(myAddress) || processor.getPort() != myPort) continue;
            return processor;
        }
        return null;
    }

    public boolean setKeepAliveTimeout(String myAddress, int myPort, String transport, String peerAddress, int peerPort, long keepAliveTimeout) {
        MessageProcessor processor = this.findMessageProcessor(myAddress, myPort, transport);
        if (processor == null || !(processor instanceof ConnectionOrientedMessageProcessor)) {
            return false;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("~~~ Trying to find MessageChannel and set new KeepAliveTimeout( myAddress=" + myAddress + ", myPort=" + myPort + ", transport=" + transport + ", peerAddress=" + peerAddress + ", peerPort=" + peerPort + ", keepAliveTimeout=" + keepAliveTimeout + "), MessageProcessor=" + processor);
        }
        return ((ConnectionOrientedMessageProcessor)processor).setKeepAliveTimeout(peerAddress, peerPort, keepAliveTimeout);
    }

    public boolean closeReliableConnection(String myAddress, int myPort, String transport, String peerAddress, int peerPort) {
        MessageProcessor processor = this.findMessageProcessor(myAddress, myPort, transport);
        if (processor != null && processor instanceof ConnectionOrientedMessageProcessor) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("~~~ closeReliableConnection( myAddress=" + myAddress + ", myPort=" + myPort + ", transport=" + transport + ", peerAddress=" + peerAddress + ", peerPort=" + peerPort + "), MessageProcessor=" + processor);
            }
            return ((ConnectionOrientedMessageProcessor)processor).closeReliableConnection(peerAddress, peerPort);
        }
        return false;
    }

    public long getSslHandshakeTimeout() {
        return this.sslHandshakeTimeout;
    }

    public void setSslHandshakeTimeout(long sslHandshakeTimeout) {
        this.sslHandshakeTimeout = sslHandshakeTimeout;
    }

    public void setEarlyDialogTimeout(int earlyDialogTimeout) {
        this.earlyDialogTimeout = earlyDialogTimeout;
    }

    public int getMaxTxLifetimeInvite() {
        return this.maxTxLifetimeInvite;
    }

    public void setMaxTxLifetimeInvite(int maxTxLifetimeInvite) {
        this.maxTxLifetimeInvite = maxTxLifetimeInvite;
    }

    public int getMaxTxLifetimeNonInvite() {
        return this.maxTxLifetimeNonInvite;
    }

    public void setMaxTxLifetimeNonInvite(int maxTxLifetimeNonInvite) {
        this.maxTxLifetimeNonInvite = maxTxLifetimeNonInvite;
    }

    public boolean isSslRenegotiationEnabled() {
        return this.sslRenegotiationEnabled;
    }

    public void setSslRenegotiationEnabled(boolean sslRenegotiationEnabled) {
        this.sslRenegotiationEnabled = sslRenegotiationEnabled;
    }

    public int getConnectionLingerTimer() {
        return connectionLingerTimer;
    }

    public void setConnectionLingerTimer(int connectionLingerTimer) {
        SIPTransactionStack.connectionLingerTimer = connectionLingerTimer;
    }

    public int getStackCongestionControlTimeout() {
        return this.stackCongestionControlTimeout;
    }

    public void setStackCongestionControlTimeout(int stackCongestionControlTimeout) {
        this.stackCongestionControlTimeout = stackCongestionControlTimeout;
    }

    public ReleaseReferencesStrategy getReleaseReferencesStrategy() {
        return this.releaseReferencesStrategy;
    }

    public void setReleaseReferencesStrategy(ReleaseReferencesStrategy releaseReferencesStrategy) {
        this.releaseReferencesStrategy = releaseReferencesStrategy;
    }

    static {
        dialogCreatingMethods.add("REFER");
        dialogCreatingMethods.add("INVITE");
        dialogCreatingMethods.add("SUBSCRIBE");
    }

    class RemoveForkedTransactionTimerTask
    extends SIPStackTimerTask {
        private final String forkId;

        public RemoveForkedTransactionTimerTask(String forkId) {
            this.forkId = forkId;
        }

        @Override
        public void runTask() {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Removing forked client transaction : forkId = " + this.forkId);
            }
            SIPTransactionStack.this.forkedClientTransactionTable.remove(this.forkId);
        }
    }

    protected class PingTimer
    extends SIPStackTimerTask {
        ThreadAuditor.ThreadHandle threadHandle;

        public PingTimer(ThreadAuditor.ThreadHandle a_oThreadHandle) {
            this.threadHandle = a_oThreadHandle;
        }

        @Override
        public void runTask() {
            if (SIPTransactionStack.this.getTimer() != null) {
                if (this.threadHandle == null && SIPTransactionStack.this.getThreadAuditor() != null) {
                    this.threadHandle = SIPTransactionStack.this.getThreadAuditor().addCurrentThread();
                }
                this.threadHandle.ping();
                SIPTransactionStack.this.getTimer().schedule(new PingTimer(this.threadHandle), this.threadHandle.getPingIntervalInMillisecs());
            }
        }
    }

    private static class SameThreadExecutor
    implements Executor {
        private SameThreadExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

